/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.service.servable;

import com.alipay.oasis.biz.service.impl.gateway.data.container.DataContainer;
import com.alipay.oasis.biz.service.impl.gateway.oasiscall.enclaveservice.EnclaveParam;
import com.alipay.oasis.biz.service.impl.gateway.oasiscall.enclaveservice.EnclaveServiceClient;
import com.alipay.oasis.biz.service.impl.gateway.service.servable.ServableCommon;
import com.alipay.oasis.biz.shared.rpc.RpcInvokeContextHelper;
import com.alipay.oasis.common.dal.mysql.daointerface.ClusterManagerInfoDAO;
import com.alipay.oasis.common.dal.mysql.dataobject.EnclaveNodeDO;
import com.alipay.oasis.common.service.facade.cluster.manager.ForGatewayTrService;
import com.alipay.oasis.common.service.facade.service.provider.TrustedTrService;
import com.alipay.oasis.common.util.config.OasisAppConfiguration;
import com.alipay.oasis.common.util.header.Header;
import com.alipay.oasis.common.util.header.HeaderBuilder;
import com.alipay.oasis.common.util.service.Servable;
import com.alipay.oasis.proto.Common;
import com.alipay.oasis.proto.SgxCommon;
import com.alipay.oasis.proto.cluster.manager.ClusterManagerGateway;
import com.alipay.oasis.proto.gateway.Gateway;
import com.alipay.oasis.proto.serviceprovider.ServiceProvider;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Map;

public class ServableRaFetchMsg1Impl
implements Servable<Gateway.GatewayRaFetchMsg1Request, Gateway.GatewayRaFetchMsg1Response> {
    private final DataContainer dataContainer;
    private final ForGatewayTrService forGatewayTrService;
    private final ClusterManagerInfoDAO clusterManagerInfoDAO;
    private final TrustedTrService trustedTrService;
    private final RpcInvokeContextHelper rpcInvokeContextHelper;
    private final OasisAppConfiguration oasisAppConfiguration;

    public ServableRaFetchMsg1Impl(DataContainer dataContainer, ForGatewayTrService forGatewayTrService, ClusterManagerInfoDAO clusterManagerInfoDAO, TrustedTrService trustedTrService, RpcInvokeContextHelper rpcInvokeContextHelper, OasisAppConfiguration oasisAppConfiguration) {
        this.dataContainer = dataContainer;
        this.forGatewayTrService = forGatewayTrService;
        this.clusterManagerInfoDAO = clusterManagerInfoDAO;
        this.trustedTrService = trustedTrService;
        this.rpcInvokeContextHelper = rpcInvokeContextHelper;
        this.oasisAppConfiguration = oasisAppConfiguration;
    }

    public Gateway.GatewayRaFetchMsg1Response call(Gateway.GatewayRaFetchMsg1Request request, Header header, Map<String, Object> context) throws Exception {
        String topicId = request.getTopicId();
        Common.RequestHeader requestHeader = HeaderBuilder.buildRequestHeader((Header)header);
        ClusterManagerGateway.CreateSessionResponse createSessionResponse = this.createSession(topicId, requestHeader);
        String sessionId = createSessionResponse.getSessionId();
        String enclaveNodeClusterId = createSessionResponse.getEnclaveNodeClusterId();
        EnclaveNodeDO leaderEnclave = this.dataContainer.getLeaderEnclave(sessionId);
        if (leaderEnclave == null) {
            String errMsg = "No leader for session [" + sessionId + "]. Can not get enclave for fetching msg1";
            throw new Exception(errMsg);
        }
        EnclaveParam enclaveParam = new EnclaveParam(leaderEnclave.fetchStructInfoCopy().getHost(), topicId, leaderEnclave.getEnclaveNodeId());
        Gateway.GatewayRaFetchMsg1Response raFetchMsg1Response = this.raFetchMsg1Inner(enclaveParam, sessionId, request, header);
        SgxCommon.SgxSpid sgxSpid = this.getSpid(request, header, enclaveNodeClusterId);
        return this.insertSPIDToMsg1Response(raFetchMsg1Response, sgxSpid);
    }

    ClusterManagerGateway.CreateSessionResponse createSession(String topicId, Common.RequestHeader requestHeader) throws Exception {
        ClusterManagerGateway.CreateSessionRequest createSessionRequest = ClusterManagerGateway.CreateSessionRequest.newBuilder().setTopicId(topicId).setHeader(requestHeader).build();
        ClusterManagerGateway.CreateSessionResponse createSessionResponse = this.createSessionInner(createSessionRequest);
        if (!createSessionResponse.getHeader().getIsSuccess()) {
            String errMsg = "Failed to create session for topic [" + topicId + "]. " + createSessionResponse.getHeader().getErrorMsg();
            throw new Exception(errMsg);
        }
        return createSessionResponse;
    }

    Gateway.GatewayRaFetchMsg1Response raFetchMsg1Inner(EnclaveParam enclaveParam, String sessionId, Gateway.GatewayRaFetchMsg1Request request, Header header) throws InvalidProtocolBufferException {
        return EnclaveServiceClient.raFetchMsg1(enclaveParam, sessionId, request, header);
    }

    Gateway.GatewayRaFetchMsg1Response insertSPIDToMsg1Response(Gateway.GatewayRaFetchMsg1Response response, SgxCommon.SgxSpid sgxSpid) {
        if (!response.hasMsg1()) {
            return response;
        }
        Gateway.GatewayRaFetchMsg1Response.Builder builder = response.toBuilder();
        builder.getMsg1Builder().setSpid(sgxSpid);
        return builder.build();
    }

    SgxCommon.SgxSpid getSpid(Gateway.GatewayRaFetchMsg1Request request, Header header, String callerId) throws Exception {
        ServiceProvider.RaFetchSpidRequest raFetchSpidRequest = ServiceProvider.RaFetchSpidRequest.newBuilder().setCallerId(callerId).setHeader(HeaderBuilder.buildRequestHeader((Header)header)).setUseDevelopCertificate(request.getUseDevelopCertificate()).build();
        ServiceProvider.RaFetchSpidResponse raFetchSpidResponse = this.trustedTrService.raFetchSpid(raFetchSpidRequest);
        if (!raFetchSpidResponse.getHeader().getIsSuccess()) {
            String errMsg = "Failed to get spid. " + raFetchSpidResponse.getHeader().getErrorMsg();
            throw new Exception(errMsg);
        }
        return raFetchSpidResponse.getSgxSpid();
    }

    ClusterManagerGateway.CreateSessionResponse createSessionInner(ClusterManagerGateway.CreateSessionRequest request) {
        String cmHost = ServableCommon.getZoneCmHost(this.clusterManagerInfoDAO, this.oasisAppConfiguration.getZoneName());
        this.rpcInvokeContextHelper.setTargetUrl(cmHost);
        return this.forGatewayTrService.createSession(request);
    }
}

