/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.service.servable;

import com.alipay.oasis.biz.service.impl.gateway.data.container.DataContainer;
import com.alipay.oasis.biz.service.impl.gateway.oasiscall.enclaveservice.EnclaveParam;
import com.alipay.oasis.biz.service.impl.gateway.oasiscall.enclaveservice.EnclaveServiceClient;
import com.alipay.oasis.biz.service.impl.gateway.oasiscall.remotegateway.RemoteGatewayManager;
import com.alipay.oasis.biz.service.impl.gateway.service.servable.ServableCommon;
import com.alipay.oasis.common.dal.mysql.daointerface.EnclaveConfigDAO;
import com.alipay.oasis.common.dal.mysql.daointerface.EnclaveConfigMapDAO;
import com.alipay.oasis.common.dal.mysql.daointerface.SceneDAO;
import com.alipay.oasis.common.dal.mysql.dataobject.EnclaveNodeDO;
import com.alipay.oasis.common.dal.mysql.doinfo.EnclaveNodeInfo;
import com.alipay.oasis.common.util.config.OasisAppConfiguration;
import com.alipay.oasis.common.util.exception.UnexpectException;
import com.alipay.oasis.common.util.header.Header;
import com.alipay.oasis.common.util.service.Servable;
import com.alipay.oasis.proto.Common;
import com.alipay.oasis.proto.gateway.Gateway;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Map;

public class ServableRaBizQueryV2Impl
implements Servable<Gateway.GatewayRaBizQueryRequestV2, Gateway.GatewayRaBizQueryResponseV2> {
    private final DataContainer dataContainer;
    private final RemoteGatewayManager remoteGatewayManager;
    private final EnclaveConfigDAO enclaveConfigDAO;
    private final EnclaveConfigMapDAO enclaveConfigMapDAO;
    private final SceneDAO sceneDAO;
    private final OasisAppConfiguration oasisAppConfiguration;

    public ServableRaBizQueryV2Impl(DataContainer dataContainer, RemoteGatewayManager remoteGatewayManager, EnclaveConfigDAO enclaveConfigDAO, EnclaveConfigMapDAO enclaveConfigMapDAO, SceneDAO sceneDAO, OasisAppConfiguration oasisAppConfiguration) {
        this.dataContainer = dataContainer;
        this.remoteGatewayManager = remoteGatewayManager;
        this.enclaveConfigDAO = enclaveConfigDAO;
        this.enclaveConfigMapDAO = enclaveConfigMapDAO;
        this.sceneDAO = sceneDAO;
        this.oasisAppConfiguration = oasisAppConfiguration;
    }

    public Gateway.GatewayRaBizQueryResponseV2 call(Gateway.GatewayRaBizQueryRequestV2 request, Header header, Map<String, Object> context) throws Exception {
        ServableCommon.EnclaveNodeWithConfig enclaveNodeWithConfig = this.getEnclaveNodeAndConfig(request);
        EnclaveNodeDO enclaveNodeForBizQuery = enclaveNodeWithConfig.getEnclaveNodeDO();
        EnclaveNodeInfo enclaveNodeInfo = enclaveNodeForBizQuery.fetchStructInfoCopy();
        String zone = enclaveNodeInfo.getZone();
        if (!this.oasisAppConfiguration.isSelfZone(zone)) {
            return this.remoteGatewayManager.getGatewayTrServiceByZoneName(zone).raBizQueryV2(request);
        }
        EnclaveParam enclaveParam = new EnclaveParam(enclaveNodeInfo.getHost(), request.getTopicId(), enclaveNodeForBizQuery.getEnclaveNodeId());
        return this.raBizQueryInner(enclaveParam, request, header, enclaveNodeWithConfig.getEnclaveConfigMetaInfo());
    }

    ServableCommon.EnclaveNodeWithConfig getEnclaveNodeAndConfig(Gateway.GatewayRaBizQueryRequestV2 request) {
        EnclaveNodeDO enclaveNodeForBizQuery = null;
        String clusterId = null;
        clusterId = request.hasClusterId() ? request.getClusterId() : this.dataContainer.getEnclaveNodeClusterIdByTopicId(request.getTopicId());
        if (request.hasScene()) {
            ServableCommon.validateSceneAndTopic(this.sceneDAO, request.getScene(), request.getTopicId());
            ServableCommon.EnclaveNodeWithConfig enclaveNodeWithConfig = ServableCommon.getEnclaveNodeByScene(this.dataContainer, this.enclaveConfigDAO, this.enclaveConfigMapDAO, this.oasisAppConfiguration, request.getScene().getSceneId());
            if (enclaveNodeWithConfig.getEnclaveNodeDO() == null) {
                throw new UnexpectException("Can not get an legal enclave for biz query");
            }
            return enclaveNodeWithConfig;
        }
        enclaveNodeForBizQuery = ServableCommon.getEnclaveNodeByClusterId(this.dataContainer, this.oasisAppConfiguration, clusterId);
        if (enclaveNodeForBizQuery == null) {
            throw new UnexpectException("Can not get an legal enclave for biz query");
        }
        return new ServableCommon.EnclaveNodeWithConfig(enclaveNodeForBizQuery, null);
    }

    Gateway.GatewayRaBizQueryResponseV2 raBizQueryInner(EnclaveParam enclaveParam, Gateway.GatewayRaBizQueryRequestV2 request, Header header, Common.EnclaveConfigMetaInfo enclaveConfigMetaInfo) throws InvalidProtocolBufferException {
        return EnclaveServiceClient.raBizQueryV2(enclaveParam, request, header, enclaveConfigMetaInfo);
    }
}

