/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.service.servable;

import com.alipay.oasis.biz.service.impl.gateway.service.servable.ServableCommon;
import com.alipay.oasis.common.dal.mysql.daointerface.EnclaveConfigDAO;
import com.alipay.oasis.common.dal.mysql.daointerface.EnclaveConfigMapDAO;
import com.alipay.oasis.common.dal.mysql.daointerface.SceneDAO;
import com.alipay.oasis.common.dal.mysql.dataobject.EnclaveConfigDO;
import com.alipay.oasis.common.dal.mysql.dataobject.EnclaveConfigMapDO;
import com.alipay.oasis.common.dal.mysql.dataobject.EnclaveConfigMapStatus;
import com.alipay.oasis.common.util.exception.UnexpectException;
import com.alipay.oasis.common.util.header.Header;
import com.alipay.oasis.common.util.service.Servable;
import com.alipay.oasis.proto.Common;
import com.alipay.oasis.proto.gateway.Gateway;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ServableQueryEnclaveConfigInfoImpl
implements Servable<Gateway.GatewayQueryEnclaveConfigInfoRequest, Gateway.GatewayQueryEnclaveConfigInfoResponse> {
    private final SceneDAO sceneDAO;
    private final EnclaveConfigDAO enclaveConfigDAO;
    private final EnclaveConfigMapDAO enclaveConfigMapDAO;

    public ServableQueryEnclaveConfigInfoImpl(SceneDAO sceneDAO, EnclaveConfigDAO enclaveConfigDAO, EnclaveConfigMapDAO enclaveConfigMapDAO) {
        this.sceneDAO = sceneDAO;
        this.enclaveConfigDAO = enclaveConfigDAO;
        this.enclaveConfigMapDAO = enclaveConfigMapDAO;
    }

    public Gateway.GatewayQueryEnclaveConfigInfoResponse call(Gateway.GatewayQueryEnclaveConfigInfoRequest request, Header header, Map<String, Object> context) throws Exception {
        ServableCommon.validateSceneAndTopic(this.sceneDAO, request.getScene(), request.getTopicId());
        List<EnclaveConfigDO> enclaveConfigDOList = this.getEnclaveConfigDOList(request);
        List<Gateway.GatewayQueryEnclaveConfigInfoResponse.EnclaveConfigInfo> enclaveConfigInfoList = this.getEnclaveConfigInfos(enclaveConfigDOList);
        Gateway.GatewayQueryEnclaveConfigInfoResponse.Builder builder = Gateway.GatewayQueryEnclaveConfigInfoResponse.newBuilder();
        builder.addAllEnclaveConfigInfoList(enclaveConfigInfoList);
        builder.setHeader(ServableCommon.buildSuccessResponseHeader());
        return builder.build();
    }

    List<Gateway.GatewayQueryEnclaveConfigInfoResponse.EnclaveConfigInfo> getEnclaveConfigInfos(List<EnclaveConfigDO> enclaveConfigDOList) {
        ArrayList<Gateway.GatewayQueryEnclaveConfigInfoResponse.EnclaveConfigInfo> enclaveConfigInfoList = new ArrayList<Gateway.GatewayQueryEnclaveConfigInfoResponse.EnclaveConfigInfo>(enclaveConfigDOList.size());
        for (EnclaveConfigDO enclaveConfigDO : enclaveConfigDOList) {
            Gateway.GatewayQueryEnclaveConfigInfoResponse.EnclaveConfigInfo.Builder enclaveConfigInfoBuilder = Gateway.GatewayQueryEnclaveConfigInfoResponse.EnclaveConfigInfo.newBuilder();
            enclaveConfigInfoBuilder.setEnclaveConfigMetaInfo(ServableCommon.buildEnclaveConfigMetaInfo(enclaveConfigDO));
            enclaveConfigInfoBuilder.setEnclaveConfigStatus(Common.EnclaveConfigStatus.valueOf((String)enclaveConfigDO.getConfigStatus()));
            enclaveConfigInfoBuilder.setEnclaveConfigLoadStatus(Gateway.GatewayQueryEnclaveConfigInfoResponse.EnclaveConfigInfo.EnclaveConfigLoadStatus.NOT_LOADED);
            List enclaveConfigMapDOList = this.enclaveConfigMapDAO.queryByEnclaveConfigId(enclaveConfigDO.getConfigId());
            int loadedCount = 0;
            for (EnclaveConfigMapDO enclaveConfigMapDO : enclaveConfigMapDOList) {
                if (EnclaveConfigMapStatus.valueOf((String)enclaveConfigMapDO.getStatus()) != EnclaveConfigMapStatus.LOADED) continue;
                enclaveConfigInfoBuilder.setEnclaveConfigLoadStatus(Gateway.GatewayQueryEnclaveConfigInfoResponse.EnclaveConfigInfo.EnclaveConfigLoadStatus.LOADING);
                ++loadedCount;
                break;
            }
            if (loadedCount == enclaveConfigMapDOList.size()) {
                enclaveConfigInfoBuilder.setEnclaveConfigLoadStatus(Gateway.GatewayQueryEnclaveConfigInfoResponse.EnclaveConfigInfo.EnclaveConfigLoadStatus.LOADED);
            }
            enclaveConfigInfoList.add(enclaveConfigInfoBuilder.build());
        }
        return enclaveConfigInfoList;
    }

    List<EnclaveConfigDO> getEnclaveConfigDOList(Gateway.GatewayQueryEnclaveConfigInfoRequest request) {
        List enclaveConfigMetaInfoList = request.getEnclaveConfigMetaInfoListList();
        if (enclaveConfigMetaInfoList.isEmpty()) {
            return this.enclaveConfigDAO.queryBySceneId(request.getScene().getSceneId());
        }
        ArrayList<EnclaveConfigDO> enclaveConfigDOList = new ArrayList<EnclaveConfigDO>(enclaveConfigMetaInfoList.size());
        for (Common.EnclaveConfigMetaInfo enclaveConfigMetaInfo : enclaveConfigMetaInfoList) {
            EnclaveConfigDO enclaveConfigDO = this.enclaveConfigDAO.querySingle(enclaveConfigMetaInfo.getConfigUuid());
            if (enclaveConfigDO == null) {
                throw new UnexpectException("Unknown enclave config id[" + enclaveConfigMetaInfo.getConfigUuid() + "]");
            }
            enclaveConfigDOList.add(enclaveConfigDO);
        }
        return enclaveConfigDOList;
    }
}

