/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.service.servable;

import com.alipay.oasis.biz.service.impl.gateway.data.container.DataContainer;
import com.alipay.oasis.biz.service.impl.gateway.service.servable.ServableCommon;
import com.alipay.oasis.common.dal.mysql.daointerface.EnclaveNodeClusterTopicDAO;
import com.alipay.oasis.common.dal.mysql.dataobject.EnclaveNodeClusterTopicDO;
import com.alipay.oasis.common.dal.mysql.dataobject.EnclaveNodeDO;
import com.alipay.oasis.common.util.header.Header;
import com.alipay.oasis.common.util.logger.AppLogger;
import com.alipay.oasis.common.util.logger.AppLoggerFactory;
import com.alipay.oasis.common.util.service.Servable;
import com.alipay.oasis.proto.Common;
import com.alipay.oasis.proto.heartbeat.Heartbeat;
import com.google.protobuf.ProtocolStringList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class ServableHeartbeatImpl
implements Servable<Heartbeat.HeartbeatRequest, Heartbeat.HeartbeatResponse> {
    private static final AppLogger LOGGER = AppLoggerFactory.getLogger(ServableHeartbeatImpl.class);
    private final DataContainer dataContainer;
    private final EnclaveNodeClusterTopicDAO enclaveNodeClusterTopicDAO;

    public ServableHeartbeatImpl(DataContainer dataContainer, EnclaveNodeClusterTopicDAO enclaveNodeClusterTopicDAO) {
        this.dataContainer = dataContainer;
        this.enclaveNodeClusterTopicDAO = enclaveNodeClusterTopicDAO;
    }

    public Heartbeat.HeartbeatResponse call(Heartbeat.HeartbeatRequest request, Header header, Map<String, Object> context) throws Exception {
        List enclaveNodeClusterTopicDOList;
        String topicId = request.getTopicId();
        ProtocolStringList tunnelClusterIdsList = request.getTunnelClusterIdsList();
        if (CollectionUtils.isEmpty((Collection)tunnelClusterIdsList)) {
            LOGGER.warn(header.isLoadtest(), topicId, null, this.getClass().getSimpleName(), new Object[]{"Client side clusterIdList is empty " + topicId});
        }
        if (CollectionUtils.isEmpty((Collection)(enclaveNodeClusterTopicDOList = this.enclaveNodeClusterTopicDAO.queryByTopic(topicId)))) {
            throw new Exception("No enclave node cluster for topic [" + topicId + "]. Heartbeat failed!");
        }
        ArrayList<String> serverSideClusterIdsList = new ArrayList<String>(16);
        for (EnclaveNodeClusterTopicDO enclaveNodeClusterTopicDO : enclaveNodeClusterTopicDOList) {
            String clusterId = enclaveNodeClusterTopicDO.getEnclaveNodeClusterId();
            List<EnclaveNodeDO> enclaveNodeDOList = this.dataContainer.getEnclaveNodes(clusterId);
            if (CollectionUtils.isEmpty(enclaveNodeDOList)) {
                LOGGER.warn(header.isLoadtest(), clusterId, null, this.getClass().getSimpleName(), new Object[]{"Empty enclave node list for clusterId : " + clusterId});
                continue;
            }
            serverSideClusterIdsList.add(clusterId);
        }
        Common.ResponseHeader responseHeader = ServableCommon.buildSuccessResponseHeader();
        return Heartbeat.HeartbeatResponse.newBuilder().setHeader(responseHeader).addAllEnclaveClusterIds(serverSideClusterIdsList).build();
    }
}

