/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.service.servable;

import com.alipay.oasis.biz.service.impl.gateway.service.servable.ServableCommon;
import com.alipay.oasis.biz.shared.rpc.RpcInvokeContextHelper;
import com.alipay.oasis.common.dal.mysql.daointerface.ClusterManagerInfoDAO;
import com.alipay.oasis.common.dal.mysql.daointerface.EnclaveConfigDAO;
import com.alipay.oasis.common.dal.mysql.daointerface.SceneDAO;
import com.alipay.oasis.common.dal.mysql.dataobject.EnclaveConfigDO;
import com.alipay.oasis.common.service.facade.cluster.manager.ForGatewayTrService;
import com.alipay.oasis.common.util.config.OasisAppConfiguration;
import com.alipay.oasis.common.util.exception.UnexpectException;
import com.alipay.oasis.common.util.header.Header;
import com.alipay.oasis.common.util.service.Servable;
import com.alipay.oasis.proto.Common;
import com.alipay.oasis.proto.gateway.Gateway;
import java.util.Map;

public class ServableGoOfflineEnclaveConfigImpl
implements Servable<Gateway.GatewayGoOfflineEnclaveConfigRequest, Gateway.GatewayGoOfflineEnclaveConfigResponse> {
    private final ForGatewayTrService forGatewayTrService;
    private final ClusterManagerInfoDAO clusterManagerInfoDAO;
    private final SceneDAO sceneDAO;
    private final EnclaveConfigDAO enclaveConfigDAO;
    private final OasisAppConfiguration oasisAppConfiguration;
    private final RpcInvokeContextHelper rpcInvokeContextHelper;

    public ServableGoOfflineEnclaveConfigImpl(ForGatewayTrService forGatewayTrService, ClusterManagerInfoDAO clusterManagerInfoDAO, SceneDAO sceneDAO, EnclaveConfigDAO enclaveConfigDAO, OasisAppConfiguration oasisAppConfiguration, RpcInvokeContextHelper rpcInvokeContextHelper) {
        this.forGatewayTrService = forGatewayTrService;
        this.clusterManagerInfoDAO = clusterManagerInfoDAO;
        this.sceneDAO = sceneDAO;
        this.enclaveConfigDAO = enclaveConfigDAO;
        this.oasisAppConfiguration = oasisAppConfiguration;
        this.rpcInvokeContextHelper = rpcInvokeContextHelper;
    }

    public Gateway.GatewayGoOfflineEnclaveConfigResponse call(Gateway.GatewayGoOfflineEnclaveConfigRequest request, Header header, Map<String, Object> context) throws Exception {
        ServableCommon.validateSceneAndTopic(this.sceneDAO, request.getScene(), request.getTopicId());
        Common.EnclaveConfigMetaInfo enclaveConfigMetaInfo = request.getEnclaveConfigMetaInfo();
        EnclaveConfigDO configToGoOffline = ServableCommon.validateEnclaveConfigMetaInfo(enclaveConfigMetaInfo, this.enclaveConfigDAO);
        if (Common.EnclaveConfigStatus.valueOf((String)configToGoOffline.getConfigStatus()) != Common.EnclaveConfigStatus.ONLINE) {
            throw new UnexpectException("Enclave config[" + enclaveConfigMetaInfo.getConfigUuid() + "] is not online");
        }
        if (configToGoOffline.fetchStructInfoCopy().getFlowRatio() != 0) {
            throw new UnexpectException("Flow ratio of config[" + enclaveConfigMetaInfo.getConfigUuid() + "] is not zero and not allowed to go offline");
        }
        String cmHost = ServableCommon.getZoneCmHost(this.clusterManagerInfoDAO, this.oasisAppConfiguration.getZoneName());
        this.rpcInvokeContextHelper.setTargetUrl(cmHost);
        return this.forGatewayTrService.goOfflineEnclaveConfig(request);
    }
}

