/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.service.servable;

import com.alipay.oasis.biz.service.impl.gateway.service.servable.ServableCommon;
import com.alipay.oasis.biz.shared.rpc.RpcInvokeContextHelper;
import com.alipay.oasis.common.dal.mysql.daointerface.ClusterManagerInfoDAO;
import com.alipay.oasis.common.dal.mysql.daointerface.EnclaveConfigDAO;
import com.alipay.oasis.common.dal.mysql.daointerface.SceneDAO;
import com.alipay.oasis.common.service.facade.cluster.manager.ForGatewayTrService;
import com.alipay.oasis.common.util.config.OasisAppConfiguration;
import com.alipay.oasis.common.util.exception.UnexpectException;
import com.alipay.oasis.common.util.header.Header;
import com.alipay.oasis.common.util.service.Servable;
import com.alipay.oasis.proto.Common;
import com.alipay.oasis.proto.gateway.Gateway;
import java.util.List;
import java.util.Map;

public class ServableGoLiveEnclaveConfigImpl
implements Servable<Gateway.GatewayGoLiveEnclaveConfigRequest, Gateway.GatewayGoLiveEnclaveConfigResponse> {
    private static final int MAX_ONLINE_CONFIG_COUNT = 5;
    private final ForGatewayTrService forGatewayTrService;
    private final ClusterManagerInfoDAO clusterManagerInfoDAO;
    private final SceneDAO sceneDAO;
    private final EnclaveConfigDAO enclaveConfigDAO;
    private final OasisAppConfiguration oasisAppConfiguration;
    private final RpcInvokeContextHelper rpcInvokeContextHelper;

    public ServableGoLiveEnclaveConfigImpl(ForGatewayTrService forGatewayTrService, ClusterManagerInfoDAO clusterManagerInfoDAO, SceneDAO sceneDAO, EnclaveConfigDAO enclaveConfigDAO, OasisAppConfiguration oasisAppConfiguration, RpcInvokeContextHelper rpcInvokeContextHelper) {
        this.forGatewayTrService = forGatewayTrService;
        this.clusterManagerInfoDAO = clusterManagerInfoDAO;
        this.sceneDAO = sceneDAO;
        this.enclaveConfigDAO = enclaveConfigDAO;
        this.oasisAppConfiguration = oasisAppConfiguration;
        this.rpcInvokeContextHelper = rpcInvokeContextHelper;
    }

    public Gateway.GatewayGoLiveEnclaveConfigResponse call(Gateway.GatewayGoLiveEnclaveConfigRequest request, Header header, Map<String, Object> context) throws Exception {
        ServableCommon.validateSceneAndTopic(this.sceneDAO, request.getScene(), request.getTopicId());
        List enclaveConfigDOList = this.enclaveConfigDAO.queryBySceneId(request.getScene().getSceneId());
        if (enclaveConfigDOList.size() >= 5) {
            throw new UnexpectException("The count of online enclave configs is more than 5");
        }
        Common.EnclaveConfigMetaInfo enclaveConfigMetaInfo = request.getEnclaveConfigMetaInfo();
        if (!enclaveConfigMetaInfo.hasConfigSource()) {
            throw new UnexpectException("No config source in request");
        }
        String cmHost = ServableCommon.getZoneCmHost(this.clusterManagerInfoDAO, this.oasisAppConfiguration.getZoneName());
        this.rpcInvokeContextHelper.setTargetUrl(cmHost);
        return this.forGatewayTrService.goLiveEnclaveConfig(request);
    }
}

