/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.service.servable;

import com.alipay.oasis.biz.service.impl.gateway.data.container.DataContainer;
import com.alipay.oasis.biz.service.impl.gateway.oasiscall.remotegateway.RemoteGatewayManager;
import com.alipay.oasis.biz.service.impl.gateway.service.servable.ServableGetEnclaveReportImpl;
import com.alipay.oasis.biz.service.impl.gateway.service.servable.ServableRaFetchVerificationReportImpl;
import com.alipay.oasis.common.dal.mysql.daointerface.EnclaveNodeClusterTopicDAO;
import com.alipay.oasis.common.service.facade.service.provider.TrustedTrService;
import com.alipay.oasis.common.util.config.OasisAppConfiguration;
import com.alipay.oasis.common.util.exception.UnexpectException;
import com.alipay.oasis.common.util.header.Header;
import com.alipay.oasis.common.util.logger.AppLogger;
import com.alipay.oasis.common.util.logger.AppLoggerFactory;
import com.alipay.oasis.common.util.service.Servable;
import com.alipay.oasis.proto.Common;
import com.alipay.oasis.proto.gateway.Gateway;
import com.google.protobuf.ByteString;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ServableGetIasEnclaveReportImpl
implements Servable<Gateway.GatewayGetIasEnclaveReportRequest, Gateway.GatewayGetIasEnclaveReportResponse> {
    private static final AppLogger LOGGER = AppLoggerFactory.getLogger(ServableGetEnclaveReportImpl.class);
    private final DataContainer dataContainer;
    private final EnclaveNodeClusterTopicDAO enclaveNodeClusterTopicDAO;
    private final RemoteGatewayManager remoteGatewayManager;
    private final OasisAppConfiguration oasisAppConfiguration;
    private final TrustedTrService trustedTrService;

    public ServableGetIasEnclaveReportImpl(DataContainer dataContainer, TrustedTrService trustedTrService, EnclaveNodeClusterTopicDAO enclaveNodeClusterTopicDAO, RemoteGatewayManager remoteGatewayManager, OasisAppConfiguration oasisAppConfiguration) {
        this.dataContainer = dataContainer;
        this.trustedTrService = trustedTrService;
        this.enclaveNodeClusterTopicDAO = enclaveNodeClusterTopicDAO;
        this.remoteGatewayManager = remoteGatewayManager;
        this.oasisAppConfiguration = oasisAppConfiguration;
    }

    public Gateway.GatewayGetIasEnclaveReportResponse call(Gateway.GatewayGetIasEnclaveReportRequest request, Header header, Map<String, Object> context) throws Exception {
        Gateway.GatewayGetEnclaveReportResponse getEnclaveReportResponse = this.getEnclaveReport(request, header, context);
        List enclaveQuoteEntryList = getEnclaveReportResponse.getEnclaveQuoteEntrysList();
        List<Gateway.GatewayGetIasEnclaveReportResponse.EnclaveQuoteAndReport.AttestationVerificationReport> attestationVerificationReports = this.getAttestationVerificationReports(request, header, context, enclaveQuoteEntryList);
        if (enclaveQuoteEntryList.size() != attestationVerificationReports.size()) {
            LOGGER.warn(header.isLoadtest(), request.getTopicId(), null, this.getClass().getSimpleName(), new Object[]{String.format("Enclave report size [%d] is not equal iasReport size [%s]", enclaveQuoteEntryList.size(), attestationVerificationReports.size())});
            throw new UnexpectException("EnclaveReport size is nor equal IasReport size");
        }
        Gateway.GatewayGetIasEnclaveReportResponse.Builder builder = Gateway.GatewayGetIasEnclaveReportResponse.newBuilder();
        for (int i = 0; i < attestationVerificationReports.size(); ++i) {
            Common.EnclaveQuoteEntry enclaveQuoteEntry = (Common.EnclaveQuoteEntry)enclaveQuoteEntryList.get(i);
            Gateway.GatewayGetIasEnclaveReportResponse.EnclaveQuoteAndReport.AttestationVerificationReport attestationVerificationReport = attestationVerificationReports.get(i);
            Gateway.GatewayGetIasEnclaveReportResponse.EnclaveQuoteAndReport enclaveQuoteAndReport = Gateway.GatewayGetIasEnclaveReportResponse.EnclaveQuoteAndReport.newBuilder().setEnclaveQuoteEntry(enclaveQuoteEntry).setReport(attestationVerificationReport).build();
            builder.addEnclaveQuoteAndReports(enclaveQuoteAndReport);
        }
        builder.setHeader(Common.ResponseHeader.newBuilder().setErrorCode(Common.ErrorCode.SUCCESS).setIsSuccess(true));
        return builder.build();
    }

    private Gateway.GatewayGetEnclaveReportResponse getEnclaveReport(Gateway.GatewayGetIasEnclaveReportRequest request, Header header, Map<String, Object> context) throws Exception {
        ServableGetEnclaveReportImpl getEnclaveReport = new ServableGetEnclaveReportImpl(this.dataContainer, this.enclaveNodeClusterTopicDAO, this.remoteGatewayManager, this.oasisAppConfiguration);
        Gateway.GatewayGetEnclaveReportRequest getEnclaveReportRequest = Gateway.GatewayGetEnclaveReportRequest.newBuilder().setHeader(request.getHeader()).setTopicId(request.getTopicId()).addAllClusterIds((Iterable)request.getClusterIdsList()).build();
        Gateway.GatewayGetEnclaveReportResponse getEnclaveReportResponse = getEnclaveReport.call(getEnclaveReportRequest, header, context);
        if (!getEnclaveReportResponse.getHeader().getIsSuccess()) {
            LOGGER.warn(header.isLoadtest(), request.getTopicId(), null, this.getClass().getSimpleName(), new Object[]{"Get Enclave Report Fail: " + getEnclaveReportResponse.getHeader().getErrorMsg()});
            throw new UnexpectException("Get Enclave Report Fail: " + getEnclaveReportResponse.getHeader().getErrorMsg());
        }
        return getEnclaveReportResponse;
    }

    private List<Gateway.GatewayGetIasEnclaveReportResponse.EnclaveQuoteAndReport.AttestationVerificationReport> getAttestationVerificationReports(Gateway.GatewayGetIasEnclaveReportRequest request, Header header, Map<String, Object> context, List<Common.EnclaveQuoteEntry> enclaveQuoteEntryList) {
        ServableRaFetchVerificationReportImpl raFetchVerificationReport = new ServableRaFetchVerificationReportImpl(this.trustedTrService, this.dataContainer);
        ArrayList<Gateway.GatewayGetIasEnclaveReportResponse.EnclaveQuoteAndReport.AttestationVerificationReport> reports = new ArrayList<Gateway.GatewayGetIasEnclaveReportResponse.EnclaveQuoteAndReport.AttestationVerificationReport>();
        for (Common.EnclaveQuoteEntry enclaveQuoteEntry : enclaveQuoteEntryList) {
            Gateway.GatewayRaFetchVerificationReportRequest raFetchVerificationReportRequest = Gateway.GatewayRaFetchVerificationReportRequest.newBuilder().setHeader(request.getHeader()).setIsvEnclaveQuote(enclaveQuoteEntry.getEnclaveQuote().getQuote()).setPseManifest(ByteString.copyFromUtf8((String)"")).setNonce(request.getNonce()).setTopicId(request.getTopicId()).setUseDevelopCertificate(request.getUseDevelopCertificate()).build();
            Gateway.GatewayRaFetchVerificationReportResponse raFetchVerificationReportResponse = raFetchVerificationReport.call(raFetchVerificationReportRequest, header, context);
            if (!raFetchVerificationReportResponse.getHeader().getIsSuccess()) {
                LOGGER.warn(header.isLoadtest(), request.getTopicId(), null, this.getClass().getSimpleName(), new Object[]{"clusterId:" + enclaveQuoteEntry.getClusterId() + "raFetchVerificationReport Fail: " + raFetchVerificationReportResponse.getHeader().getErrorMsg()});
                throw new UnexpectException("raFetchVerificationReport Fail: " + raFetchVerificationReportResponse.getHeader().getErrorMsg());
            }
            Gateway.GatewayGetIasEnclaveReportResponse.EnclaveQuoteAndReport.AttestationVerificationReport report = Gateway.GatewayGetIasEnclaveReportResponse.EnclaveQuoteAndReport.AttestationVerificationReport.newBuilder().setReport(raFetchVerificationReportResponse.getReport()).setRequestId(raFetchVerificationReportResponse.getRequestId()).setXIasreportSignature(raFetchVerificationReportResponse.getXIasreportSignature()).setXIasreportSigningCertificate(raFetchVerificationReportResponse.getXIasreportSigningCertificate()).build();
            reports.add(report);
        }
        return reports;
    }
}

