/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.service.servable;

import com.alibaba.fastjson.JSONObject;
import com.alipay.oasis.biz.service.impl.gateway.ProtoConverter;
import com.alipay.oasis.biz.service.impl.gateway.data.container.DataContainer;
import com.alipay.oasis.biz.service.impl.gateway.data.strategy.DataStrategy;
import com.alipay.oasis.biz.service.impl.gateway.oasiscall.enclaveservice.EnclaveParamWithClusterId;
import com.alipay.oasis.biz.service.impl.gateway.oasiscall.enclaveservice.EnclaveServiceClient;
import com.alipay.oasis.biz.service.impl.gateway.oasiscall.remotegateway.RemoteGatewayManager;
import com.alipay.oasis.common.dal.mysql.daointerface.EnclaveNodeClusterTopicDAO;
import com.alipay.oasis.common.dal.mysql.dataobject.EnclaveNodeClusterTopicDO;
import com.alipay.oasis.common.dal.mysql.dataobject.EnclaveNodeDO;
import com.alipay.oasis.common.dal.mysql.doinfo.EnclaveNodeInfo;
import com.alipay.oasis.common.util.config.OasisAppConfiguration;
import com.alipay.oasis.common.util.header.Header;
import com.alipay.oasis.common.util.logger.AppLogger;
import com.alipay.oasis.common.util.logger.AppLoggerFactory;
import com.alipay.oasis.common.util.service.Servable;
import com.alipay.oasis.proto.gateway.Gateway;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.springframework.util.CollectionUtils;

public class ServableGetEnclaveReportImpl
implements Servable<Gateway.GatewayGetEnclaveReportRequest, Gateway.GatewayGetEnclaveReportResponse> {
    private static final AppLogger LOGGER = AppLoggerFactory.getLogger(ServableGetEnclaveReportImpl.class);
    private final DataContainer dataContainer;
    private final EnclaveNodeClusterTopicDAO enclaveNodeClusterTopicDAO;
    private final RemoteGatewayManager remoteGatewayManager;
    private final OasisAppConfiguration oasisAppConfiguration;

    public ServableGetEnclaveReportImpl(DataContainer dataContainer, EnclaveNodeClusterTopicDAO enclaveNodeClusterTopicDAO, RemoteGatewayManager remoteGatewayManager, OasisAppConfiguration oasisAppConfiguration) {
        this.dataContainer = dataContainer;
        this.enclaveNodeClusterTopicDAO = enclaveNodeClusterTopicDAO;
        this.remoteGatewayManager = remoteGatewayManager;
        this.oasisAppConfiguration = oasisAppConfiguration;
    }

    public Gateway.GatewayGetEnclaveReportResponse call(Gateway.GatewayGetEnclaveReportRequest request, Header header, Map<String, Object> context) throws Exception {
        String topicId = request.getTopicId();
        Object clusterIdList = request.getClusterIdsList();
        HashMap zoneClusterIdsMap = new HashMap(16);
        ArrayList<EnclaveParamWithClusterId> enclaveParamWithClusterIdList = new ArrayList<EnclaveParamWithClusterId>(16);
        List enclaveNodeClusterTopicDOList = this.enclaveNodeClusterTopicDAO.queryByTopic(topicId);
        if (CollectionUtils.isEmpty((Collection)enclaveNodeClusterTopicDOList)) {
            throw new Exception("No enclave node cluster for topic [" + topicId + "]. Can not get enclave report for GetEnclaveReportResponse");
        }
        if (CollectionUtils.isEmpty((Collection)clusterIdList)) {
            clusterIdList = this.convertEnclaveNodeClusterTopicDOList(enclaveNodeClusterTopicDOList);
        } else if (!DataStrategy.isClusterIdListLegal((List<String>)clusterIdList, this.convertEnclaveNodeClusterTopicDOList(enclaveNodeClusterTopicDOList))) {
            LOGGER.warn(header.isLoadtest(), topicId, null, this.getClass().getSimpleName(), new Object[]{"Illegal clusterIdList for topic [" + topicId + "]. ClusterIdList : " + JSONObject.toJSONString((Object)clusterIdList)});
            throw new Exception("Illegal clusterIdList for topic [" + topicId + "]. Can not get enclave report for GetEnclaveReportResponse");
        }
        Iterator iterator = clusterIdList.iterator();
        while (iterator.hasNext()) {
            String clusterId = (String)iterator.next();
            List<EnclaveNodeDO> enclaveNodeDOList = this.dataContainer.getEnclaveNodes(clusterId);
            if (CollectionUtils.isEmpty(enclaveNodeDOList)) {
                LOGGER.warn(header.isLoadtest(), clusterId, null, this.getClass().getSimpleName(), new Object[]{"Empty enclave node list for clusterId : " + clusterId});
                continue;
            }
            EnclaveNodeDO enclaveNode = DataStrategy.getAInClusterEnclaveNode(enclaveNodeDOList, this.oasisAppConfiguration.getZoneName());
            if (null == enclaveNode) {
                throw new Exception("Illegal enclave node status for cluster [" + clusterId + "]. Can not get enclave report for GetEnclaveReportResponse");
            }
            EnclaveNodeInfo enclaveNodeInfo = enclaveNode.fetchStructInfoCopy();
            String zoneName = enclaveNodeInfo.getZone().toUpperCase(Locale.ENGLISH);
            if (this.oasisAppConfiguration.isSelfZone(zoneName)) {
                EnclaveParamWithClusterId enclaveParamWithClusterId = new EnclaveParamWithClusterId(enclaveNodeInfo.getHost(), topicId, enclaveNode.getEnclaveNodeId(), clusterId);
                enclaveParamWithClusterIdList.add(enclaveParamWithClusterId);
                continue;
            }
            if (!zoneClusterIdsMap.containsKey(zoneName)) {
                ArrayList<String> list = new ArrayList<String>();
                list.add(clusterId);
                zoneClusterIdsMap.put(zoneName, list);
                continue;
            }
            ((List)zoneClusterIdsMap.get(zoneName)).add(clusterId);
        }
        HashMap<String, Gateway.GatewayGetEnclaveReportResponse> zoneResponse = new HashMap<String, Gateway.GatewayGetEnclaveReportResponse>(zoneClusterIdsMap.size());
        if (!CollectionUtils.isEmpty(enclaveParamWithClusterIdList)) {
            zoneResponse.put(this.oasisAppConfiguration.getZoneName(), this.getEnclaveReportInner(enclaveParamWithClusterIdList, request, header));
        }
        for (String zoneName : zoneClusterIdsMap.keySet()) {
            List list = (List)zoneClusterIdsMap.get(zoneName);
            if (CollectionUtils.isEmpty((Collection)list)) continue;
            Gateway.GatewayGetEnclaveReportRequest.Builder builder = Gateway.GatewayGetEnclaveReportRequest.newBuilder();
            builder.setHeader(request.getHeader()).setTopicId(topicId).addAllClusterIds((Iterable)list);
            zoneResponse.put(zoneName, this.remoteGatewayManager.getGatewayTrServiceByZoneName(zoneName).getEnclaveReport(builder.build()));
        }
        return ProtoConverter.combineGatewayGetEnclaveReportResponse(zoneResponse);
    }

    Gateway.GatewayGetEnclaveReportResponse getEnclaveReportInner(List<EnclaveParamWithClusterId> enclaveParamWithClusterIdList, Gateway.GatewayGetEnclaveReportRequest request, Header header) throws InvalidProtocolBufferException {
        LOGGER.info(true, null, null, "test", new Object[]{JSONObject.toJSONString(enclaveParamWithClusterIdList)});
        return EnclaveServiceClient.getEnclaveReport(enclaveParamWithClusterIdList, request, header);
    }

    List<String> convertEnclaveNodeClusterTopicDOList(List<EnclaveNodeClusterTopicDO> enclaveNodeClusterTopicDOList) {
        ArrayList<String> list = new ArrayList<String>(enclaveNodeClusterTopicDOList.size());
        for (EnclaveNodeClusterTopicDO enclaveNodeClusterTopicDO : enclaveNodeClusterTopicDOList) {
            list.add(enclaveNodeClusterTopicDO.getEnclaveNodeClusterId());
        }
        return list;
    }
}

