/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.service.servable;

import com.alibaba.common.lang.StringUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alipay.oasis.biz.service.impl.gateway.data.container.DataContainer;
import com.alipay.oasis.biz.service.impl.gateway.data.strategy.DataStrategy;
import com.alipay.oasis.common.dal.mysql.daointerface.ClusterManagerInfoDAO;
import com.alipay.oasis.common.dal.mysql.daointerface.EnclaveConfigDAO;
import com.alipay.oasis.common.dal.mysql.daointerface.EnclaveConfigMapDAO;
import com.alipay.oasis.common.dal.mysql.daointerface.QueryIdDAO;
import com.alipay.oasis.common.dal.mysql.daointerface.SceneDAO;
import com.alipay.oasis.common.dal.mysql.dataobject.ClusterManagerInfoDO;
import com.alipay.oasis.common.dal.mysql.dataobject.EnclaveConfigDO;
import com.alipay.oasis.common.dal.mysql.dataobject.EnclaveConfigMapDO;
import com.alipay.oasis.common.dal.mysql.dataobject.EnclaveConfigMapStatus;
import com.alipay.oasis.common.dal.mysql.dataobject.EnclaveNodeDO;
import com.alipay.oasis.common.dal.mysql.dataobject.QueryIdDO;
import com.alipay.oasis.common.dal.mysql.dataobject.SceneDO;
import com.alipay.oasis.common.dal.mysql.dataobject.SessionNodeClusterDO;
import com.alipay.oasis.common.dal.mysql.doinfo.QueryIdInfo;
import com.alipay.oasis.common.util.config.OasisAppConfiguration;
import com.alipay.oasis.common.util.exception.SessionExpiredException;
import com.alipay.oasis.common.util.exception.UnexpectException;
import com.alipay.oasis.common.util.exception.UnknownSessionException;
import com.alipay.oasis.common.util.exception.UnsupportedException;
import com.alipay.oasis.common.util.protobuf.PbJson;
import com.alipay.oasis.proto.Common;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.UUID;

public class ServableCommon {
    static SessionNodeClusterDO getSessionNodeClusterDO(String sessionId, DataContainer dataContainer) {
        SessionNodeClusterDO sessionNodeClusterDO = dataContainer.getSessionNodeCluster(sessionId);
        if (sessionNodeClusterDO == null) {
            String errMsg = "Session id [" + sessionId + "] does not exist";
            throw new UnknownSessionException(errMsg);
        }
        return sessionNodeClusterDO;
    }

    static void checkSessionExpired(SessionNodeClusterDO sessionNodeClusterDO) {
        if (sessionNodeClusterDO.fetchStructInfoCopy().getExpired().booleanValue()) {
            throw new SessionExpiredException("Session id [" + sessionNodeClusterDO.getSessionNodeClusterId() + "] is expired");
        }
    }

    static String getZoneCmHost(ClusterManagerInfoDAO clusterManagerInfoDAO, String selfZone) {
        ClusterManagerInfoDO clusterManagerInfoDO = clusterManagerInfoDAO.queryByZone(selfZone);
        if (clusterManagerInfoDO == null) {
            throw new UnexpectException("No available cluster manager!");
        }
        return clusterManagerInfoDO.getHost();
    }

    static void validateSceneAndTopic(SceneDAO sceneDAO, Common.Scene scene, String topicId) {
        String sceneId = scene.getSceneId();
        if (StringUtil.isEmpty((String)sceneId)) {
            throw new UnexpectException("No scene id");
        }
        SceneDO sceneDO = sceneDAO.querySingle(sceneId);
        if (sceneDO == null) {
            throw new UnexpectException("Unknown scene id[" + sceneId + "]");
        }
        if (!StringUtil.equals((String)sceneDO.getSceneName(), (String)scene.getSceneName())) {
            throw new UnexpectException("Scene name [" + scene.getSceneName() + "] is not corresponding to the scene id [" + sceneId + "]");
        }
        if (!StringUtil.equals((String)sceneDO.getTopicId(), (String)topicId)) {
            throw new UnexpectException("Scene id[" + sceneId + "] in request is not corresponding to the topic [" + topicId + "]");
        }
    }

    static Common.EnclaveConfigMetaInfo buildEnclaveConfigMetaInfo(EnclaveConfigDO enclaveConfigDO) {
        Common.EnclaveConfigMetaInfo.Builder builder = Common.EnclaveConfigMetaInfo.newBuilder();
        builder.setConfigUuid(enclaveConfigDO.getConfigId());
        builder.setConfigVersion(enclaveConfigDO.getConfigVersion());
        builder.setConfigSource((Common.EnclaveConfigSource)PbJson.json2pb((JSONObject)JSON.parseObject((String)enclaveConfigDO.getConfigSource()), Common.EnclaveConfigSource.class));
        return builder.build();
    }

    static EnclaveConfigDO validateEnclaveConfigMetaInfo(Common.EnclaveConfigMetaInfo enclaveConfigMetaInfo, EnclaveConfigDAO enclaveConfigDAO) {
        if (enclaveConfigMetaInfo == null) {
            throw new UnexpectException("No config meta info in request");
        }
        String configId = enclaveConfigMetaInfo.getConfigUuid();
        if (StringUtil.isEmpty((String)configId)) {
            throw new UnexpectException("No config id in config meta info");
        }
        String configVersion = enclaveConfigMetaInfo.getConfigVersion();
        if (StringUtil.isEmpty((String)configVersion)) {
            throw new UnexpectException("No config version in config meta info");
        }
        EnclaveConfigDO enclaveConfigDO = enclaveConfigDAO.querySingle(configId);
        if (enclaveConfigDO == null) {
            throw new UnexpectException("No enclave config id [" + configId + "] in db");
        }
        if (!StringUtil.equals((String)configVersion, (String)enclaveConfigDO.getConfigVersion())) {
            throw new UnexpectException("Config version [" + configVersion + "] in request is not corresponding to the config version[" + enclaveConfigDO.getConfigVersion() + "] in db");
        }
        return enclaveConfigDO;
    }

    static EnclaveNodeDO getEnclaveByQuery(String queryId, QueryIdDAO queryIdDAO, DataContainer dataContainer) {
        QueryIdDO queryIdDO = queryIdDAO.querySingle(queryId);
        if (queryIdDO == null) {
            throw new UnexpectException("Query id [" + queryId + "] is not in db");
        }
        String enclaveNodeId = queryIdDO.fetchStructInfoCopy().getEnclaveNodeId();
        if (StringUtil.isEmpty((String)enclaveNodeId)) {
            throw new UnexpectException("Can not find enclave for query id [" + queryId + "]");
        }
        EnclaveNodeDO enclaveNodeDO = dataContainer.getEnclaveNode(enclaveNodeId);
        if (enclaveNodeDO == null) {
            throw new UnexpectException("Enclave [" + enclaveNodeId + "] for query id [" + queryId + "] is not in db");
        }
        return enclaveNodeDO;
    }

    static Common.ResponseHeader buildSuccessResponseHeader() {
        return Common.ResponseHeader.newBuilder().setIsSuccess(true).setErrorCode(Common.ErrorCode.SUCCESS).build();
    }

    static EnclaveNodeDO getEnclaveNodeByClusterId(DataContainer dataContainer, OasisAppConfiguration oasisAppConfiguration, String clusterId) {
        List<EnclaveNodeDO> enclaveNodeDOList = dataContainer.getEnclaveNodes(clusterId);
        return DataStrategy.getAInClusterEnclaveNode(enclaveNodeDOList, oasisAppConfiguration.getZoneName());
    }

    static EnclaveNodeWithConfig getEnclaveNodeByScene(DataContainer dataContainer, EnclaveConfigDAO enclaveConfigDAO, EnclaveConfigMapDAO enclaveConfigMapDAO, OasisAppConfiguration oasisAppConfiguration, String sceneId) {
        List enclaveConfigDOList = enclaveConfigDAO.queryBySceneId(sceneId);
        if (enclaveConfigDOList.isEmpty()) {
            throw new UnsupportedException("No config for scene[" + sceneId + "]");
        }
        int totalPercent = 0;
        for (EnclaveConfigDO enclaveConfigDO : enclaveConfigDOList) {
            totalPercent += enclaveConfigDO.fetchStructInfoCopy().getFlowRatio();
        }
        int random = new Random().nextInt(totalPercent);
        int probability = 0;
        for (EnclaveConfigDO enclaveConfigDO : enclaveConfigDOList) {
            if (random >= (probability += enclaveConfigDO.fetchStructInfoCopy().getFlowRatio())) continue;
            List enclaveConfigMapDOList = enclaveConfigMapDAO.queryByEnclaveConfigId(enclaveConfigDO.getConfigId());
            ArrayList<EnclaveNodeDO> enclaveNodeDOList = new ArrayList<EnclaveNodeDO>(enclaveConfigMapDOList.size());
            for (EnclaveConfigMapDO enclaveConfigMapDO : enclaveConfigMapDOList) {
                EnclaveNodeDO enclaveNodeDO;
                if (EnclaveConfigMapStatus.valueOf((String)enclaveConfigMapDO.getStatus()) != EnclaveConfigMapStatus.LOADED || (enclaveNodeDO = dataContainer.getEnclaveNode(enclaveConfigMapDO.getEnclaveNodeId())) == null) continue;
                enclaveNodeDOList.add(enclaveNodeDO);
            }
            EnclaveNodeDO chosenNode = DataStrategy.getAInClusterEnclaveNode(enclaveNodeDOList, oasisAppConfiguration.getZoneName());
            return new EnclaveNodeWithConfig(chosenNode, ServableCommon.buildEnclaveConfigMetaInfo(enclaveConfigDO));
        }
        return null;
    }

    static QueryIdDO buildQueryIdDO(String topicId, String sessionId, EnclaveNodeDO enclaveNodeDO) {
        QueryIdDO queryIdDO = new QueryIdDO();
        queryIdDO.setTopicId(topicId);
        queryIdDO.setQueryId(UUID.randomUUID().toString());
        queryIdDO.setEnclaveNodeClusterId(enclaveNodeDO.getEnclaveNodeClusterId());
        QueryIdInfo queryIdInfo = new QueryIdInfo();
        queryIdInfo.setSessionId(sessionId);
        queryIdInfo.setEnclaveNodeId(enclaveNodeDO.getEnclaveNodeId());
        queryIdDO.setStructInfo(queryIdInfo);
        return queryIdDO;
    }

    public static class EnclaveNodeWithConfig {
        private final EnclaveNodeDO enclaveNodeDO;
        private final Common.EnclaveConfigMetaInfo enclaveConfigMetaInfo;

        public EnclaveNodeWithConfig(EnclaveNodeDO enclaveNodeDO, Common.EnclaveConfigMetaInfo enclaveConfigMetaInfo) {
            this.enclaveNodeDO = enclaveNodeDO;
            this.enclaveConfigMetaInfo = enclaveConfigMetaInfo;
        }

        public EnclaveNodeDO getEnclaveNodeDO() {
            return this.enclaveNodeDO;
        }

        public Common.EnclaveConfigMetaInfo getEnclaveConfigMetaInfo() {
            return this.enclaveConfigMetaInfo;
        }
    }
}

