/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.service.servable;

import com.alipay.oasis.biz.service.impl.gateway.data.container.DataContainer;
import com.alipay.oasis.biz.service.impl.gateway.oasiscall.enclaveservice.EnclaveParam;
import com.alipay.oasis.biz.service.impl.gateway.oasiscall.enclaveservice.EnclaveServiceClient;
import com.alipay.oasis.biz.service.impl.gateway.oasiscall.remotegateway.RemoteGatewayManager;
import com.alipay.oasis.biz.service.impl.gateway.service.servable.ServableCommon;
import com.alipay.oasis.biz.service.impl.gateway.service.servable.ServableRaBizQueryImpl;
import com.alipay.oasis.common.dal.mysql.daointerface.EnclaveConfigDAO;
import com.alipay.oasis.common.dal.mysql.daointerface.EnclaveConfigMapDAO;
import com.alipay.oasis.common.dal.mysql.daointerface.QueryIdDAO;
import com.alipay.oasis.common.dal.mysql.daointerface.SceneDAO;
import com.alipay.oasis.common.dal.mysql.dataobject.EnclaveNodeDO;
import com.alipay.oasis.common.dal.mysql.dataobject.QueryIdDO;
import com.alipay.oasis.common.dal.mysql.doinfo.EnclaveNodeInfo;
import com.alipay.oasis.common.util.config.OasisAppConfiguration;
import com.alipay.oasis.common.util.header.Header;
import com.alipay.oasis.common.util.service.Servable;
import com.alipay.oasis.proto.Common;
import com.alipay.oasis.proto.gateway.Gateway;
import com.google.protobuf.InvalidProtocolBufferException;
import java.util.Map;

public class ServableAsyncRaBizQueryImpl
implements Servable<Gateway.GatewayRaBizQueryRequest, Gateway.GatewayAsyncBizQueryResponse> {
    private final DataContainer dataContainer;
    private final RemoteGatewayManager remoteGatewayManager;
    private final EnclaveConfigDAO enclaveConfigDAO;
    private final EnclaveConfigMapDAO enclaveConfigMapDAO;
    private final SceneDAO sceneDAO;
    private final QueryIdDAO queryIdDAO;
    private final OasisAppConfiguration oasisAppConfiguration;

    public ServableAsyncRaBizQueryImpl(DataContainer dataContainer, RemoteGatewayManager remoteGatewayManager, EnclaveConfigDAO enclaveConfigDAO, EnclaveConfigMapDAO enclaveConfigMapDAO, SceneDAO sceneDAO, QueryIdDAO queryIdDAO, OasisAppConfiguration oasisAppConfiguration) {
        this.dataContainer = dataContainer;
        this.remoteGatewayManager = remoteGatewayManager;
        this.enclaveConfigDAO = enclaveConfigDAO;
        this.enclaveConfigMapDAO = enclaveConfigMapDAO;
        this.sceneDAO = sceneDAO;
        this.queryIdDAO = queryIdDAO;
        this.oasisAppConfiguration = oasisAppConfiguration;
    }

    public Gateway.GatewayAsyncBizQueryResponse call(Gateway.GatewayRaBizQueryRequest request, Header header, Map<String, Object> context) throws Exception {
        ServableRaBizQueryImpl servableRaBizQuery = new ServableRaBizQueryImpl(this.dataContainer, this.remoteGatewayManager, this.enclaveConfigDAO, this.enclaveConfigMapDAO, this.sceneDAO, this.oasisAppConfiguration);
        ServableCommon.EnclaveNodeWithConfig enclaveNodeWithConfig = servableRaBizQuery.getEnclaveNodeAndConfig(request);
        EnclaveNodeDO enclaveNodeForBizQuery = enclaveNodeWithConfig.getEnclaveNodeDO();
        EnclaveNodeInfo enclaveNodeInfo = enclaveNodeForBizQuery.fetchStructInfoCopy();
        String zone = enclaveNodeInfo.getZone();
        if (!this.oasisAppConfiguration.isSelfZone(zone)) {
            return this.remoteGatewayManager.getGatewayTrServiceByZoneName(zone).asyncRaBizQuery(request);
        }
        EnclaveParam enclaveParam = new EnclaveParam(enclaveNodeInfo.getHost(), request.getTopicId(), enclaveNodeForBizQuery.getEnclaveNodeId());
        QueryIdDO queryIdDO = ServableCommon.buildQueryIdDO(request.getTopicId(), request.hasSessionId() ? request.getSessionId() : null, enclaveNodeForBizQuery);
        this.queryIdDAO.insert(queryIdDO);
        Common.AsyncQueryInfo asyncQueryInfo = Common.AsyncQueryInfo.newBuilder().setQueryId(queryIdDO.getQueryId()).build();
        return this.asyncBizQueryInner(enclaveParam, request, header, enclaveNodeWithConfig.getEnclaveConfigMetaInfo(), asyncQueryInfo);
    }

    Gateway.GatewayAsyncBizQueryResponse asyncBizQueryInner(EnclaveParam enclaveParam, Gateway.GatewayRaBizQueryRequest request, Header header, Common.EnclaveConfigMetaInfo enclaveConfigMetaInfo, Common.AsyncQueryInfo asyncQueryInfo) throws InvalidProtocolBufferException {
        return EnclaveServiceClient.asyncRaBizQuery(enclaveParam, request, header, enclaveConfigMetaInfo, asyncQueryInfo);
    }
}

