/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.service.headerbuildable;

import com.alipay.common.tracer.util.TracerContextUtil;
import com.alipay.oasis.biz.service.impl.gateway.data.container.DataContainer;
import com.alipay.oasis.common.util.exception.UnexpectException;
import com.alipay.oasis.common.util.header.Header;
import com.alipay.oasis.common.util.header.HeaderBuilder;
import com.alipay.oasis.proto.Common;

public class HeaderBuildableHelper {
    public static Header buildHeaderBySessionId(String sessionId, Common.RequestHeader header, DataContainer dataContainer) throws UnexpectException {
        header = HeaderBuilder.fillTraceId((Common.RequestHeader)header, (String)TracerContextUtil.getTraceId());
        HeaderBuilder.validateRequestHeader((Common.RequestHeader)header);
        String bizType = dataContainer.getEnclaveNodeClusterIdBySessionId(sessionId);
        if (bizType == null) {
            throw new UnexpectException("no enclave cluster for session [" + sessionId + "] in db.");
        }
        return new Header(header, bizType);
    }

    public static Header buildHeaderByTopicId(String topicId, Common.RequestHeader header, DataContainer dataContainer) throws UnexpectException {
        header = HeaderBuilder.fillTraceId((Common.RequestHeader)header, (String)TracerContextUtil.getTraceId());
        HeaderBuilder.validateRequestHeader((Common.RequestHeader)header);
        String bizType = dataContainer.getEnclaveNodeClusterIdByTopicId(topicId);
        if (bizType == null) {
            throw new UnexpectException("no default enclave cluster for topic [" + topicId + "] in db.");
        }
        return new Header(header, bizType);
    }
}

