/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.oasiscall.enclaveservice;

import com.alipay.oasis.biz.service.impl.gateway.ProtoConverter;
import com.alipay.oasis.biz.service.impl.gateway.oasiscall.OasisHttpCallException;
import com.alipay.oasis.biz.service.impl.gateway.oasiscall.enclaveservice.EnclaveParam;
import com.alipay.oasis.biz.service.impl.gateway.oasiscall.enclaveservice.EnclaveParamWithClusterId;
import com.alipay.oasis.biz.service.impl.gateway.oasiscall.enclaveservice.EnclaveServiceResponse;
import com.alipay.oasis.common.util.exception.UnexpectException;
import com.alipay.oasis.common.util.header.Header;
import com.alipay.oasis.proto.Common;
import com.alipay.oasis.proto.enclave_service.EnclaveService;
import com.alipay.oasis.proto.gateway.Gateway;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.httpclient.DefaultHttpMethodRetryHandler;
import org.apache.commons.httpclient.HttpClient;
import org.apache.commons.httpclient.HttpException;
import org.apache.commons.httpclient.HttpMethod;
import org.apache.commons.httpclient.methods.ByteArrayRequestEntity;
import org.apache.commons.httpclient.methods.PostMethod;
import org.apache.commons.httpclient.methods.RequestEntity;

public class EnclaveServiceClient {
    private static final String DELIMITER = "::";
    private static final String PB = "pb";
    private static final String HTTP_PREFIX = "http://";
    private static final String HTTP_SUFFIX = "/juneng/api/";

    public static Gateway.GatewayRaFetchMsg1Response raFetchMsg1(EnclaveParam enclaveParam, String sessionId, Gateway.GatewayRaFetchMsg1Request request, Header header) throws OasisHttpCallException, InvalidProtocolBufferException {
        EnclaveService.RaFetchMsg1Request raFetchMsg1Request = ProtoConverter.convertToRaFetchMsg1Request(request, sessionId, header);
        EnclaveServiceResponse enclaveServiceResponse = EnclaveServiceClient.sendHttpRequest(enclaveParam.getHost(), enclaveParam.getTopic(), enclaveParam.getEnclaveNodeId(), "/fetch_ra_msg1", (Message)raFetchMsg1Request);
        return EnclaveServiceClient.dealRaFetchMsg1Response(enclaveServiceResponse, sessionId);
    }

    public static Gateway.GatewayRaFetchMsg3Response raFetchMsg3(EnclaveParam enclaveParam, Gateway.GatewayRaFetchMsg3Request request, Header header) throws OasisHttpCallException, UnexpectException, InvalidProtocolBufferException {
        EnclaveService.RaFetchMsg3Request raFetchMsg3Request = ProtoConverter.convertToRaFetchMsg3Request(request, header);
        EnclaveServiceResponse enclaveServiceResponse = EnclaveServiceClient.sendHttpRequest(enclaveParam.getHost(), enclaveParam.getTopic(), enclaveParam.getEnclaveNodeId(), "/fetch_ra_msg3", (Message)raFetchMsg3Request);
        return (Gateway.GatewayRaFetchMsg3Response)EnclaveServiceClient.dealEnclaveServiceResponse(enclaveServiceResponse, Gateway.GatewayRaFetchMsg3Response.class);
    }

    public static Gateway.GatewayGetEnclaveReportResponse getEnclaveReport(List<EnclaveParamWithClusterId> enclaveParamWithClusterIdList, Gateway.GatewayGetEnclaveReportRequest request, Header header) throws OasisHttpCallException, UnexpectException, InvalidProtocolBufferException {
        HashMap<String, EnclaveService.GetEnclaveReportResponse> enclaveReportResponseMap = new HashMap<String, EnclaveService.GetEnclaveReportResponse>(enclaveParamWithClusterIdList.size());
        for (EnclaveParamWithClusterId enclaveParamWithClusterId : enclaveParamWithClusterIdList) {
            EnclaveService.GetEnclaveReportRequest enclaveReportRequest = ProtoConverter.convertToGetEnclaveReportRequest(request, header, enclaveParamWithClusterId.getEnclaveNodeClusterId());
            EnclaveServiceResponse enclaveServiceResponse = EnclaveServiceClient.sendHttpRequest(enclaveParamWithClusterId.getHost(), enclaveParamWithClusterId.getTopic(), enclaveParamWithClusterId.getEnclaveNodeId(), "/get_enclave_report", (Message)enclaveReportRequest);
            enclaveReportResponseMap.put(enclaveParamWithClusterId.getEnclaveNodeClusterId(), (EnclaveService.GetEnclaveReportResponse)EnclaveServiceClient.dealEnclaveServiceResponse(enclaveServiceResponse, EnclaveService.GetEnclaveReportResponse.class));
        }
        return ProtoConverter.convertToGatewayGetEnclaveReportResponse(enclaveReportResponseMap);
    }

    public static Gateway.GatewayRaBizQueryResponse raBizQuery(EnclaveParam enclaveParam, Gateway.GatewayRaBizQueryRequest request, Header header, Common.EnclaveConfigMetaInfo enclaveConfigMetaInfo) throws OasisHttpCallException, UnexpectException, InvalidProtocolBufferException {
        EnclaveService.RaBizQueryRequest raBizQueryRequest = ProtoConverter.convertToRaBizQueryRequest(request, header, enclaveConfigMetaInfo, null);
        EnclaveServiceResponse enclaveServiceResponse = EnclaveServiceClient.sendHttpRequest(enclaveParam.getHost(), enclaveParam.getTopic(), enclaveParam.getEnclaveNodeId(), "/query", (Message)raBizQueryRequest);
        return (Gateway.GatewayRaBizQueryResponse)EnclaveServiceClient.dealEnclaveServiceResponse(enclaveServiceResponse, Gateway.GatewayRaBizQueryResponse.class);
    }

    public static Gateway.GatewayRaBizQueryResponseV2 raBizQueryV2(EnclaveParam enclaveParam, Gateway.GatewayRaBizQueryRequestV2 request, Header header, Common.EnclaveConfigMetaInfo enclaveConfigMetaInfo) throws OasisHttpCallException, UnexpectException, InvalidProtocolBufferException {
        EnclaveService.RaBizQueryRequestV2 raBizQueryRequestV2 = ProtoConverter.convertToRaBizQueryRequestV2(request, header, enclaveConfigMetaInfo, null);
        EnclaveServiceResponse enclaveServiceResponse = EnclaveServiceClient.sendHttpRequest(enclaveParam.getHost(), enclaveParam.getTopic(), enclaveParam.getEnclaveNodeId(), "/query_v2", (Message)raBizQueryRequestV2);
        return (Gateway.GatewayRaBizQueryResponseV2)EnclaveServiceClient.dealEnclaveServiceResponse(enclaveServiceResponse, Gateway.GatewayRaBizQueryResponseV2.class);
    }

    public static Gateway.GatewayRaSetSessionBizKeyResponse raSetSessionBizKey(EnclaveParam enclaveParam, Gateway.GatewayRaSetSessionBizKeyRequest request, Header header) throws OasisHttpCallException, UnexpectException, InvalidProtocolBufferException {
        EnclaveService.RaSetSessionBizKeyRequest raSetSessionBizKeyRequest = ProtoConverter.convertToRaSetSessionBizKeyRequest(request, header);
        EnclaveServiceResponse enclaveServiceResponse = EnclaveServiceClient.sendHttpRequest(enclaveParam.getHost(), enclaveParam.getTopic(), enclaveParam.getEnclaveNodeId(), "/set_session_biz_key", (Message)raSetSessionBizKeyRequest);
        return (Gateway.GatewayRaSetSessionBizKeyResponse)EnclaveServiceClient.dealEnclaveServiceResponse(enclaveServiceResponse, Common.VoidResponse.class);
    }

    public static Gateway.GatewayAsyncBizQueryResponse asyncRaBizQuery(EnclaveParam enclaveParam, Gateway.GatewayRaBizQueryRequest request, Header header, Common.EnclaveConfigMetaInfo enclaveConfigMetaInfo, Common.AsyncQueryInfo asyncQueryInfo) throws OasisHttpCallException, UnexpectException, InvalidProtocolBufferException {
        EnclaveService.RaBizQueryRequest raBizQueryRequest = ProtoConverter.convertToRaBizQueryRequest(request, header, enclaveConfigMetaInfo, asyncQueryInfo);
        EnclaveServiceResponse enclaveServiceResponse = EnclaveServiceClient.sendHttpRequest(enclaveParam.getHost(), enclaveParam.getTopic(), enclaveParam.getEnclaveNodeId(), "/async_query", (Message)raBizQueryRequest);
        return (Gateway.GatewayAsyncBizQueryResponse)EnclaveServiceClient.dealEnclaveServiceResponse(enclaveServiceResponse, Gateway.GatewayAsyncBizQueryResponse.class);
    }

    public static Gateway.GatewayAsyncBizQueryResponseV2 asyncRaBizQueryV2(EnclaveParam enclaveParam, Gateway.GatewayRaBizQueryRequestV2 request, Header header, Common.EnclaveConfigMetaInfo enclaveConfigMetaInfo, Common.AsyncQueryInfo asyncQueryInfo) throws InvalidProtocolBufferException {
        EnclaveService.RaBizQueryRequestV2 raBizQueryRequestV2 = ProtoConverter.convertToRaBizQueryRequestV2(request, header, enclaveConfigMetaInfo, asyncQueryInfo);
        EnclaveServiceResponse enclaveServiceResponse = EnclaveServiceClient.sendHttpRequest(enclaveParam.getHost(), enclaveParam.getTopic(), enclaveParam.getEnclaveNodeId(), "/async_query_v2", (Message)raBizQueryRequestV2);
        return (Gateway.GatewayAsyncBizQueryResponseV2)EnclaveServiceClient.dealEnclaveServiceResponse(enclaveServiceResponse, Gateway.GatewayAsyncBizQueryResponseV2.class);
    }

    public static Gateway.GatewayPollAsyncBizQueryResultResponse pollAsyncBizQueryResult(EnclaveParam enclaveParam, Gateway.GatewayPollAsyncBizQueryResultRequest request, Header header) throws OasisHttpCallException, UnexpectException, InvalidProtocolBufferException {
        EnclaveService.PollAsyncBizQueryResultRequest pollAsyncBizQueryResultRequest = ProtoConverter.convertToPollAsyncBizQueryResultRequest(request, header);
        EnclaveServiceResponse enclaveServiceResponse = EnclaveServiceClient.sendHttpRequest(enclaveParam.getHost(), enclaveParam.getTopic(), enclaveParam.getEnclaveNodeId(), "/poll_async_query_result", (Message)pollAsyncBizQueryResultRequest);
        return (Gateway.GatewayPollAsyncBizQueryResultResponse)EnclaveServiceClient.dealEnclaveServiceResponse(enclaveServiceResponse, Gateway.GatewayPollAsyncBizQueryResultResponse.class);
    }

    public static Gateway.GatewayFinishAsyncBizQueryResponse finishAsyncBizQuery(EnclaveParam enclaveParam, Gateway.GatewayFinishAsyncBizQueryRequest request, Header header) throws OasisHttpCallException, UnexpectException, InvalidProtocolBufferException {
        EnclaveService.FinishAsyncBizQueryRequest finishAsyncBizQueryRequest = ProtoConverter.convertToFinishAsyncBizQueryRequest(request, header);
        EnclaveServiceResponse enclaveServiceResponse = EnclaveServiceClient.sendHttpRequest(enclaveParam.getHost(), enclaveParam.getTopic(), enclaveParam.getEnclaveNodeId(), "/finish_async_query", (Message)finishAsyncBizQueryRequest);
        return (Gateway.GatewayFinishAsyncBizQueryResponse)EnclaveServiceClient.dealEnclaveServiceResponse(enclaveServiceResponse, Gateway.GatewayFinishAsyncBizQueryResponse.class);
    }

    static EnclaveServiceResponse sendHttpRequest(String host, String topic, String enclaveNodeId, String requestPath, Message msg) {
        HttpClient httpClient = new HttpClient();
        PostMethod postMethod = new PostMethod(EnclaveServiceClient.combineHttpAndHost(host));
        postMethod.getParams().setParameter("http.method.retry-handler", (Object)new DefaultHttpMethodRetryHandler(3, false));
        postMethod.setParameter("Content-Type", "application/x-protobuf");
        byte[] postData = EnclaveServiceClient.combinePostData(requestPath, topic, enclaveNodeId, msg);
        postMethod.setRequestEntity((RequestEntity)new ByteArrayRequestEntity(postData));
        try {
            EnclaveServiceResponse enclaveServiceResponse = new EnclaveServiceResponse();
            enclaveServiceResponse.setStatusCode(httpClient.executeMethod((HttpMethod)postMethod));
            enclaveServiceResponse.setResponseBytes(postMethod.getResponseBody());
            return enclaveServiceResponse;
        }
        catch (HttpException e) {
            throw new OasisHttpCallException(e);
        }
        catch (IOException e) {
            throw new OasisHttpCallException(e);
        }
    }

    static String combineHttpAndHost(String host) {
        return HTTP_PREFIX + host + HTTP_SUFFIX;
    }

    static GeneratedMessageV3 dealEnclaveServiceResponse(EnclaveServiceResponse enclaveServiceResponse, Class<? extends GeneratedMessageV3> expectedReturnClass) throws OasisHttpCallException, UnexpectException, InvalidProtocolBufferException {
        if (enclaveServiceResponse.getStatusCode() != 200) {
            throw new OasisHttpCallException("Enclave call response status is not ok. Status code is " + enclaveServiceResponse.getStatusCode());
        }
        if (expectedReturnClass == Gateway.GatewayRaFetchMsg3Response.class) {
            EnclaveService.RaFetchMsg3Response raFetchMsg3Response = EnclaveService.RaFetchMsg3Response.parseFrom((byte[])enclaveServiceResponse.getResponseBytes());
            return ProtoConverter.convertToGatewayRaFetchMsg3Response(raFetchMsg3Response);
        }
        if (expectedReturnClass == Common.VoidResponse.class) {
            Common.VoidResponse voidResponse = Common.VoidResponse.parseFrom((byte[])enclaveServiceResponse.getResponseBytes());
            Common.ResponseHeader responseHeader = ProtoConverter.dealResponseHeader(voidResponse.getHeader());
            return Gateway.GatewayRaSetSessionBizKeyResponse.newBuilder().setHeader(responseHeader).build();
        }
        if (expectedReturnClass == EnclaveService.GetEnclaveReportResponse.class) {
            return EnclaveService.GetEnclaveReportResponse.parseFrom((byte[])enclaveServiceResponse.getResponseBytes());
        }
        if (expectedReturnClass == Gateway.GatewayRaBizQueryResponse.class) {
            EnclaveService.RaBizQueryResponse raBizQueryResponse = EnclaveService.RaBizQueryResponse.parseFrom((byte[])enclaveServiceResponse.getResponseBytes());
            return ProtoConverter.convertToGatewayRaBizQueryResponse(raBizQueryResponse);
        }
        if (expectedReturnClass == Gateway.GatewayRaBizQueryResponseV2.class) {
            EnclaveService.RaBizQueryResponseV2 raBizQueryResponseV2 = EnclaveService.RaBizQueryResponseV2.parseFrom((byte[])enclaveServiceResponse.getResponseBytes());
            return ProtoConverter.convertToGatewayRaBizQueryResponseV2(raBizQueryResponseV2);
        }
        if (expectedReturnClass == Gateway.GatewayAsyncBizQueryResponse.class) {
            EnclaveService.AsyncBizQueryResponse asyncBizQueryResponse = EnclaveService.AsyncBizQueryResponse.parseFrom((byte[])enclaveServiceResponse.getResponseBytes());
            return ProtoConverter.convertToGatewayAsyncBizQueryResponse(asyncBizQueryResponse);
        }
        if (expectedReturnClass == Gateway.GatewayAsyncBizQueryResponseV2.class) {
            EnclaveService.AsyncBizQueryResponseV2 asyncBizQueryResponseV2 = EnclaveService.AsyncBizQueryResponseV2.parseFrom((byte[])enclaveServiceResponse.getResponseBytes());
            return ProtoConverter.convertToGatewayAsyncBizQueryResponseV2(asyncBizQueryResponseV2);
        }
        if (expectedReturnClass == Gateway.GatewayPollAsyncBizQueryResultResponse.class) {
            EnclaveService.PollAsyncBizQueryResultResponse pollAsyncBizQueryResultResponse = EnclaveService.PollAsyncBizQueryResultResponse.parseFrom((byte[])enclaveServiceResponse.getResponseBytes());
            return ProtoConverter.convertToGatewayPollAsyncBizQueryResultResponse(pollAsyncBizQueryResultResponse);
        }
        if (expectedReturnClass == Gateway.GatewayFinishAsyncBizQueryResponse.class) {
            EnclaveService.FinishAsyncBizQueryResponse finishAsyncBizQueryResponse = EnclaveService.FinishAsyncBizQueryResponse.parseFrom((byte[])enclaveServiceResponse.getResponseBytes());
            return ProtoConverter.convertToGatewayFinishAsyncBizQueryResponse(finishAsyncBizQueryResponse);
        }
        throw new UnexpectException("Input class " + expectedReturnClass.getClass() + " is illegal");
    }

    static Gateway.GatewayRaFetchMsg1Response dealRaFetchMsg1Response(EnclaveServiceResponse enclaveServiceResponse, String sessionId) throws OasisHttpCallException, InvalidProtocolBufferException {
        if (enclaveServiceResponse.getStatusCode() != 200) {
            throw new OasisHttpCallException("Enclave call response status is not ok. Status code is " + enclaveServiceResponse.getStatusCode());
        }
        EnclaveService.RaFetchMsg1Response raFetchMsg1Response = EnclaveService.RaFetchMsg1Response.parseFrom((byte[])enclaveServiceResponse.getResponseBytes());
        return ProtoConverter.convertToGatewayRaFetchMsg1Response(raFetchMsg1Response, sessionId);
    }

    static byte[] combinePostData(String requestPath, String topic, String enclaveNodeId, Message msg) {
        byte[] bytesBeforeMsg = (requestPath + DELIMITER + topic + DELIMITER + enclaveNodeId + DELIMITER + PB + DELIMITER).getBytes();
        byte[] bytesMsg = msg.toByteArray();
        byte[] totalBytes = new byte[bytesBeforeMsg.length + bytesMsg.length];
        System.arraycopy(bytesBeforeMsg, 0, totalBytes, 0, bytesBeforeMsg.length);
        System.arraycopy(bytesMsg, 0, totalBytes, bytesBeforeMsg.length, bytesMsg.length);
        return totalBytes;
    }
}

