/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.data.strategy;

import com.alibaba.common.lang.StringUtil;
import com.alipay.oasis.biz.service.impl.gateway.data.container.DataContainer;
import com.alipay.oasis.common.dal.mysql.dataobject.EnclaveNodeDO;
import com.alipay.oasis.common.dal.mysql.dataobject.SessionNodeClusterDO;
import com.alipay.oasis.common.dal.mysql.dataobject.SessionNodeDO;
import com.alipay.oasis.common.dal.mysql.doinfo.EnclaveNodeInfo;
import com.alipay.oasis.proto.Common;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;

public class DataStrategy {
    public static EnclaveNodeDO getAnEnclaveForBizQuery(String sessionId, DataContainer dataContainer, String selfZone) {
        List<SessionNodeDO> sessionNodeDOList = dataContainer.getSessionNodes(sessionId);
        EnclaveNodeDO selectedEnclaveNode = DataStrategy.selectAInSessionClusterNode(sessionNodeDOList, dataContainer, selfZone);
        if (selectedEnclaveNode == null) {
            sessionNodeDOList = dataContainer.getSessionNodesFromDb(sessionId);
            selectedEnclaveNode = DataStrategy.selectAInSessionClusterNode(sessionNodeDOList, dataContainer, selfZone);
        }
        return selectedEnclaveNode;
    }

    public static EnclaveNodeDO getAnEnclaveForSetBizKey(String sessionId, DataContainer dataContainer, String selfZone) {
        SessionNodeClusterDO sessionNodeClusterDO;
        String leaderSessionNodeId;
        SessionNodeDO sessionNodeDO;
        List<SessionNodeDO> sessionNodeDOList = dataContainer.getSessionNodes(sessionId);
        EnclaveNodeDO selectedEnclaveNode = DataStrategy.selectAInSessionClusterNode(sessionNodeDOList, dataContainer, selfZone);
        if (selectedEnclaveNode == null) {
            sessionNodeDOList = dataContainer.getSessionNodesFromDb(sessionId);
            selectedEnclaveNode = DataStrategy.selectAInSessionClusterNode(sessionNodeDOList, dataContainer, selfZone);
        }
        if (selectedEnclaveNode == null && (sessionNodeDO = dataContainer.getSessionNode(leaderSessionNodeId = (sessionNodeClusterDO = dataContainer.getSessionNodeCluster(sessionId)).fetchStructInfoCopy().getLeader())) != null) {
            selectedEnclaveNode = dataContainer.getEnclaveNode(sessionNodeDO.getEnclaveNodeId());
        }
        return selectedEnclaveNode;
    }

    public static EnclaveNodeDO getAInClusterEnclaveNode(List<EnclaveNodeDO> enclaveNodeDOList, String selfZone) {
        Collections.shuffle(enclaveNodeDOList);
        EnclaveNodeDO selectedEnclaveNode = null;
        for (EnclaveNodeDO enclaveNodeDO : enclaveNodeDOList) {
            EnclaveNodeInfo enclaveNodeInfo = enclaveNodeDO.fetchStructInfoCopy();
            if (!Common.EnclaveNodeStatus.ENCLAVE_IN_CLUSTER.equals((Object)enclaveNodeInfo.getStatus()) && !Common.EnclaveNodeStatus.ENCLAVE_LEADER_RA.equals((Object)enclaveNodeInfo.getStatus())) continue;
            String host = enclaveNodeInfo.getHost();
            String enclaveNodeId = enclaveNodeDO.getEnclaveNodeId();
            if (StringUtil.isEmpty((String)host) || StringUtil.isEmpty((String)enclaveNodeId)) continue;
            selectedEnclaveNode = enclaveNodeDO;
            if (!selfZone.equalsIgnoreCase(enclaveNodeInfo.getZone())) continue;
            return selectedEnclaveNode;
        }
        return selectedEnclaveNode;
    }

    public static boolean isClusterIdListLegal(List<String> queryClusterIds, List<String> serverClusterIds) {
        HashSet<String> queryClusters = new HashSet<String>(queryClusterIds);
        HashSet<String> serverClusters = new HashSet<String>(serverClusterIds);
        return serverClusters.containsAll(queryClusters);
    }

    static EnclaveNodeDO selectAInSessionClusterNode(List<SessionNodeDO> sessionNodeDOList, DataContainer dataContainer, String selfZone) {
        if (sessionNodeDOList.isEmpty()) {
            return null;
        }
        Collections.shuffle(sessionNodeDOList);
        EnclaveNodeDO inClusterNode = null;
        for (SessionNodeDO sessionNodeDO : sessionNodeDOList) {
            if (sessionNodeDO.fetchStructInfoCopy().getStatus() != Common.SessionNodeStatus.SESSION_IN_SESSION || !selfZone.equalsIgnoreCase((inClusterNode = dataContainer.getEnclaveNode(sessionNodeDO.getEnclaveNodeId())).fetchStructInfoCopy().getZone())) continue;
            return inClusterNode;
        }
        return inClusterNode;
    }
}

