/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.data.refresh.session;

import com.alipay.oasis.biz.service.impl.gateway.data.container.DataContainer;
import com.alipay.oasis.biz.service.impl.gateway.data.refresh.session.MsgRefreshSession;
import com.alipay.oasis.common.util.exception.UnexpectException;
import com.alipay.oasis.common.util.msg.BaseMsgHandler;
import com.alipay.oasis.common.util.msg.IMsg;
import com.alipay.oasis.common.util.msg.MsgDispatcher;
import org.springframework.beans.factory.annotation.Autowired;

public class HandlerRefreshSession
extends BaseMsgHandler {
    @Autowired
    private DataContainer dataContainer;

    public void handle(IMsg msg, MsgDispatcher msgDispatcher) {
        MsgRefreshSession msgRefreshSession = (MsgRefreshSession)msg;
        String sessionId = msgRefreshSession.getSessionId();
        switch (msgRefreshSession.getReloadDataBehavior()) {
            case DELETE: {
                this.dataContainer.deleteCacheSession(sessionId);
                break;
            }
            case CREATE: 
            case UPDATE: {
                this.dataContainer.refreshCacheSession(msgRefreshSession.getSessionId());
                break;
            }
            default: {
                throw new UnexpectException("Unknown reload data behavior");
            }
        }
    }

    public void setDataContainer(DataContainer dataContainer) {
        this.dataContainer = dataContainer;
    }
}

