/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.data.container;

import com.alipay.oasis.common.dal.mysql.daointerface.SessionNodeClusterDAO;
import com.alipay.oasis.common.dal.mysql.dataobject.SessionNodeClusterDO;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class SessionNodeClusterCache {
    private final ReentrantReadWriteLock RW_LOCK = new ReentrantReadWriteLock();
    private final SessionNodeClusterDAO sessionNodeClusterDAO;
    private Map<String, SessionNodeClusterDO> sessionIdMapSessionCluster = new ConcurrentHashMap<String, SessionNodeClusterDO>(128);
    private List<SessionNodeClusterDO> sessionNodeClusterDOListFromDb = new ArrayList<SessionNodeClusterDO>(128);

    public SessionNodeClusterCache(SessionNodeClusterDAO sessionNodeClusterDAO) {
        this.sessionNodeClusterDAO = sessionNodeClusterDAO;
    }

    public void refreshAllCachedData() {
        this.reloadDataFromDb();
        this.getWriteLock().lock();
        try {
            this.buildCache(this.sessionNodeClusterDOListFromDb);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    private void reloadDataFromDb() {
        this.sessionNodeClusterDOListFromDb.clear();
        this.sessionNodeClusterDOListFromDb = this.sessionNodeClusterDAO.queryAll();
    }

    public void refreshCachedData(String sessionNodeClusterId) {
        SessionNodeClusterDO sessionNodeClusterDO = this.sessionNodeClusterDAO.querySingle(sessionNodeClusterId);
        if (sessionNodeClusterDO == null) {
            this.sessionIdMapSessionCluster.remove(sessionNodeClusterId);
        } else {
            this.sessionIdMapSessionCluster.put(sessionNodeClusterId, sessionNodeClusterDO);
        }
    }

    public void deleteCacheData(String sessionNodeClusterId) {
        this.sessionIdMapSessionCluster.remove(sessionNodeClusterId);
    }

    public SessionNodeClusterDO getSessionCluster(String sessionClusterId) {
        this.getReadLock().lock();
        try {
            SessionNodeClusterDO sessionNodeClusterDO = this.sessionIdMapSessionCluster.get(sessionClusterId);
            return sessionNodeClusterDO;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    void buildCache(List<SessionNodeClusterDO> sessionNodeClusterDOList) {
        this.sessionIdMapSessionCluster.clear();
        for (SessionNodeClusterDO sessionNodeClusterDO : sessionNodeClusterDOList) {
            this.sessionIdMapSessionCluster.put(sessionNodeClusterDO.getSessionNodeClusterId(), sessionNodeClusterDO);
        }
    }

    private ReentrantReadWriteLock.ReadLock getReadLock() {
        return this.RW_LOCK.readLock();
    }

    private ReentrantReadWriteLock.WriteLock getWriteLock() {
        return this.RW_LOCK.writeLock();
    }
}

