/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.data.container;

import com.alipay.oasis.common.dal.mysql.daointerface.SessionNodeDAO;
import com.alipay.oasis.common.dal.mysql.dataobject.SessionNodeDO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.util.CollectionUtils;

public class SessionNodeCache {
    private final ReentrantReadWriteLock RW_LOCK = new ReentrantReadWriteLock();
    private final SessionNodeDAO sessionNodeDAO;
    Map<String, List<SessionNodeDO>> sessionClusterMapSessionNodes = new ConcurrentHashMap<String, List<SessionNodeDO>>(128);
    List<SessionNodeDO> sessionNodeDOListFromDb = new ArrayList<SessionNodeDO>(1024);
    Map<String, SessionNodeDO> sessionNodeMap = new ConcurrentHashMap<String, SessionNodeDO>(1024);

    public SessionNodeCache(SessionNodeDAO sessionNodeDAO) {
        this.sessionNodeDAO = sessionNodeDAO;
    }

    public void refreshAllCachedData() {
        this.reloadDataFromDb();
        this.getWriteLock().lock();
        try {
            this.buildCache(this.sessionNodeDOListFromDb);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    private void reloadDataFromDb() {
        this.sessionNodeDOListFromDb.clear();
        this.sessionNodeDOListFromDb = this.sessionNodeDAO.queryAll();
    }

    public void refreshCachedData(String sessionNodeClusterId) {
        List sessionNodeDOListInDb;
        List<SessionNodeDO> sessionNodeDOListInCache = this.sessionClusterMapSessionNodes.get(sessionNodeClusterId);
        if (!CollectionUtils.isEmpty(sessionNodeDOListInCache)) {
            for (SessionNodeDO sessionNodeDO : sessionNodeDOListInCache) {
                this.sessionNodeMap.remove(sessionNodeDO.getSessionNodeId());
            }
        }
        if (CollectionUtils.isEmpty((Collection)(sessionNodeDOListInDb = this.sessionNodeDAO.queryBySessionNodeCluster(sessionNodeClusterId)))) {
            this.sessionClusterMapSessionNodes.remove(sessionNodeClusterId);
        } else {
            this.sessionClusterMapSessionNodes.put(sessionNodeClusterId, sessionNodeDOListInDb);
            for (SessionNodeDO sessionNodeDO : sessionNodeDOListInDb) {
                this.sessionNodeMap.put(sessionNodeDO.getEnclaveNodeId(), sessionNodeDO);
            }
        }
    }

    public void deleteCacheData(String sessionNodeClusterId) {
        List<SessionNodeDO> sessionNodeDOListInCache = this.sessionClusterMapSessionNodes.get(sessionNodeClusterId);
        if (!CollectionUtils.isEmpty(sessionNodeDOListInCache)) {
            for (SessionNodeDO sessionNodeDO : sessionNodeDOListInCache) {
                this.sessionNodeMap.remove(sessionNodeDO.getSessionNodeId());
            }
        }
        this.sessionClusterMapSessionNodes.remove(sessionNodeClusterId);
    }

    public boolean hasSessionCluster(String sessionClusterId) {
        this.getReadLock().lock();
        try {
            boolean bl = this.sessionClusterMapSessionNodes.containsKey(sessionClusterId);
            return bl;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public List<SessionNodeDO> getSessionNodes(String sessionClusterId) {
        this.getReadLock().lock();
        try {
            if (this.hasSessionCluster(sessionClusterId)) {
                List<SessionNodeDO> list = this.sessionClusterMapSessionNodes.get(sessionClusterId);
                return list;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return new ArrayList<SessionNodeDO>(0);
    }

    public SessionNodeDO getSessionNode(String sessionNodeId) {
        this.getReadLock().lock();
        try {
            SessionNodeDO sessionNodeDO = this.sessionNodeMap.get(sessionNodeId);
            return sessionNodeDO;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    void buildCache(List<SessionNodeDO> sessionNodeDOList) {
        this.sessionClusterMapSessionNodes.clear();
        this.sessionNodeMap.clear();
        for (SessionNodeDO sessionNodeDO : sessionNodeDOList) {
            String sessionClusterId = sessionNodeDO.getSessionNodeClusterId();
            if (!this.sessionClusterMapSessionNodes.containsKey(sessionClusterId)) {
                ArrayList<SessionNodeDO> newSessionNodes = new ArrayList<SessionNodeDO>(16);
                newSessionNodes.add(sessionNodeDO);
                this.sessionClusterMapSessionNodes.put(sessionClusterId, newSessionNodes);
            } else {
                this.sessionClusterMapSessionNodes.get(sessionClusterId).add(sessionNodeDO);
            }
            this.sessionNodeMap.put(sessionNodeDO.getSessionNodeId(), sessionNodeDO);
        }
    }

    private ReentrantReadWriteLock.ReadLock getReadLock() {
        return this.RW_LOCK.readLock();
    }

    private ReentrantReadWriteLock.WriteLock getWriteLock() {
        return this.RW_LOCK.writeLock();
    }
}

