/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.data.container;

import com.alipay.oasis.common.dal.mysql.daointerface.EnclaveNodeDAO;
import com.alipay.oasis.common.dal.mysql.dataobject.EnclaveNodeDO;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.springframework.util.CollectionUtils;

public class EnclaveNodeCache {
    private final ReentrantReadWriteLock RW_LOCK = new ReentrantReadWriteLock();
    private final EnclaveNodeDAO enclaveNodeDAO;
    Map<String, EnclaveNodeDO> enclaveNodeMap = new ConcurrentHashMap<String, EnclaveNodeDO>(1024);
    List<EnclaveNodeDO> enclaveNodeDOListFromDb = new ArrayList<EnclaveNodeDO>(1024);
    Map<String, List<EnclaveNodeDO>> clusterEnclaveNodeDOMap = new ConcurrentHashMap<String, List<EnclaveNodeDO>>(1024);

    public EnclaveNodeCache(EnclaveNodeDAO enclaveNodeDAO) {
        this.enclaveNodeDAO = enclaveNodeDAO;
    }

    public void refreshAllCachedData() {
        this.reloadDataFromDb();
        this.getWriteLock().lock();
        try {
            this.buildCache(this.enclaveNodeDOListFromDb);
        }
        finally {
            this.getWriteLock().unlock();
        }
    }

    private void reloadDataFromDb() {
        this.enclaveNodeDOListFromDb.clear();
        this.enclaveNodeDOListFromDb = this.enclaveNodeDAO.queryAll();
    }

    public void refreshCacheData(String enclaveNodeClusterId) {
        List enclaveNodeDOListInDb;
        List<EnclaveNodeDO> enclaveNodeDOListInCache = this.clusterEnclaveNodeDOMap.get(enclaveNodeClusterId);
        if (!CollectionUtils.isEmpty(enclaveNodeDOListInCache)) {
            for (EnclaveNodeDO enclaveNodeDO : enclaveNodeDOListInCache) {
                this.enclaveNodeMap.remove(enclaveNodeDO.getEnclaveNodeId());
            }
        }
        if (CollectionUtils.isEmpty((Collection)(enclaveNodeDOListInDb = this.enclaveNodeDAO.queryByEnclaveNodeCluster(enclaveNodeClusterId)))) {
            this.clusterEnclaveNodeDOMap.remove(enclaveNodeClusterId);
        } else {
            this.clusterEnclaveNodeDOMap.put(enclaveNodeClusterId, enclaveNodeDOListInDb);
            for (EnclaveNodeDO enclaveNodeDO : enclaveNodeDOListInDb) {
                this.enclaveNodeMap.put(enclaveNodeDO.getEnclaveNodeId(), enclaveNodeDO);
            }
        }
    }

    public void deleteCacheData(String enclaveNodeClusterId) {
        List<EnclaveNodeDO> enclaveNodeDOListInCache = this.clusterEnclaveNodeDOMap.get(enclaveNodeClusterId);
        if (!CollectionUtils.isEmpty(enclaveNodeDOListInCache)) {
            for (EnclaveNodeDO enclaveNodeDO : enclaveNodeDOListInCache) {
                this.enclaveNodeMap.remove(enclaveNodeDO.getEnclaveNodeId());
            }
        }
        this.clusterEnclaveNodeDOMap.remove(enclaveNodeClusterId);
    }

    public EnclaveNodeDO getEnclaveNodeDO(String enclaveNodeId) {
        this.getReadLock().lock();
        try {
            EnclaveNodeDO enclaveNodeDO = this.enclaveNodeMap.get(enclaveNodeId);
            return enclaveNodeDO;
        }
        finally {
            this.getReadLock().unlock();
        }
    }

    public List<EnclaveNodeDO> getEnclaveNodeDOList(String clusterId) {
        this.getReadLock().lock();
        try {
            if (this.clusterEnclaveNodeDOMap.containsKey(clusterId)) {
                List<EnclaveNodeDO> list = this.clusterEnclaveNodeDOMap.get(clusterId);
                return list;
            }
        }
        finally {
            this.getReadLock().unlock();
        }
        return new ArrayList<EnclaveNodeDO>(0);
    }

    void buildCache(List<EnclaveNodeDO> enclaveNodeDOS) {
        this.enclaveNodeMap.clear();
        this.clusterEnclaveNodeDOMap.clear();
        for (EnclaveNodeDO enclaveNodeDO : enclaveNodeDOS) {
            List<Object> enclaveNodeDOList;
            this.enclaveNodeMap.put(enclaveNodeDO.getEnclaveNodeId(), enclaveNodeDO);
            String clusterId = enclaveNodeDO.getEnclaveNodeClusterId();
            if (this.clusterEnclaveNodeDOMap.containsKey(clusterId)) {
                enclaveNodeDOList = this.clusterEnclaveNodeDOMap.get(clusterId);
            } else {
                enclaveNodeDOList = new ArrayList(8);
                this.clusterEnclaveNodeDOMap.put(clusterId, enclaveNodeDOList);
            }
            enclaveNodeDOList.add(enclaveNodeDO);
        }
    }

    private ReentrantReadWriteLock.ReadLock getReadLock() {
        return this.RW_LOCK.readLock();
    }

    private ReentrantReadWriteLock.WriteLock getWriteLock() {
        return this.RW_LOCK.writeLock();
    }
}

