/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway.data.container;

import com.alibaba.common.lang.StringUtil;
import com.alipay.oasis.biz.service.impl.gateway.data.container.EnclaveNodeCache;
import com.alipay.oasis.biz.service.impl.gateway.data.container.SessionNodeCache;
import com.alipay.oasis.biz.service.impl.gateway.data.container.SessionNodeClusterCache;
import com.alipay.oasis.common.dal.mysql.daointerface.EnclaveNodeDAO;
import com.alipay.oasis.common.dal.mysql.daointerface.SessionNodeClusterDAO;
import com.alipay.oasis.common.dal.mysql.daointerface.SessionNodeDAO;
import com.alipay.oasis.common.dal.mysql.daointerface.TopicDefaultEnclaveNodeClusterDAO;
import com.alipay.oasis.common.dal.mysql.dataobject.EnclaveNodeDO;
import com.alipay.oasis.common.dal.mysql.dataobject.SessionNodeClusterDO;
import com.alipay.oasis.common.dal.mysql.dataobject.SessionNodeDO;
import com.alipay.oasis.common.dal.mysql.dataobject.TopicDefaultEnclaveNodeClusterDO;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;

public class DataContainer {
    SessionNodeCache sessionNodeCache;
    SessionNodeClusterCache sessionNodeClusterCache;
    EnclaveNodeCache enclaveNodeCache;
    @Autowired
    private EnclaveNodeDAO enclaveNodeDAO;
    @Autowired
    private SessionNodeDAO sessionNodeDAO;
    @Autowired
    private SessionNodeClusterDAO sessionNodeClusterDAO;
    @Autowired
    private TopicDefaultEnclaveNodeClusterDAO topicDefaultEnclaveNodeClusterDAO;

    public void init() {
        this.sessionNodeCache = new SessionNodeCache(this.sessionNodeDAO);
        this.sessionNodeClusterCache = new SessionNodeClusterCache(this.sessionNodeClusterDAO);
        this.enclaveNodeCache = new EnclaveNodeCache(this.enclaveNodeDAO);
    }

    public void refreshAllCache() {
        this.enclaveNodeCache.refreshAllCachedData();
        this.sessionNodeCache.refreshAllCachedData();
        this.sessionNodeClusterCache.refreshAllCachedData();
    }

    public void refreshCacheEnclave(String enclaveNodeClusterId) {
        this.enclaveNodeCache.refreshCacheData(enclaveNodeClusterId);
    }

    public void refreshCacheSession(String sessionId) {
        this.sessionNodeCache.refreshCachedData(sessionId);
        this.sessionNodeClusterCache.refreshCachedData(sessionId);
    }

    public void deleteCacheEnclave(String enclaveNodeClusterId) {
        this.enclaveNodeCache.deleteCacheData(enclaveNodeClusterId);
    }

    public void deleteCacheSession(String sessionId) {
        this.sessionNodeCache.deleteCacheData(sessionId);
        this.sessionNodeClusterCache.deleteCacheData(sessionId);
    }

    public String getEnclaveNodeClusterIdByTopicId(String topicId) {
        TopicDefaultEnclaveNodeClusterDO topicDefaultEnclaveNodeClusterDO = this.topicDefaultEnclaveNodeClusterDAO.queryByTopic(topicId);
        if (topicDefaultEnclaveNodeClusterDO == null) {
            return null;
        }
        return topicDefaultEnclaveNodeClusterDO.getEnclaveNodeClusterId();
    }

    public String getEnclaveNodeClusterIdBySessionId(String sessionId) {
        SessionNodeClusterDO sessionCluster = this.getSessionNodeCluster(sessionId);
        return sessionCluster == null ? null : sessionCluster.getEnclaveNodeClusterId();
    }

    public EnclaveNodeDO getLeaderEnclave(String sessionId) {
        SessionNodeClusterDO sessionNodeClusterDO = this.getSessionNodeCluster(sessionId);
        if (sessionNodeClusterDO == null) {
            return null;
        }
        String leaderSessionNodeId = sessionNodeClusterDO.fetchStructInfoCopy().getLeader();
        if (StringUtil.isEmpty((String)leaderSessionNodeId)) {
            return null;
        }
        SessionNodeDO sessionNodeDO = this.getSessionNode(leaderSessionNodeId);
        if (sessionNodeDO == null) {
            return null;
        }
        return this.getEnclaveNode(sessionNodeDO.getEnclaveNodeId());
    }

    public SessionNodeClusterDO getSessionNodeCluster(String sessionId) {
        SessionNodeClusterDO sessionNodeClusterDO = this.sessionNodeClusterCache.getSessionCluster(sessionId);
        if (sessionNodeClusterDO != null) {
            return sessionNodeClusterDO;
        }
        return this.sessionNodeClusterDAO.querySingle(sessionId);
    }

    public List<SessionNodeDO> getSessionNodesFromDb(String sessionClusterId) {
        return this.sessionNodeDAO.queryBySessionNodeCluster(sessionClusterId);
    }

    public EnclaveNodeDO getEnclaveNode(String enclaveNodeId) {
        EnclaveNodeDO enclaveNodeDO = this.enclaveNodeCache.getEnclaveNodeDO(enclaveNodeId);
        if (enclaveNodeDO != null) {
            return enclaveNodeDO;
        }
        return this.enclaveNodeDAO.querySingle(enclaveNodeId);
    }

    public SessionNodeDO getSessionNode(String sessionNodeId) {
        SessionNodeDO sessionNodeDO = this.sessionNodeCache.getSessionNode(sessionNodeId);
        if (sessionNodeDO != null) {
            return sessionNodeDO;
        }
        return this.sessionNodeDAO.querySingle(sessionNodeId);
    }

    public List<EnclaveNodeDO> getEnclaveNodes(String enclaveNodeClusterId) {
        List<EnclaveNodeDO> enclaveNodeDOList = this.enclaveNodeCache.getEnclaveNodeDOList(enclaveNodeClusterId);
        if (!enclaveNodeDOList.isEmpty()) {
            return enclaveNodeDOList;
        }
        return this.enclaveNodeDAO.queryByEnclaveNodeCluster(enclaveNodeClusterId);
    }

    public List<SessionNodeDO> getSessionNodes(String sessionId) {
        List<SessionNodeDO> sessionNodeDOList = this.sessionNodeCache.getSessionNodes(sessionId);
        if (!sessionNodeDOList.isEmpty()) {
            return sessionNodeDOList;
        }
        return this.sessionNodeDAO.queryBySessionNodeCluster(sessionId);
    }

    public void setSessionNodeDAO(SessionNodeDAO sessionNodeDAO) {
        this.sessionNodeDAO = sessionNodeDAO;
    }

    public void setEnclaveNodeDAO(EnclaveNodeDAO enclaveNodeDAO) {
        this.enclaveNodeDAO = enclaveNodeDAO;
    }

    public void setSessionNodeClusterDAO(SessionNodeClusterDAO sessionNodeClusterDAO) {
        this.sessionNodeClusterDAO = sessionNodeClusterDAO;
    }

    public DataContainer setTopicDefaultEnclaveNodeClusterDAO(TopicDefaultEnclaveNodeClusterDAO topicDefaultEnclaveNodeClusterDAO) {
        this.topicDefaultEnclaveNodeClusterDAO = topicDefaultEnclaveNodeClusterDAO;
        return this;
    }

    public void setSessionNodeCache(SessionNodeCache sessionNodeCache) {
        this.sessionNodeCache = sessionNodeCache;
    }

    public void setSessionNodeClusterCache(SessionNodeClusterCache sessionNodeClusterCache) {
        this.sessionNodeClusterCache = sessionNodeClusterCache;
    }

    public void setEnclaveNodeCache(EnclaveNodeCache enclaveNodeCache) {
        this.enclaveNodeCache = enclaveNodeCache;
    }
}

