/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.oasis.biz.service.impl.gateway;

import com.alipay.oasis.common.util.header.Header;
import com.alipay.oasis.common.util.header.HeaderBuilder;
import com.alipay.oasis.proto.Common;
import com.alipay.oasis.proto.enclave_service.EnclaveService;
import com.alipay.oasis.proto.gateway.Gateway;
import com.alipay.oasis.proto.serviceprovider.ServiceProvider;
import java.util.Map;

public class ProtoConverter {
    public static Gateway.GatewayRaFetchMsg1Response convertToGatewayRaFetchMsg1Response(EnclaveService.RaFetchMsg1Response raFetchMsg1Response, String sessionId) {
        Gateway.GatewayRaFetchMsg1Response.Builder builder = Gateway.GatewayRaFetchMsg1Response.newBuilder();
        if (raFetchMsg1Response.hasHeader()) {
            builder.setHeader(raFetchMsg1Response.getHeader());
        }
        if (raFetchMsg1Response.hasMsg1()) {
            builder.setMsg1(raFetchMsg1Response.getMsg1());
        }
        builder.setSessionId(sessionId);
        return builder.build();
    }

    public static Gateway.GatewayRaFetchMsg3Response convertToGatewayRaFetchMsg3Response(EnclaveService.RaFetchMsg3Response raFetchMsg3Response) {
        Gateway.GatewayRaFetchMsg3Response.Builder builder = Gateway.GatewayRaFetchMsg3Response.newBuilder();
        if (raFetchMsg3Response.hasHeader()) {
            builder.setHeader(raFetchMsg3Response.getHeader());
        }
        if (raFetchMsg3Response.hasMsg3()) {
            builder.setMsg3(raFetchMsg3Response.getMsg3());
        }
        return builder.build();
    }

    public static Gateway.GatewayGetEnclaveReportResponse combineGatewayGetEnclaveReportResponse(Map<String, Gateway.GatewayGetEnclaveReportResponse> enclaveReportResponseMap) {
        Gateway.GatewayGetEnclaveReportResponse.Builder builder = Gateway.GatewayGetEnclaveReportResponse.newBuilder();
        for (Gateway.GatewayGetEnclaveReportResponse response : enclaveReportResponseMap.values()) {
            Common.ResponseHeader header = response.getHeader();
            if (!header.getIsSuccess()) {
                return builder.setHeader(header).build();
            }
            if (!builder.hasHeader()) {
                builder.setHeader(header);
            }
            builder.addAllEnclaveQuoteEntrys((Iterable)response.getEnclaveQuoteEntrysList());
        }
        return builder.build();
    }

    public static Gateway.GatewayGetEnclaveReportResponse convertToGatewayGetEnclaveReportResponse(Map<String, EnclaveService.GetEnclaveReportResponse> enclaveReportResponseMap) {
        int i = 0;
        Gateway.GatewayGetEnclaveReportResponse.Builder builder = Gateway.GatewayGetEnclaveReportResponse.newBuilder();
        for (Map.Entry<String, EnclaveService.GetEnclaveReportResponse> entry : enclaveReportResponseMap.entrySet()) {
            String clusterId = entry.getKey();
            EnclaveService.GetEnclaveReportResponse getEnclaveReportResponse = entry.getValue();
            if (!builder.hasHeader() && getEnclaveReportResponse.hasHeader()) {
                builder.setHeader(getEnclaveReportResponse.getHeader());
            }
            Common.EnclaveQuoteEntry.Builder entryBuilder = Common.EnclaveQuoteEntry.newBuilder();
            entryBuilder.setClusterId(clusterId);
            entryBuilder.setEnclaveQuote(getEnclaveReportResponse.getEnclaveQuote());
            builder.addEnclaveQuoteEntrys(i++, entryBuilder.build());
        }
        return builder.build();
    }

    public static Gateway.GatewayRaBizQueryResponse convertToGatewayRaBizQueryResponse(EnclaveService.RaBizQueryResponse raBizQueryResponse) {
        Gateway.GatewayRaBizQueryResponse.Builder builder = Gateway.GatewayRaBizQueryResponse.newBuilder();
        if (raBizQueryResponse.hasHeader()) {
            builder.setHeader(ProtoConverter.dealResponseHeader(raBizQueryResponse.getHeader()));
        }
        if (raBizQueryResponse.hasResultMsg()) {
            builder.setResultMsg(raBizQueryResponse.getResultMsg());
        }
        if (raBizQueryResponse.hasMac()) {
            builder.setMac(raBizQueryResponse.getMac());
        }
        if (raBizQueryResponse.hasSignature()) {
            builder.setSignature(raBizQueryResponse.getSignature());
        }
        if (raBizQueryResponse.hasPlainResultMsg()) {
            builder.setPlainResultMsg(raBizQueryResponse.getPlainResultMsg());
        }
        return builder.build();
    }

    public static Gateway.GatewayRaBizQueryResponseV2 convertToGatewayRaBizQueryResponseV2(EnclaveService.RaBizQueryResponseV2 raBizQueryResponseV2) {
        Gateway.GatewayRaBizQueryResponseV2.Builder builder = Gateway.GatewayRaBizQueryResponseV2.newBuilder();
        if (raBizQueryResponseV2.hasHeader()) {
            builder.setHeader(ProtoConverter.dealResponseHeader(raBizQueryResponseV2.getHeader()));
        }
        if (raBizQueryResponseV2.hasResultMsg()) {
            builder.setResultMsg(raBizQueryResponseV2.getResultMsg());
        }
        if (raBizQueryResponseV2.hasPlainResultMsg()) {
            builder.setPlainResultMsg(raBizQueryResponseV2.getPlainResultMsg());
        }
        if (raBizQueryResponseV2.hasSignature()) {
            builder.setSignature(raBizQueryResponseV2.getSignature());
        }
        return builder.build();
    }

    public static Gateway.GatewayRaFetchSigRlResponse convertToGatewayRaFetchSigRlResponse(ServiceProvider.RaFetchSigRlResponse raFetchSigRlResponse) {
        Gateway.GatewayRaFetchSigRlResponse.Builder builder = Gateway.GatewayRaFetchSigRlResponse.newBuilder();
        if (raFetchSigRlResponse.hasHeader()) {
            builder.setHeader(raFetchSigRlResponse.getHeader());
        }
        if (raFetchSigRlResponse.hasSigRl()) {
            builder.setSigRl(raFetchSigRlResponse.getSigRl());
        }
        if (raFetchSigRlResponse.hasRequestId()) {
            builder.setRequestId(raFetchSigRlResponse.getRequestId());
        }
        return builder.build();
    }

    public static Gateway.GatewayRaFetchVerificationReportResponse convertToGatewayRaFetchVerificationReportResponse(ServiceProvider.RaFetchVerificationReportResponse raFetchVerificationReportResponse) {
        Gateway.GatewayRaFetchVerificationReportResponse.Builder builder = Gateway.GatewayRaFetchVerificationReportResponse.newBuilder();
        if (raFetchVerificationReportResponse.hasHeader()) {
            builder.setHeader(raFetchVerificationReportResponse.getHeader());
        }
        if (raFetchVerificationReportResponse.hasReport()) {
            builder.setReport(raFetchVerificationReportResponse.getReport());
        }
        if (raFetchVerificationReportResponse.hasRequestId()) {
            builder.setRequestId(raFetchVerificationReportResponse.getRequestId());
        }
        if (raFetchVerificationReportResponse.hasXIasreportSignature()) {
            builder.setXIasreportSignature(raFetchVerificationReportResponse.getXIasreportSignature());
        }
        if (raFetchVerificationReportResponse.hasXIasreportSigningCertificate()) {
            builder.setXIasreportSigningCertificate(raFetchVerificationReportResponse.getXIasreportSigningCertificate());
        }
        return builder.build();
    }

    public static Gateway.GatewayAsyncBizQueryResponse convertToGatewayAsyncBizQueryResponse(EnclaveService.AsyncBizQueryResponse asyncBizQueryResponse) {
        Gateway.GatewayAsyncBizQueryResponse.Builder builder = Gateway.GatewayAsyncBizQueryResponse.newBuilder();
        if (asyncBizQueryResponse.hasHeader()) {
            builder.setHeader(asyncBizQueryResponse.getHeader());
        }
        if (asyncBizQueryResponse.hasQueryId()) {
            builder.setQueryId(asyncBizQueryResponse.getQueryId());
        }
        return builder.build();
    }

    public static Gateway.GatewayAsyncBizQueryResponseV2 convertToGatewayAsyncBizQueryResponseV2(EnclaveService.AsyncBizQueryResponseV2 asyncBizQueryResponseV2) {
        Gateway.GatewayAsyncBizQueryResponseV2.Builder builder = Gateway.GatewayAsyncBizQueryResponseV2.newBuilder();
        if (asyncBizQueryResponseV2.hasHeader()) {
            builder.setHeader(asyncBizQueryResponseV2.getHeader());
        }
        if (asyncBizQueryResponseV2.hasQueryId()) {
            builder.setQueryId(asyncBizQueryResponseV2.getQueryId());
        }
        return builder.build();
    }

    public static Gateway.GatewayPollAsyncBizQueryResultResponse convertToGatewayPollAsyncBizQueryResultResponse(EnclaveService.PollAsyncBizQueryResultResponse asyncBizQueryResultResponse) {
        Gateway.GatewayPollAsyncBizQueryResultResponse.Builder builder = Gateway.GatewayPollAsyncBizQueryResultResponse.newBuilder();
        if (asyncBizQueryResultResponse.hasHeader()) {
            builder.setHeader(asyncBizQueryResultResponse.getHeader());
        }
        if (asyncBizQueryResultResponse.hasResultReady()) {
            builder.setResultReady(asyncBizQueryResultResponse.hasResultReady());
        }
        if (asyncBizQueryResultResponse.hasProgressBar()) {
            builder.setProgressBar(asyncBizQueryResultResponse.getProgressBar());
        }
        if (asyncBizQueryResultResponse.hasResultMsg()) {
            builder.setResultMsg(asyncBizQueryResultResponse.getResultMsg());
        }
        if (asyncBizQueryResultResponse.hasMac()) {
            builder.setMac(asyncBizQueryResultResponse.getMac());
        }
        if (asyncBizQueryResultResponse.hasPlainResultMsg()) {
            builder.setPlainResultMsg(asyncBizQueryResultResponse.getPlainResultMsg());
        }
        if (asyncBizQueryResultResponse.hasSignature()) {
            builder.setSignature(asyncBizQueryResultResponse.getSignature());
        }
        return builder.build();
    }

    public static Gateway.GatewayFinishAsyncBizQueryResponse convertToGatewayFinishAsyncBizQueryResponse(EnclaveService.FinishAsyncBizQueryResponse finishAsyncBizQueryResponse) {
        Gateway.GatewayFinishAsyncBizQueryResponse.Builder builder = Gateway.GatewayFinishAsyncBizQueryResponse.newBuilder();
        if (finishAsyncBizQueryResponse.hasHeader()) {
            builder.setHeader(finishAsyncBizQueryResponse.getHeader());
        }
        return builder.build();
    }

    public static EnclaveService.RaFetchMsg1Request convertToRaFetchMsg1Request(Gateway.GatewayRaFetchMsg1Request gatewayRaFetchMsg1Request, String sessionId, Header header) {
        EnclaveService.RaFetchMsg1Request.Builder builder = EnclaveService.RaFetchMsg1Request.newBuilder();
        builder.setHeader(HeaderBuilder.buildRequestHeader((Header)header));
        if (gatewayRaFetchMsg1Request.hasTopicId()) {
            builder.setTopicId(gatewayRaFetchMsg1Request.getTopicId());
        }
        if (gatewayRaFetchMsg1Request.hasNonce()) {
            builder.setNonce(gatewayRaFetchMsg1Request.getNonce());
        }
        builder.setSessionId(sessionId);
        Common.ChallengerInfo.Builder challengerBuilder = Common.ChallengerInfo.newBuilder();
        challengerBuilder.setChallengerType(Common.ChallengerInfo.ChallengerType.CHALLENGER_TYPE_BIZ);
        if (gatewayRaFetchMsg1Request.hasSourceBizClientId()) {
            challengerBuilder.setSourceBizClientId(gatewayRaFetchMsg1Request.getSourceBizClientId());
        }
        builder.setChallengerInfo(challengerBuilder.build());
        return builder.build();
    }

    public static EnclaveService.RaFetchMsg3Request convertToRaFetchMsg3Request(Gateway.GatewayRaFetchMsg3Request gatewayRaFetchMsg3Request, Header header) {
        EnclaveService.RaFetchMsg3Request.Builder builder = EnclaveService.RaFetchMsg3Request.newBuilder();
        builder.setHeader(HeaderBuilder.buildRequestHeader((Header)header));
        if (gatewayRaFetchMsg3Request.hasTopicId()) {
            builder.setTopicId(gatewayRaFetchMsg3Request.getTopicId());
        }
        if (gatewayRaFetchMsg3Request.hasMsg2()) {
            builder.setMsg2(gatewayRaFetchMsg3Request.getMsg2());
        }
        if (gatewayRaFetchMsg3Request.hasSessionId()) {
            builder.setSessionId(gatewayRaFetchMsg3Request.getSessionId());
        }
        Common.ChallengerInfo.Builder challengerBuilder = Common.ChallengerInfo.newBuilder();
        challengerBuilder.setChallengerType(Common.ChallengerInfo.ChallengerType.CHALLENGER_TYPE_BIZ);
        builder.setChallengerInfo(challengerBuilder.build());
        return builder.build();
    }

    public static EnclaveService.GetEnclaveReportRequest convertToGetEnclaveReportRequest(Gateway.GatewayGetEnclaveReportRequest gatewayGetEnclaveReportRequest, Header header, String enclaveNodeClusterId) {
        EnclaveService.GetEnclaveReportRequest.Builder builder = EnclaveService.GetEnclaveReportRequest.newBuilder();
        builder.setHeader(HeaderBuilder.buildRequestHeader((Header)header));
        if (gatewayGetEnclaveReportRequest.hasTopicId()) {
            builder.setTopicId(gatewayGetEnclaveReportRequest.getTopicId());
        }
        builder.setClusterId(enclaveNodeClusterId);
        return builder.build();
    }

    public static EnclaveService.RaBizQueryRequest convertToRaBizQueryRequest(Gateway.GatewayRaBizQueryRequest gatewayRaBizQueryRequest, Header header, Common.EnclaveConfigMetaInfo enclaveConfigMetaInfo, Common.AsyncQueryInfo asyncQueryInfo) {
        EnclaveService.RaBizQueryRequest.Builder builder = EnclaveService.RaBizQueryRequest.newBuilder();
        builder.setHeader(HeaderBuilder.buildRequestHeader((Header)header));
        if (gatewayRaBizQueryRequest.hasTopicId()) {
            builder.setTopicId(gatewayRaBizQueryRequest.getTopicId());
        }
        if (gatewayRaBizQueryRequest.hasSessionId()) {
            builder.setSessionId(gatewayRaBizQueryRequest.getSessionId());
        }
        if (gatewayRaBizQueryRequest.hasRequestMsg()) {
            builder.setRequestMsg(gatewayRaBizQueryRequest.getRequestMsg());
        }
        if (gatewayRaBizQueryRequest.hasMac()) {
            builder.setMac(gatewayRaBizQueryRequest.getMac());
        }
        if (gatewayRaBizQueryRequest.hasPlainMsg()) {
            builder.setPlainMsg(gatewayRaBizQueryRequest.getPlainMsg());
        }
        if (gatewayRaBizQueryRequest.hasClusterQueryModeInfo()) {
            builder.setClusterQueryModeInfo(gatewayRaBizQueryRequest.getClusterQueryModeInfo());
        }
        if (gatewayRaBizQueryRequest.hasQueryMode()) {
            builder.setQueryMode(gatewayRaBizQueryRequest.getQueryMode());
        }
        if (gatewayRaBizQueryRequest.hasBizRoutingType()) {
            builder.setBizRoutingType(gatewayRaBizQueryRequest.getBizRoutingType());
        }
        if (gatewayRaBizQueryRequest.hasSignature()) {
            builder.setSignature(gatewayRaBizQueryRequest.getSignature());
        }
        if (gatewayRaBizQueryRequest.hasScene()) {
            builder.setScene(gatewayRaBizQueryRequest.getScene());
        }
        if (enclaveConfigMetaInfo != null) {
            builder.addEnclaveConfigMetaInfoList(enclaveConfigMetaInfo);
        }
        if (asyncQueryInfo != null) {
            builder.setAsyncQueryInfo(asyncQueryInfo);
        }
        return builder.build();
    }

    public static EnclaveService.RaBizQueryRequestV2 convertToRaBizQueryRequestV2(Gateway.GatewayRaBizQueryRequestV2 gatewayRaBizQueryRequestV2, Header header, Common.EnclaveConfigMetaInfo enclaveConfigMetaInfo, Common.AsyncQueryInfo asyncQueryInfo) {
        EnclaveService.RaBizQueryRequestV2.Builder builder = EnclaveService.RaBizQueryRequestV2.newBuilder();
        builder.setHeader(HeaderBuilder.buildRequestHeader((Header)header));
        if (gatewayRaBizQueryRequestV2.hasTopicId()) {
            builder.setTopicId(gatewayRaBizQueryRequestV2.getTopicId());
        }
        if (gatewayRaBizQueryRequestV2.hasClusterId()) {
            builder.setClusterId(gatewayRaBizQueryRequestV2.getClusterId());
        }
        if (gatewayRaBizQueryRequestV2.hasBizRoutingType()) {
            builder.setBizRoutingType(gatewayRaBizQueryRequestV2.getBizRoutingType());
        }
        if (enclaveConfigMetaInfo != null) {
            builder.addEnclaveConfigMetaInfoList(enclaveConfigMetaInfo);
        }
        if (asyncQueryInfo != null) {
            builder.setAsyncQueryInfo(asyncQueryInfo);
        }
        if (gatewayRaBizQueryRequestV2.hasMultiPartyEntries()) {
            builder.setMultiPartyEntries(gatewayRaBizQueryRequestV2.getMultiPartyEntries());
        }
        if (gatewayRaBizQueryRequestV2.hasSignature()) {
            builder.setSignature(gatewayRaBizQueryRequestV2.getSignature());
        }
        return builder.build();
    }

    public static EnclaveService.RaSetSessionBizKeyRequest convertToRaSetSessionBizKeyRequest(Gateway.GatewayRaSetSessionBizKeyRequest gatewayRaSetSessionBizKeyRequest, Header header) {
        EnclaveService.RaSetSessionBizKeyRequest.Builder builder = EnclaveService.RaSetSessionBizKeyRequest.newBuilder();
        builder.setHeader(HeaderBuilder.buildRequestHeader((Header)header));
        if (gatewayRaSetSessionBizKeyRequest.hasTopicId()) {
            builder.setTopicId(gatewayRaSetSessionBizKeyRequest.getTopicId());
        }
        if (gatewayRaSetSessionBizKeyRequest.hasSessionId()) {
            builder.setSessionId(gatewayRaSetSessionBizKeyRequest.getSessionId());
        }
        if (gatewayRaSetSessionBizKeyRequest.hasSessionBizKey()) {
            builder.setSessionBizKey(gatewayRaSetSessionBizKeyRequest.getSessionBizKey());
        }
        return builder.build();
    }

    public static ServiceProvider.RaFetchSigRlRequest convertToRaFetchSigRlRequest(Gateway.GatewayRaFetchSigRlRequest gatewayRaFetchSigRlRequest, String callerId, Header header) {
        ServiceProvider.RaFetchSigRlRequest.Builder builder = ServiceProvider.RaFetchSigRlRequest.newBuilder();
        builder.setHeader(HeaderBuilder.buildRequestHeader((Header)header));
        if (gatewayRaFetchSigRlRequest.hasGid()) {
            builder.setGid(gatewayRaFetchSigRlRequest.getGid());
        }
        builder.setCallerId(callerId);
        if (gatewayRaFetchSigRlRequest.hasUseDevelopCertificate()) {
            builder.setUseDevelopCertificate(gatewayRaFetchSigRlRequest.getUseDevelopCertificate());
        }
        return builder.build();
    }

    public static ServiceProvider.RaFetchVerificationReportRequest convertToRaFetchVerificationReportRequest(Gateway.GatewayRaFetchVerificationReportRequest gatewayRaFetchVerificationReportRequest, String callerId, Header header) {
        ServiceProvider.RaFetchVerificationReportRequest.Builder builder = ServiceProvider.RaFetchVerificationReportRequest.newBuilder();
        builder.setHeader(HeaderBuilder.buildRequestHeader((Header)header));
        if (gatewayRaFetchVerificationReportRequest.hasIsvEnclaveQuote()) {
            builder.setIsvEnclaveQuote(gatewayRaFetchVerificationReportRequest.getIsvEnclaveQuote());
        }
        if (gatewayRaFetchVerificationReportRequest.hasPseManifest()) {
            builder.setPseManifest(gatewayRaFetchVerificationReportRequest.getPseManifest());
        }
        if (gatewayRaFetchVerificationReportRequest.hasNonce()) {
            builder.setNonce(gatewayRaFetchVerificationReportRequest.getNonce());
        }
        builder.setCallerId(callerId);
        if (gatewayRaFetchVerificationReportRequest.hasUseDevelopCertificate()) {
            builder.setUseDevelopCertificate(gatewayRaFetchVerificationReportRequest.getUseDevelopCertificate());
        }
        return builder.build();
    }

    public static EnclaveService.PollAsyncBizQueryResultRequest convertToPollAsyncBizQueryResultRequest(Gateway.GatewayPollAsyncBizQueryResultRequest gatewayPollAsyncBizQueryResultRequest, Header header) {
        EnclaveService.PollAsyncBizQueryResultRequest.Builder builder = EnclaveService.PollAsyncBizQueryResultRequest.newBuilder();
        builder.setHeader(HeaderBuilder.buildRequestHeader((Header)header));
        if (gatewayPollAsyncBizQueryResultRequest.hasTopicId()) {
            builder.setTopicId(gatewayPollAsyncBizQueryResultRequest.getTopicId());
        }
        if (gatewayPollAsyncBizQueryResultRequest.hasSessionId()) {
            builder.setSessionId(gatewayPollAsyncBizQueryResultRequest.getSessionId());
        }
        if (gatewayPollAsyncBizQueryResultRequest.hasClusterId()) {
            builder.setClusterId(gatewayPollAsyncBizQueryResultRequest.getClusterId());
        }
        if (gatewayPollAsyncBizQueryResultRequest.hasQueryId()) {
            builder.setQueryId(gatewayPollAsyncBizQueryResultRequest.getQueryId());
        }
        return builder.build();
    }

    public static EnclaveService.FinishAsyncBizQueryRequest convertToFinishAsyncBizQueryRequest(Gateway.GatewayFinishAsyncBizQueryRequest gatewayFinishAsyncBizQueryRequest, Header header) {
        EnclaveService.FinishAsyncBizQueryRequest.Builder builder = EnclaveService.FinishAsyncBizQueryRequest.newBuilder();
        builder.setHeader(HeaderBuilder.buildRequestHeader((Header)header));
        if (gatewayFinishAsyncBizQueryRequest.hasTopicId()) {
            builder.setTopicId(gatewayFinishAsyncBizQueryRequest.getTopicId());
        }
        if (gatewayFinishAsyncBizQueryRequest.hasSessionId()) {
            builder.setSessionId(gatewayFinishAsyncBizQueryRequest.getSessionId());
        }
        if (gatewayFinishAsyncBizQueryRequest.hasClusterId()) {
            builder.setClusterId(gatewayFinishAsyncBizQueryRequest.getClusterId());
        }
        if (gatewayFinishAsyncBizQueryRequest.hasQueryId()) {
            builder.setQueryId(gatewayFinishAsyncBizQueryRequest.getQueryId());
        }
        return builder.build();
    }

    public static Common.ResponseHeader dealResponseHeader(Common.ResponseHeader responseHeaderFromEs) {
        if (responseHeaderFromEs.hasErrorCode() && responseHeaderFromEs.getErrorCode() == Common.ErrorCode.UNKNOWN_SESSION) {
            Common.ResponseHeader.Builder builder = responseHeaderFromEs.toBuilder();
            builder.setErrorCode(Common.ErrorCode.EXPIRED_SESSION);
            return builder.build();
        }
        return responseHeaderFromEs;
    }
}

