/*
 * Decompiled with CFR 0.152.
 */
package com.alipay.api;

import com.alipay.api.AlipayApiException;
import com.alipay.api.AlipayClient;
import com.alipay.api.AlipayOpenAppAlipaycertDownloadRequest;
import com.alipay.api.AlipayOpenAppAlipaycertDownloadResponse;
import com.alipay.api.AlipayParser;
import com.alipay.api.AlipayRequest;
import com.alipay.api.AlipayRequestWrapper;
import com.alipay.api.AlipayResponse;
import com.alipay.api.AlipayUploadRequest;
import com.alipay.api.BatchAlipayRequest;
import com.alipay.api.BatchAlipayResponse;
import com.alipay.api.CertItem;
import com.alipay.api.Decryptor;
import com.alipay.api.DefaultSignChecker;
import com.alipay.api.Encryptor;
import com.alipay.api.FileItem;
import com.alipay.api.ResponseEncryptItem;
import com.alipay.api.SignChecker;
import com.alipay.api.SignItem;
import com.alipay.api.Signer;
import com.alipay.api.internal.parser.json.ObjectJsonParser;
import com.alipay.api.internal.parser.xml.ObjectXmlParser;
import com.alipay.api.internal.util.AlipayHashMap;
import com.alipay.api.internal.util.AlipayLogger;
import com.alipay.api.internal.util.AlipaySignature;
import com.alipay.api.internal.util.AlipayUtils;
import com.alipay.api.internal.util.AntCertificationUtil;
import com.alipay.api.internal.util.LoadTestUtil;
import com.alipay.api.internal.util.RequestParametersHolder;
import com.alipay.api.internal.util.StringUtils;
import com.alipay.api.internal.util.WebUtils;
import com.alipay.api.internal.util.codec.Base64;
import com.alipay.api.internal.util.file.FileUtils;
import com.alipay.api.internal.util.json.JSONWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigInteger;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLException;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractAlipayClient
implements AlipayClient {
    private String serverUrl;
    private String appId;
    private String prodCode;
    private String format = "json";
    private String signType = "RSA";
    private String encryptType = "AES";
    private String charset;
    private int connectTimeout = 3000;
    private int readTimeout = 15000;
    private String proxyHost;
    private int proxyPort;
    private SignChecker signChecker;
    private String appCertSN;
    private String alipayCertSN;
    private String alipayRootCertSN;
    private String alipayRootSm2CertSN;
    private String rootCertContent;
    private X509Certificate cert;
    private ConcurrentHashMap<String, X509Certificate> alipayPublicCertMap;
    private ConcurrentHashMap<String, String> alipayPublicKeyMap;
    protected boolean loadTest = false;
    private static final String BATCH_API_DEFAULT_SPLIT = "#S#";

    public AbstractAlipayClient(String serverUrl, String appId, String format, String charset, String signType) {
        this.serverUrl = serverUrl;
        this.appId = appId;
        if (!StringUtils.isEmpty(format)) {
            this.format = format;
        }
        this.charset = charset;
        if (!StringUtils.isEmpty(signType)) {
            this.signType = signType;
        }
    }

    public AbstractAlipayClient(String serverUrl, String appId, String format, String charset, String signType, String proxyHost, int proxyPort) {
        this(serverUrl, appId, format, charset, signType);
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
    }

    public AbstractAlipayClient(String serverUrl, String appId, String format, String charset, String signType, String encryptType) {
        this(serverUrl, appId, format, charset, signType);
        if (!StringUtils.isEmpty(encryptType)) {
            this.encryptType = encryptType;
        }
    }

    public AbstractAlipayClient(String serverUrl, String appId, String format, String charset, String signType, String certPath, String alipayPublicCertPath, String rootCertPath, String proxyHost, int proxyPort, String encryptType) throws AlipayApiException {
        this(serverUrl, appId, format, charset, signType);
        if (!StringUtils.isEmpty(encryptType)) {
            this.encryptType = encryptType;
        }
        this.proxyHost = proxyHost;
        this.proxyPort = proxyPort;
        this.rootCertContent = this.readFileToString(rootCertPath);
        if ("SM2".equals(signType)) {
            this.alipayRootSm2CertSN = AntCertificationUtil.getRootCertSN(this.rootCertContent, "SM2");
        } else {
            this.alipayRootCertSN = AntCertificationUtil.getRootCertSN(this.rootCertContent);
            if (StringUtils.isEmpty(this.alipayRootCertSN)) {
                throw new AlipayApiException("AlipayRootCert Is Invalid");
            }
        }
        this.cert = this.getCert(certPath);
        X509Certificate alipayPublicCert = this.getCert(alipayPublicCertPath);
        this.appCertSN = this.getCertSN(this.cert);
        if (StringUtils.isEmpty(this.appCertSN)) {
            throw new AlipayApiException("AppCert Is Invalid");
        }
        this.alipayCertSN = this.getCertSN(alipayPublicCert);
        ConcurrentHashMap<String, X509Certificate> alipayPublicCertMap = new ConcurrentHashMap<String, X509Certificate>();
        alipayPublicCertMap.put(this.alipayCertSN, alipayPublicCert);
        this.alipayPublicCertMap = alipayPublicCertMap;
        PublicKey publicKey = alipayPublicCert.getPublicKey();
        ConcurrentHashMap<String, String> alipayPublicKeyMap = new ConcurrentHashMap<String, String>();
        alipayPublicKeyMap.put(this.alipayCertSN, Base64.encodeBase64String(publicKey.getEncoded()));
        this.alipayPublicKeyMap = alipayPublicKeyMap;
    }

    private X509Certificate getCert(String certPath) throws AlipayApiException {
        FileInputStream inputStream = null;
        try {
            X509Certificate cert;
            inputStream = new FileInputStream(certPath);
            Security.addProvider((Provider)new BouncyCastleProvider());
            CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate x509Certificate = cert = (X509Certificate)cf.generateCertificate(inputStream);
            return x509Certificate;
        }
        catch (NoSuchProviderException e) {
            throw new AlipayApiException(e);
        }
        catch (IOException e) {
            throw new AlipayApiException(e);
        }
        catch (CertificateException e) {
            throw new AlipayApiException(e);
        }
        finally {
            try {
                if (inputStream != null) {
                    ((InputStream)inputStream).close();
                }
            }
            catch (IOException e) {
                throw new AlipayApiException(e);
            }
        }
    }

    private String getCertSN(X509Certificate cf) throws AlipayApiException {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.update((cf.getIssuerX500Principal().getName() + cf.getSerialNumber()).getBytes());
            String certSN = new BigInteger(1, md.digest()).toString(16);
            certSN = AbstractAlipayClient.fillMD5(certSN);
            return certSN;
        }
        catch (NoSuchAlgorithmException e) {
            throw new AlipayApiException(e);
        }
    }

    private static String fillMD5(String md5) {
        return md5.length() == 32 ? md5 : AbstractAlipayClient.fillMD5("0" + md5);
    }

    private String readFileToString(String rootCertPath) throws AlipayApiException {
        try {
            File file = new File(rootCertPath);
            String client = FileUtils.readFileToString(file);
            return client;
        }
        catch (IOException e) {
            throw new AlipayApiException(e);
        }
    }

    private boolean verifyCert(String cert) {
        return AntCertificationUtil.isTrusted(cert, this.rootCertContent);
    }

    @Override
    public <T extends AlipayResponse> T certificateExecute(AlipayRequest<T> request) throws AlipayApiException {
        return this.certificateExecute(request, null);
    }

    @Override
    public <T extends AlipayResponse> T certificateExecute(AlipayRequest<T> request, String accessToken) throws AlipayApiException {
        return this.certificateExecute(request, accessToken, null);
    }

    @Override
    public <T extends AlipayResponse> T certificateExecute(AlipayRequest<T> request, String accessToken, String appAuthToken) throws AlipayApiException {
        return this._certificateExecute(request, accessToken, appAuthToken, null);
    }

    @Override
    public <T extends AlipayResponse> T certificateExecute(AlipayRequest<T> request, String accessToken, String appAuthToken, String targetAppId) throws AlipayApiException {
        return this._certificateExecute(request, accessToken, appAuthToken, targetAppId);
    }

    public <T extends AlipayResponse> T _certificateExecute(AlipayRequest<T> request, String accessToken, String appAuthToken, String targetAppId) throws AlipayApiException {
        AlipayResponse tRsp = null;
        try {
            long beginTime = System.currentTimeMillis();
            Map<String, Object> rt = this.doPost(request, accessToken, appAuthToken, this.appCertSN, targetAppId);
            HashMap<String, Long> costTimeMap = new HashMap<String, Long>();
            if (rt.containsKey("prepareTime")) {
                costTimeMap.put("prepareCostTime", (Long)rt.get("prepareTime") - beginTime);
                if (rt.containsKey("requestTime")) {
                    costTimeMap.put("requestCostTime", (Long)rt.get("requestTime") - (Long)rt.get("prepareTime"));
                }
            }
            AlipayParser<T> parser = null;
            parser = "xml".equals(this.format) ? new ObjectXmlParser<T>(request.getResponseClass()) : new ObjectJsonParser<T>(request.getResponseClass());
            ResponseEncryptItem responseItem = this.decryptResponse(request, rt, parser);
            tRsp = (AlipayResponse)parser.parse(responseItem.getRealContent());
            tRsp.setBody(responseItem.getRealContent());
            this.checkResponseCertSign(request, parser, responseItem.getRespContent(), tRsp.isSuccess());
            if (costTimeMap.containsKey("requestCostTime")) {
                costTimeMap.put("postCostTime", System.currentTimeMillis() - (Long)rt.get("requestTime"));
            }
            tRsp.setParams((AlipayHashMap)rt.get("textParams"));
            if (!tRsp.isSuccess()) {
                AlipayLogger.logErrorScene(rt, tRsp, "", costTimeMap);
            } else {
                AlipayLogger.logBizSummary(rt, tRsp, costTimeMap);
            }
            return (T)tRsp;
        }
        catch (RuntimeException e) {
            AlipayLogger.logBizError(e);
            throw new AlipayApiException(e);
        }
        catch (AlipayApiException e) {
            AlipayLogger.logBizError(e);
            throw new AlipayApiException(e);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private <T extends AlipayResponse> void checkResponseCertSign(AlipayRequest<T> request, AlipayParser<T> parser, String responseBody, boolean responseIsSuccess) throws AlipayApiException {
        CertItem certItem = parser.getCertItem(request, responseBody);
        if (certItem == null) {
            throw new AlipayApiException("cert check fail: Body is Empty!");
        }
        if (certItem.getCert() == null && responseIsSuccess && !request.getApiMethodName().equals("alipay.open.app.alipaycert.download")) {
            throw new AlipayApiException("cert check fail: ALIPAY_CERT_SN is Empty!");
        }
        String alipayPublicKey = null;
        if (certItem.getCert() == null) return;
        if (!this.alipayPublicCertMap.containsKey(certItem.getCert())) {
            AlipayOpenAppAlipaycertDownloadRequest alipayRequest = new AlipayOpenAppAlipaycertDownloadRequest();
            alipayRequest.setBizContent("{\"alipay_cert_sn\":\"" + certItem.getCert() + "\"  }");
            Map<String, Object> rt = this.doPost(alipayRequest, null, null, this.appCertSN, null);
            String respContent = rt.get("rsp").toString();
            ObjectJsonParser<AlipayOpenAppAlipaycertDownloadResponse> parserCert = null;
            parserCert = new ObjectJsonParser<AlipayOpenAppAlipaycertDownloadResponse>(alipayRequest.getResponseClass());
            AlipayOpenAppAlipaycertDownloadResponse alipayResponse = (AlipayOpenAppAlipaycertDownloadResponse)parserCert.parse(respContent);
            if (!alipayResponse.isSuccess()) {
                throw new AlipayApiException("\u652f\u4ed8\u5b9d\u516c\u94a5\u8bc1\u4e66\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4e3a\u652f\u4ed8\u5b9d\u7b7e\u53d1\u7684\u6709\u6548\u516c\u94a5\u8bc1\u4e66");
            }
            String alipayCertContent = alipayResponse.getAlipayCertContent();
            InputStream inputStream = null;
            try {
                byte[] alipayCert = Base64.decodeBase64String(alipayCertContent);
                String alipayPublicCertStr = new String(alipayCert);
                if (!this.verifyCert(alipayPublicCertStr)) {
                    throw new AlipayApiException("\u652f\u4ed8\u5b9d\u516c\u94a5\u8bc1\u4e66\u6821\u9a8c\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u4e3a\u652f\u4ed8\u5b9d\u7b7e\u53d1\u7684\u6709\u6548\u516c\u94a5\u8bc1\u4e66");
                }
                inputStream = new ByteArrayInputStream(alipayCert);
                CertificateFactory cf = CertificateFactory.getInstance("X.509", "BC");
                X509Certificate alipayPublicCertNew = (X509Certificate)cf.generateCertificate(inputStream);
                String alipayCertSNNew = this.getCertSN(alipayPublicCertNew);
                this.alipayPublicCertMap.put(alipayCertSNNew, alipayPublicCertNew);
                PublicKey publicKey = alipayPublicCertNew.getPublicKey();
                String alipayPublicKeyNew = Base64.encodeBase64String(publicKey.getEncoded());
                this.alipayPublicKeyMap.put(alipayCertSNNew, alipayPublicKeyNew);
            }
            catch (NoSuchProviderException e) {
                throw new AlipayApiException(e);
            }
            catch (CertificateException e) {
                throw new AlipayApiException(e);
            }
            finally {
                try {
                    if (inputStream != null) {
                        inputStream.close();
                    }
                }
                catch (IOException e) {
                    throw new AlipayApiException(e);
                }
            }
        }
        if (!this.alipayPublicKeyMap.containsKey(certItem.getCert())) {
            PublicKey publicKey = this.alipayPublicCertMap.get(certItem.getCert()).getPublicKey();
            this.alipayPublicKeyMap.put(certItem.getCert(), Base64.encodeBase64String(publicKey.getEncoded()));
        }
        if (!this.alipayPublicCertMap.containsKey(certItem.getCert())) throw new AlipayApiException("cert check fail: check Cert and Data Fail! CertSN non-existent");
        alipayPublicKey = this.alipayPublicKeyMap.get(certItem.getCert());
        if (!responseIsSuccess && (responseIsSuccess || StringUtils.isEmpty(certItem.getSign()))) return;
        this.signChecker = new DefaultSignChecker(alipayPublicKey);
        boolean rsaCheckContent = this.signChecker.checkCert(certItem.getSignSourceDate(), certItem.getSign(), this.signType, this.charset, alipayPublicKey);
        if (rsaCheckContent) return;
        if (StringUtils.isEmpty(certItem.getSignSourceDate()) || !certItem.getSignSourceDate().contains("\\/")) throw new AlipayApiException("cert check fail: check Cert and Data Fail!");
        String srouceData = certItem.getSignSourceDate().replace("\\/", "/");
        boolean jsonCheck = this.getSignChecker().check(srouceData, certItem.getSign(), this.signType, this.charset);
        if (jsonCheck) return;
        throw new AlipayApiException("cert check fail: check Cert and Data Fail\uff01JSON also\uff01");
    }

    @Override
    public <T extends AlipayResponse> T execute(AlipayRequest<T> request) throws AlipayApiException {
        return this.execute(request, null);
    }

    @Override
    public <T extends AlipayResponse> T execute(AlipayRequest<T> request, String accessToken) throws AlipayApiException {
        return this.execute(request, accessToken, null);
    }

    @Override
    public <T extends AlipayResponse> T execute(AlipayRequest<T> request, String accessToken, String appAuthToken) throws AlipayApiException {
        return this.execute(request, accessToken, appAuthToken, null);
    }

    @Override
    public <T extends AlipayResponse> T execute(AlipayRequest<T> request, String accessToken, String appAuthToken, String targetAppId) throws AlipayApiException {
        if (!StringUtils.isEmpty(this.alipayRootCertSN)) {
            throw new AlipayApiException("\u68c0\u6d4b\u5230\u8bc1\u4e66\u76f8\u5173\u53c2\u6570\u5df2\u521d\u59cb\u5316\uff0c\u8bc1\u4e66\u6a21\u5f0f\u4e0b\u8bf7\u6539\u4e3a\u8c03\u7528certificateExecute");
        }
        AlipayParser<T> parser = null;
        parser = "xml".equals(this.format) ? new ObjectXmlParser<T>(request.getResponseClass()) : new ObjectJsonParser<T>(request.getResponseClass());
        return this._execute(request, parser, accessToken, appAuthToken, targetAppId);
    }

    @Override
    public BatchAlipayResponse execute(BatchAlipayRequest request) throws AlipayApiException {
        long beginTime = System.currentTimeMillis();
        Map<String, Object> rt = this.doPost(request);
        if (rt == null) {
            return null;
        }
        HashMap<String, Long> costTimeMap = new HashMap<String, Long>();
        if (rt.containsKey("prepareTime")) {
            costTimeMap.put("prepareCostTime", (Long)rt.get("prepareTime") - beginTime);
            if (rt.containsKey("requestTime")) {
                costTimeMap.put("requestCostTime", (Long)rt.get("requestTime") - (Long)rt.get("prepareTime"));
            }
        }
        AlipayParser<BatchAlipayResponse> parser = null;
        parser = "xml".equals(this.format) ? new ObjectXmlParser<BatchAlipayResponse>(request.getResponseClass()) : new ObjectJsonParser<BatchAlipayResponse>(request.getResponseClass());
        BatchAlipayResponse batchAlipayResponse = null;
        try {
            ResponseEncryptItem responseItem = this.decryptResponse(request, rt, parser);
            batchAlipayResponse = parser.parse(responseItem.getRealContent());
            batchAlipayResponse.setBody(responseItem.getRealContent());
            this.checkResponseSign(request, parser, responseItem.getRespContent(), batchAlipayResponse.isSuccess());
            if (costTimeMap.containsKey("requestCostTime")) {
                costTimeMap.put("postCostTime", System.currentTimeMillis() - (Long)rt.get("requestTime"));
            }
            ArrayList parserList = new ArrayList();
            List<AlipayRequestWrapper> requestList = request.getRequestList();
            if ("xml".equals(this.format)) {
                for (AlipayRequestWrapper aRequestList : requestList) {
                    parserList.add(new ObjectXmlParser(aRequestList.getAlipayRequest().getResponseClass()));
                }
            } else {
                for (AlipayRequestWrapper aRequestList : requestList) {
                    parserList.add(new ObjectJsonParser(aRequestList.getAlipayRequest().getResponseClass()));
                }
            }
            if (!batchAlipayResponse.isSuccess()) {
                return batchAlipayResponse;
            }
            String[] responseArray = batchAlipayResponse.getResponseBody().split(BATCH_API_DEFAULT_SPLIT);
            for (int index = 0; index < responseArray.length; ++index) {
                Object alipayResponse = ((AlipayParser)parserList.get(index)).parse(responseArray[index]);
                ((AlipayResponse)alipayResponse).setBody(responseArray[index]);
                batchAlipayResponse.addResponse((AlipayResponse)alipayResponse);
            }
            AlipayLogger.logBizDebug((String)rt.get("rsp"));
            return batchAlipayResponse;
        }
        catch (RuntimeException e) {
            AlipayLogger.logBizError((String)rt.get("rsp"), costTimeMap);
            throw e;
        }
        catch (AlipayApiException e) {
            AlipayLogger.logBizError((String)rt.get("rsp"), costTimeMap);
            throw new AlipayApiException(e);
        }
    }

    private Map<String, Object> doPost(BatchAlipayRequest request) throws AlipayApiException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        RequestParametersHolder requestHolder = this.getRequestHolderWithSign(request);
        String url = this.getRequestUrl(requestHolder);
        if (AlipayLogger.isBizDebugEnabled().booleanValue()) {
            AlipayLogger.logBizDebug(this.getRedirectUrl(requestHolder));
        }
        result.put("prepareTime", System.currentTimeMillis());
        String rsp = null;
        try {
            rsp = WebUtils.doPost(url, requestHolder.getApplicationParams(), this.charset, this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
        }
        catch (IOException e) {
            throw new AlipayApiException(e);
        }
        result.put("requestTime", System.currentTimeMillis());
        result.put("rsp", rsp);
        result.put("textParams", requestHolder.getApplicationParams());
        result.put("protocalMustParams", requestHolder.getProtocalMustParams());
        result.put("protocalOptParams", requestHolder.getProtocalOptParams());
        result.put("url", url);
        return result;
    }

    private <T extends AlipayResponse> RequestParametersHolder getRequestHolderWithSign(BatchAlipayRequest request) throws AlipayApiException {
        List<AlipayRequestWrapper> requestList = request.getRequestList();
        if (requestList == null || requestList.isEmpty()) {
            throw new AlipayApiException("40", "client-error:api request list is empty");
        }
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        AlipayHashMap protocalMustParams = new AlipayHashMap();
        protocalMustParams.put("method", request.getApiMethodName());
        protocalMustParams.put("app_id", this.appId);
        protocalMustParams.put("sign_type", this.signType);
        protocalMustParams.put("charset", this.charset);
        protocalMustParams.put("version", request.getApiVersion());
        if (request.isNeedEncrypt()) {
            protocalMustParams.put("encrypt_type", this.encryptType);
        }
        AlipayHashMap protocalOptParams = new AlipayHashMap();
        protocalOptParams.put("format", this.format);
        protocalOptParams.put("alipay_sdk", "alipay-sdk-java-4.11.336.DEV");
        requestHolder.setProtocalOptParams(protocalOptParams);
        Long timestamp = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        protocalMustParams.put("timestamp", df.format(new Date(timestamp)));
        requestHolder.setProtocalMustParams(protocalMustParams);
        AlipayHashMap appParams = new AlipayHashMap();
        StringBuilder requestBody = new StringBuilder();
        for (int index = 0; index < requestList.size(); ++index) {
            AlipayRequestWrapper alipayRequestWrapper = requestList.get(index);
            AlipayRequest alipayRequest = alipayRequestWrapper.getAlipayRequest();
            Map<String, String> apiParams = alipayRequest.getTextParams();
            apiParams.put("method", alipayRequest.getApiMethodName());
            apiParams.put("app_auth_token", alipayRequestWrapper.getAppAuthToken());
            apiParams.put("auth_token", alipayRequestWrapper.getAccessToken());
            apiParams.put("target_app_id", alipayRequestWrapper.getTargetAppId());
            apiParams.put("prod_code", alipayRequest.getProdCode());
            apiParams.put("notify_url", alipayRequest.getNotifyUrl());
            apiParams.put("return_url", alipayRequest.getReturnUrl());
            apiParams.put("terminal_info", alipayRequest.getTerminalInfo());
            apiParams.put("terminal_type", alipayRequest.getTerminalType());
            apiParams.put("batch_request_id", String.valueOf(index));
            try {
                if (alipayRequest.getClass().getMethod("getBizContent", new Class[0]) != null && StringUtils.isEmpty((String)appParams.get("biz_content")) && alipayRequest.getBizModel() != null) {
                    apiParams.put("biz_content", new JSONWriter().write(alipayRequest.getBizModel(), true));
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (SecurityException e) {
                AlipayLogger.logBizError(e);
            }
            requestBody.append(new JSONWriter().write(apiParams, false));
            if (index == requestList.size() - 1) continue;
            requestBody.append(BATCH_API_DEFAULT_SPLIT);
        }
        appParams.put("biz_content", requestBody.toString());
        if (request.isNeedEncrypt()) {
            if (StringUtils.isEmpty((String)appParams.get("biz_content"))) {
                throw new AlipayApiException("\u5f53\u524dAPI\u4e0d\u652f\u6301\u52a0\u5bc6\u8bf7\u6c42");
            }
            if (StringUtils.isEmpty(this.encryptType) || this.getEncryptor() == null) {
                throw new AlipayApiException("API\u8bf7\u6c42\u8981\u6c42\u52a0\u5bc6\uff0c\u5219\u5fc5\u987b\u8bbe\u7f6e\u5bc6\u94a5\u7c7b\u578b\u548c\u52a0\u5bc6\u5668");
            }
            String encryptContent = this.getEncryptor().encrypt((String)appParams.get("biz_content"), this.encryptType, this.charset);
            appParams.put("biz_content", encryptContent);
        }
        requestHolder.setApplicationParams(appParams);
        if (!StringUtils.isEmpty(this.signType)) {
            String signContent = AlipaySignature.getSignatureContent(requestHolder);
            protocalMustParams.put("sign", this.getSigner().sign(signContent, this.signType, this.charset));
        } else {
            protocalMustParams.put("sign", "");
        }
        return requestHolder;
    }

    @Override
    public <T extends AlipayResponse> T pageExecute(AlipayRequest<T> request) throws AlipayApiException {
        return this.pageExecute(request, "POST");
    }

    @Override
    public <T extends AlipayResponse> T pageExecute(AlipayRequest<T> request, String httpMethod) throws AlipayApiException {
        RequestParametersHolder requestHolder = this.getRequestHolderWithSign(request, null, null, this.appCertSN, null);
        if (AlipayLogger.isBizDebugEnabled().booleanValue()) {
            AlipayLogger.logBizDebug(this.getRedirectUrl(requestHolder));
        }
        AlipayResponse rsp = null;
        try {
            Class<T> clazz = request.getResponseClass();
            rsp = (AlipayResponse)clazz.newInstance();
        }
        catch (InstantiationException e) {
            AlipayLogger.logBizError(e);
        }
        catch (IllegalAccessException e) {
            AlipayLogger.logBizError(e);
        }
        if ("GET".equalsIgnoreCase(httpMethod)) {
            rsp.setBody(this.getRedirectUrl(requestHolder));
        } else {
            String baseUrl = this.getRequestUrl(requestHolder);
            rsp.setBody(WebUtils.buildForm(baseUrl, requestHolder.getApplicationParams()));
        }
        return (T)rsp;
    }

    @Override
    public <T extends AlipayResponse> T sdkExecute(AlipayRequest<T> request) throws AlipayApiException {
        RequestParametersHolder requestHolder = this.getRequestHolderWithSign(request, null, null, this.appCertSN, null);
        if (AlipayLogger.isBizDebugEnabled().booleanValue()) {
            AlipayLogger.logBizDebug(this.getSdkParams(requestHolder));
        }
        AlipayResponse rsp = null;
        try {
            Class<T> clazz = request.getResponseClass();
            rsp = (AlipayResponse)clazz.newInstance();
        }
        catch (InstantiationException e) {
            AlipayLogger.logBizError(e);
        }
        catch (IllegalAccessException e) {
            AlipayLogger.logBizError(e);
        }
        rsp.setBody(this.getSdkParams(requestHolder));
        return (T)rsp;
    }

    @Override
    public <TR extends AlipayResponse, T extends AlipayRequest<TR>> TR parseAppSyncResult(Map<String, String> result, Class<T> requsetClazz) throws AlipayApiException {
        AlipayResponse tRsp = null;
        String rsp = result.get("result");
        try {
            AlipayRequest request = (AlipayRequest)requsetClazz.newInstance();
            Class responseClazz = request.getResponseClass();
            if (StringUtils.isEmpty(rsp)) {
                tRsp = (AlipayResponse)responseClazz.newInstance();
                tRsp.setCode("20000");
                tRsp.setSubCode("ACQ.SYSTEM_ERROR");
                tRsp.setSubMsg(result.get("memo"));
            } else {
                AlipayParser parser = null;
                parser = "xml".equals(this.format) ? new ObjectXmlParser(responseClazz) : new ObjectJsonParser(responseClazz);
                tRsp = parser.parse(rsp);
                tRsp.setBody(rsp);
                this.checkResponseSign(request, parser, rsp, tRsp.isSuccess());
                if (!tRsp.isSuccess()) {
                    AlipayLogger.logBizError(rsp);
                }
            }
        }
        catch (RuntimeException e) {
            AlipayLogger.logBizError(rsp);
            throw e;
        }
        catch (AlipayApiException e) {
            AlipayLogger.logBizError(rsp);
            throw new AlipayApiException(e);
        }
        catch (InstantiationException e) {
            AlipayLogger.logBizError(rsp);
            throw new AlipayApiException(e);
        }
        catch (IllegalAccessException e) {
            AlipayLogger.logBizError(rsp);
            throw new AlipayApiException(e);
        }
        return (TR)tRsp;
    }

    private <T extends AlipayResponse> RequestParametersHolder getRequestHolderWithSign(AlipayRequest<?> request, String accessToken, String appAuthToken, String appCertSN, String targetAppId) throws AlipayApiException {
        RequestParametersHolder requestHolder = new RequestParametersHolder();
        AlipayHashMap appParams = new AlipayHashMap((Map<? extends String, ? extends String>)request.getTextParams());
        try {
            if (request.getClass().getMethod("getBizContent", new Class[0]) != null && StringUtils.isEmpty((String)appParams.get("biz_content")) && request.getBizModel() != null) {
                appParams.put("biz_content", new JSONWriter().write(request.getBizModel(), true));
            }
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (SecurityException e) {
            AlipayLogger.logBizError(e);
        }
        if (request.isNeedEncrypt()) {
            if (StringUtils.isEmpty((String)appParams.get("biz_content"))) {
                throw new AlipayApiException("\u5f53\u524dAPI\u4e0d\u652f\u6301\u52a0\u5bc6\u8bf7\u6c42");
            }
            if (StringUtils.isEmpty(this.encryptType) || this.getEncryptor() == null) {
                throw new AlipayApiException("API\u8bf7\u6c42\u8981\u6c42\u52a0\u5bc6\uff0c\u5219\u5fc5\u987b\u8bbe\u7f6e\u5bc6\u94a5\u7c7b\u578b\u548c\u52a0\u5bc6\u5668");
            }
            String encryptContent = this.getEncryptor().encrypt((String)appParams.get("biz_content"), this.encryptType, this.charset);
            appParams.put("biz_content", encryptContent);
        }
        if (!StringUtils.isEmpty(appAuthToken)) {
            appParams.put("app_auth_token", appAuthToken);
        }
        requestHolder.setApplicationParams(appParams);
        if (StringUtils.isEmpty(this.charset)) {
            this.charset = "UTF-8";
        }
        AlipayHashMap protocalMustParams = new AlipayHashMap();
        protocalMustParams.put("method", request.getApiMethodName());
        protocalMustParams.put("version", request.getApiVersion());
        protocalMustParams.put("app_id", this.appId);
        protocalMustParams.put("sign_type", this.signType);
        protocalMustParams.put("terminal_type", request.getTerminalType());
        protocalMustParams.put("terminal_info", request.getTerminalInfo());
        protocalMustParams.put("notify_url", request.getNotifyUrl());
        protocalMustParams.put("return_url", request.getReturnUrl());
        protocalMustParams.put("charset", this.charset);
        if (!StringUtils.isEmpty(targetAppId)) {
            protocalMustParams.put("target_app_id", targetAppId);
        }
        if (request.isNeedEncrypt()) {
            protocalMustParams.put("encrypt_type", this.encryptType);
        }
        if (!StringUtils.isEmpty(appCertSN)) {
            protocalMustParams.put("app_cert_sn", appCertSN);
        }
        if (!StringUtils.isEmpty(this.alipayRootCertSN)) {
            protocalMustParams.put("alipay_root_cert_sn", this.alipayRootCertSN);
        }
        if (!StringUtils.isEmpty(this.alipayRootSm2CertSN)) {
            protocalMustParams.put("alipay_root_cert_sn", this.alipayRootSm2CertSN);
        }
        Long timestamp = System.currentTimeMillis();
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        df.setTimeZone(TimeZone.getTimeZone("GMT+8"));
        protocalMustParams.put("timestamp", df.format(new Date(timestamp)));
        requestHolder.setProtocalMustParams(protocalMustParams);
        AlipayHashMap protocalOptParams = new AlipayHashMap();
        protocalOptParams.put("format", this.format);
        protocalOptParams.put("auth_token", accessToken);
        protocalOptParams.put("alipay_sdk", "alipay-sdk-java-4.11.336.DEV");
        protocalOptParams.put("prod_code", request.getProdCode());
        requestHolder.setProtocalOptParams(protocalOptParams);
        if (!StringUtils.isEmpty(this.signType)) {
            String signContent = AlipaySignature.getSignatureContent(requestHolder);
            protocalMustParams.put("sign", this.getSigner().sign(signContent, this.signType, this.charset));
        } else {
            protocalMustParams.put("sign", "");
        }
        return requestHolder;
    }

    private String getRequestUrl(RequestParametersHolder requestHolder) throws AlipayApiException {
        StringBuilder urlSb = new StringBuilder(this.serverUrl);
        try {
            String sysMustQuery = WebUtils.buildQuery(this.loadTest ? LoadTestUtil.getParamsWithLoadTestFlag(requestHolder.getProtocalMustParams()) : requestHolder.getProtocalMustParams(), this.charset);
            String sysOptQuery = WebUtils.buildQuery(requestHolder.getProtocalOptParams(), this.charset);
            urlSb.append("?");
            urlSb.append(sysMustQuery);
            if (sysOptQuery != null && sysOptQuery.length() > 0) {
                urlSb.append("&");
                urlSb.append(sysOptQuery);
            }
        }
        catch (IOException e) {
            throw new AlipayApiException(e);
        }
        return urlSb.toString();
    }

    private String getRedirectUrl(RequestParametersHolder requestHolder) throws AlipayApiException {
        StringBuilder urlSb = new StringBuilder(this.serverUrl);
        try {
            Map<String, String> sortedMap = AlipaySignature.getSortedMap(requestHolder);
            String sortedQuery = WebUtils.buildQuery(this.loadTest ? LoadTestUtil.getParamsWithLoadTestFlag(sortedMap) : sortedMap, this.charset);
            urlSb.append("?");
            urlSb.append(sortedQuery);
        }
        catch (IOException e) {
            throw new AlipayApiException(e);
        }
        return urlSb.toString();
    }

    private String getSdkParams(RequestParametersHolder requestHolder) throws AlipayApiException {
        StringBuilder urlSb = new StringBuilder();
        try {
            Map<String, String> sortedMap = AlipaySignature.getSortedMap(requestHolder);
            String sortedQuery = WebUtils.buildQuery(this.loadTest ? LoadTestUtil.getParamsWithLoadTestFlag(sortedMap) : sortedMap, this.charset);
            urlSb.append(sortedQuery);
        }
        catch (IOException e) {
            throw new AlipayApiException(e);
        }
        return urlSb.toString();
    }

    private <T extends AlipayResponse> T _execute(AlipayRequest<T> request, AlipayParser<T> parser, String authToken, String appAuthToken, String targetAppId) throws AlipayApiException {
        long beginTime = System.currentTimeMillis();
        Map<String, Object> rt = this.doPost(request, authToken, appAuthToken, null, targetAppId);
        if (rt == null) {
            return null;
        }
        HashMap<String, Long> costTimeMap = new HashMap<String, Long>();
        if (rt.containsKey("prepareTime")) {
            costTimeMap.put("prepareCostTime", (Long)rt.get("prepareTime") - beginTime);
            if (rt.containsKey("requestTime")) {
                costTimeMap.put("requestCostTime", (Long)rt.get("requestTime") - (Long)rt.get("prepareTime"));
            }
        }
        AlipayResponse tRsp = null;
        try {
            ResponseEncryptItem responseItem = this.decryptResponse(request, rt, parser);
            tRsp = (AlipayResponse)parser.parse(responseItem.getRealContent());
            tRsp.setBody(responseItem.getRealContent());
            this.checkResponseSign(request, parser, responseItem.getRespContent(), tRsp.isSuccess());
            if (costTimeMap.containsKey("requestCostTime")) {
                costTimeMap.put("postCostTime", System.currentTimeMillis() - (Long)rt.get("requestTime"));
            }
        }
        catch (RuntimeException e) {
            AlipayLogger.logBizError((String)rt.get("rsp"), costTimeMap);
            throw e;
        }
        catch (AlipayApiException e) {
            AlipayLogger.logBizError((String)rt.get("rsp"), costTimeMap);
            throw new AlipayApiException(e);
        }
        tRsp.setParams((AlipayHashMap)rt.get("textParams"));
        if (!tRsp.isSuccess()) {
            AlipayLogger.logErrorScene(rt, tRsp, "", costTimeMap);
        } else {
            AlipayLogger.logBizSummary(rt, tRsp, costTimeMap);
        }
        return (T)tRsp;
    }

    private <T extends AlipayResponse> Map<String, Object> doPost(AlipayRequest<T> request, String accessToken, String appAuthToken, String appCertSN, String targetAppId) throws AlipayApiException {
        HashMap<String, Object> result = new HashMap<String, Object>();
        RequestParametersHolder requestHolder = this.getRequestHolderWithSign(request, accessToken, appAuthToken, appCertSN, targetAppId);
        String url = this.getRequestUrl(requestHolder);
        if (AlipayLogger.isBizDebugEnabled().booleanValue()) {
            AlipayLogger.logBizDebug(this.getRedirectUrl(requestHolder));
        }
        result.put("prepareTime", System.currentTimeMillis());
        String rsp = null;
        try {
            if (request instanceof AlipayUploadRequest) {
                AlipayUploadRequest uRequest = (AlipayUploadRequest)request;
                Map<String, FileItem> fileParams = AlipayUtils.cleanupMap(uRequest.getFileParams());
                rsp = WebUtils.doPost(url, requestHolder.getApplicationParams(), fileParams, this.charset, this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
            } else {
                rsp = WebUtils.doPost(url, requestHolder.getApplicationParams(), this.charset, this.connectTimeout, this.readTimeout, this.proxyHost, this.proxyPort);
            }
        }
        catch (SSLException e) {
            if (e.getMessage().contains("the trustAnchors parameter must be non-empty") || e.getMessage().contains("PKIX path building failed")) {
                throw new AlipayApiException("SDK\u5df2\u9ed8\u8ba4\u5f00\u542fSSL\u670d\u52a1\u7aef\u8bc1\u4e66\u6821\u9a8c\uff0c\u8bf7\u786e\u8ba4\u672c\u5730JRE\u9ed8\u8ba4\u81ea\u5e26\u7684CA\u8bc1\u4e66\u5e93\u662f\u5426\u6b63\u786e\uff08JRE\u4e3b\u76ee\u5f55\u4e0b\u7684lib/security/cacerts\u662f\u5426\u5b58\u5728\u3002" + e.getMessage(), e);
            }
            throw new AlipayApiException(e);
        }
        catch (IOException e) {
            throw new AlipayApiException(e);
        }
        result.put("requestTime", System.currentTimeMillis());
        result.put("rsp", rsp);
        result.put("textParams", requestHolder.getApplicationParams());
        result.put("protocalMustParams", requestHolder.getProtocalMustParams());
        result.put("protocalOptParams", requestHolder.getProtocalOptParams());
        result.put("url", url);
        return result;
    }

    private <T extends AlipayResponse> void checkResponseSign(AlipayRequest<T> request, AlipayParser<T> parser, String responseBody, boolean responseIsSucess) throws AlipayApiException {
        if (this.getSignChecker() != null) {
            boolean rsaCheckContent;
            SignItem signItem = parser.getSignItem(request, responseBody);
            if (signItem == null) {
                throw new AlipayApiException("sign check fail: Body is Empty!");
            }
            if ((responseIsSucess || !responseIsSucess && !StringUtils.isEmpty(signItem.getSign())) && !(rsaCheckContent = this.getSignChecker().check(signItem.getSignSourceDate(), signItem.getSign(), this.signType, this.charset))) {
                if (!StringUtils.isEmpty(signItem.getSignSourceDate()) && signItem.getSignSourceDate().contains("\\/")) {
                    String srouceData = signItem.getSignSourceDate().replace("\\/", "/");
                    boolean jsonCheck = this.getSignChecker().check(srouceData, signItem.getSign(), this.signType, this.charset);
                    if (!jsonCheck) {
                        throw new AlipayApiException("sign check fail: check Sign and Data Fail\uff01JSON also\uff01");
                    }
                } else {
                    throw new AlipayApiException("sign check fail: check Sign and Data Fail!");
                }
            }
        }
    }

    private <T extends AlipayResponse> ResponseEncryptItem decryptResponse(AlipayRequest<T> request, Map<String, Object> rt, AlipayParser<T> parser) throws AlipayApiException {
        String responseBody = (String)rt.get("rsp");
        String realBody = null;
        realBody = request.isNeedEncrypt() ? parser.decryptSourceData(request, responseBody, this.format, this.getDecryptor(), this.encryptType, this.charset) : (String)rt.get("rsp");
        return new ResponseEncryptItem(responseBody, realBody);
    }

    void setServerUrl(String serverUrl) {
        this.serverUrl = serverUrl;
    }

    void setAppId(String appId) {
        this.appId = appId;
    }

    void setProdCode(String prodCode) {
        this.prodCode = prodCode;
    }

    void setFormat(String format) {
        this.format = format;
    }

    void setSignType(String signType) {
        this.signType = signType;
    }

    void setEncryptType(String encryptType) {
        this.encryptType = encryptType;
    }

    void setCharset(String charset) {
        this.charset = charset;
    }

    public void setConnectTimeout(int connectTimeout) {
        this.connectTimeout = connectTimeout;
    }

    public void setReadTimeout(int readTimeout) {
        this.readTimeout = readTimeout;
    }

    void setProxyHost(String proxyHost) {
        this.proxyHost = proxyHost;
    }

    void setProxyPort(int proxyPort) {
        this.proxyPort = proxyPort;
    }

    void setCert(X509Certificate cert) {
        this.cert = cert;
    }

    void setAlipayPublicCertMap(ConcurrentHashMap<String, X509Certificate> alipayPublicCertMap) {
        this.alipayPublicCertMap = alipayPublicCertMap;
    }

    public abstract Signer getSigner();

    public abstract SignChecker getSignChecker();

    public abstract Encryptor getEncryptor();

    public abstract Decryptor getDecryptor();

    static {
        Security.setProperty("jdk.certpath.disabledAlgorithms", "");
    }
}

