package com.fshows.ysepay.request.terminal;

import com.fshows.ysepay.request.YsepayBizRequest;

import com.fshows.ysepay.request.income.YsepayIncomeBizRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 终端报备查询请求对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayTerminalReportSearchRequest extends YsepayIncomeBizRequest {
    
    private static final long serialVersionUID = 9222460222277539901L;
    /**
     * 渠道编号
     * 必填: 与corpSrc互斥，两者必填一个
     */
    private String channelCode;

    /**
     * 商户号
     * 必填: 与corpSrc互斥，两者必填一个
     */
    private String mercId;

    /**
     * 终端编号
     * 必填: 与corpSrc互斥，两者必填一个
     */
    private String terminalNo;

    /**
     * 第三方商户号
     * 该参数与上面3个参数(mercId,channelCode,terminalNo)互斥，两组参数必填一个
     * 如果都填写了，会优先以corpSrc为查询条件
     */
    private String corpSrc;
    
} 