package com.fshows.ysepay.response.income;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.ysepay.enums.merchant.YsePayMerchantResponseCodeEnum;
import lombok.Data;

/**
 * 银盛支付基础响应类
 */
@Data
public class YsepayIncomeBizResponse implements IResponseDefinition {
	/**
	 * 业务报文（解密）
	 * 仅当网关响应结果为成功时返回
	 */
	private IResponseDefinition decryptBusinessContext;

	/**
	 * 响应代码
	 * 字节长度: String
	 * 必填: 是
	 */
	private String code;

	/**
	 * 响应代码描述
	 * 字节长度: String
	 * 必填: 是
	 */
	private String msg;

	/**
	 * 错误码
	 * 字节长度: String(50)
	 * 必填: 否
	 */
	private String subCode;

	/**
	 * 错误码描述
	 * 字节长度: String
	 * 必填: 否
	 */
	private String subMsg;
	/*
	 * 响应时间，格式"yyyy-MM-dd HH:mm:ss"
	 */
	private String timeStamp;
	/*
	 * 随机参数
	 */
	private String norce;
	/*
	 * 响应参数的签名串，详见demo,
	 * 注意：请用银盛公钥进行验签
	 */
	private String sign;
	/*
	 * 业务响应参数集合,
	 * 注意：银盛网关通过AES加密业务响应参数集合，得到businessData，商户需要对其进行解密，详情请见demo
	 */
	private String businessData;
	/**
	 * 网关响应结果是否成功
	 */
	public boolean isSuccess() {
		return YsePayMerchantResponseCodeEnum.SUCCESS.getCode().equals(this.getCode());
	}
}