package com.fshows.ysepay.model.income;

import lombok.Data;

import javax.validation.constraints.Size;

/**
 * 法人信息
 * @author mengqf
 */
@Data
public class UpdateCrpInfo {
	
	/**
	 * 法人证件号
	 * 字节长度: String(30)
	 * 必填: 是
	 */
	@Size(max = 30)
	private String crpCertNo;

	/**
	 * 证件有效期
	 * 格式yyyyMMdd，如果为长期或者永久，请填值"29991231"
	 * 字节长度: String(8)
	 * 必填: 是
	 */
	@Size(min = 8, max = 8)
	private String certExpire;

	/**
	 * 法人姓名
	 * 字节长度: String(20)
	 * 必填: 是
	 */
	@Size(max = 20)
	private String crpNm;
	
	/**
	 * 法人手机号
	 * 字节长度: String(11)
	 * 必填: 是
	 */
	@Size(max = 11)
	private String crpPhone;
}