package com.fshows.ysepay.model.income;

import lombok.Data;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

/**
 * 营业信息
 */
@Data
public class BusInfo {

    /**
     * 营业执照号
     * 非小微必填
     * 字节长度: String(50)
     * 必填: 否
     */
    @Size(max = 50)
    private String busNo;

    /**
     * 营业执照名称/商户名称
     * 字节长度: String(50)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 50)
    private String busNm;

    /**
     * 营业执照有效开始日期
     * 非小微必填 格式为yyyyMMdd
     * 字节长度: String(8)
     * 必填: 否
     */
    @Size(min = 8, max = 8)
    private String busCertBgn;

    /**
     * 营业执照有效期
     * 非小微必填 格式为yyyyMMdd
     * 字节长度: String(8)
     * 必填: 否
     */
    @Size(min = 8, max = 8)
    private String busCertExpire;

    /**
     * 营业归属省代码
     * 字节长度: String(4)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 4)
    private String busProviceCode;

    /**
     * 营业归属市代码
     * 字节长度: String(4)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 4)
    private String busCityCode;

    /**
     * 营业归属区(县)代码
     * 字节长度: String(4)
     * 必填: 否
     */
    @Size(max = 4)
    private String busAreaCode;

    /**
     * 营业执照证件类型
     * 非小微商户必填
     * 字节长度: String
     * 必填: 否
     */
    private String busCertType;

    /**
     * 营业详细地址
     * 需包含省市区
     * 字节长度: String
     * 必填: 是
     */
    @NotBlank
    private String busAddr;

    /**
     * 注册地址
     * 默认营业地址一致
     * 字节长度: String
     * 必填: 否
     */
    private String regAddr;
} 