/**
 * fshows.com
 * Copyright (C) 2013-2025 All Rights Reserved.
 */
package com.fshows.ysepay.model.income;

import lombok.Data;

import javax.validation.constraints.Size;

@Data
public class BnfInfo {
	/**
	 * 受益人姓名
	 * 字节长度: String(50)
	 * 必填: 否
	 */
	@Size(max = 50)
	private String name;
	
	/**
	 * 受益人证件类型
	 * 暂时只支持 00 身份证
	 * 字节长度: String(2)
	 * 必填: 否
	 */
	@Size(max = 2)
	private String certType;
	
	/**
	 * 受益人证件号
	 * 字节长度: String(50)
	 * 必填: 否
	 */
	@Size(max = 50)
	private String certNo;
	
	/**
	 * 受益人开始日期
	 * 格式：YYYYMMDD
	 * 字节长度: String(8)
	 * 必填: 否
	 */
	@Size(min = 8, max = 8)
	private String certBgn;
	
	/**
	 * 受益人证件有效期
	 * 格式：YYYYMMDD
	 * 字节长度: String(8)
	 * 必填: 否
	 */
	@Size(min = 8, max = 8)
	private String certExpire;
	
	/**
	 * 受益人地址
	 * 字节长度: String(100)
	 * 必填: 否
	 */
	@Size(max = 100)
	private String addr;
}