/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ysepay;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.fshows.sdk.core.client.base.AbstractApiClient;
import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import com.fshows.sdk.core.client.base.definition.IRequestDefinition;
import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import com.fshows.sdk.core.client.base.handler.IHttpRequestHandler;
import com.fshows.sdk.core.client.base.model.ApiRequestModel;
import com.fshows.sdk.core.client.base.model.ApiResponseModel;
import com.fshows.sdk.core.client.base.model.ClientInfoModel;
import com.fshows.sdk.core.client.base.model.DefaultClientConfigModel;
import com.fshows.sdk.core.client.base.model.DefaultRequestContext;
import com.fshows.sdk.core.client.component.http.FromHttpRequestHandler;
import com.fshows.sdk.core.client.component.http.PostHttpRequestHandler;
import com.fshows.sdk.core.exception.FsApiException;
import com.fshows.sdk.core.util.LogUtil;
import com.fshows.ysepay.YsepayIncomeClientConfigModel;
import com.fshows.ysepay.apienum.YsepayIncomeApiDefinitionEnum;
import com.fshows.ysepay.request.income.YsepayIncomeBizRequest;
import com.fshows.ysepay.response.income.YsepayIncomeBizResponse;
import com.fshows.ysepay.util.AESUtil;
import com.fshows.ysepay.util.ByteUtil;
import com.fshows.ysepay.util.CertUtil;
import com.fshows.ysepay.util.YsepaySignatureUtil;
import java.io.IOException;
import java.lang.reflect.Field;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class YsepayIncomeApiClient
extends AbstractApiClient<YsepayIncomeBizRequest, YsepayIncomeBizResponse, YsepayIncomeApiDefinitionEnum> {
    private static final Logger log = LoggerFactory.getLogger(YsepayIncomeApiClient.class);
    private PublicKey publicKey;
    private PrivateKey privateKey;
    protected IHttpRequestHandler httpRequestHandler = new PostHttpRequestHandler();
    protected IHttpRequestHandler fromHttpRequestHandler = new FromHttpRequestHandler();
    private static final String ALLCHAR = "0123456789ABCDEF";

    public YsepayIncomeApiClient(YsepayIncomeClientConfigModel apiClientConfig) throws Exception {
        super((DefaultClientConfigModel)apiClientConfig);
        this.publicKey = CertUtil.getValidateCert(apiClientConfig.getYsepayPublicKeyPath()).getPublicKey();
        this.privateKey = YsepaySignatureUtil.getPrivateKey(apiClientConfig.getPrivateKeyPath());
    }

    public YsepayIncomeBizResponse execute(YsepayIncomeBizRequest request, YsepayIncomeApiDefinitionEnum apiDefinition) throws FsApiException {
        return (YsepayIncomeBizResponse)this.doExecute(request, apiDefinition);
    }

    public YsepayIncomeBizResponse execute(YsepayIncomeBizRequest request, YsepayIncomeApiDefinitionEnum apiDefinition, DefaultClientConfigModel configModel) throws FsApiException {
        return this.doExecute(request, apiDefinition, configModel);
    }

    protected YsepayIncomeBizResponse doExecute(YsepayIncomeBizRequest request, YsepayIncomeApiDefinitionEnum iApiDefinition, DefaultClientConfigModel customConfig) throws FsApiException {
        long beginTime = System.currentTimeMillis();
        LogUtil.info((Logger)log, (String)"{} >> \u6267\u884c\u8bf7\u6c42\u5f00\u59cb >> iApiDefinition={}, request={}", (Object[])new Object[]{this.getClientInfo().getClientDesc(), iApiDefinition, request});
        DefaultRequestContext requestContext = this.buildRequestContext(iApiDefinition, request, customConfig);
        ApiRequestModel apiRequestModel = null;
        ApiResponseModel apiResponseModel = null;
        try {
            this.checkParam(request, requestContext);
            apiRequestModel = this.buildApiRequestModel(request, requestContext);
            long reqBeginTime = System.currentTimeMillis();
            apiResponseModel = this.httpRequest(apiRequestModel, requestContext);
            long reqEndTime = System.currentTimeMillis();
            YsepayIncomeBizResponse response = this.buildApiResponse(apiResponseModel, apiRequestModel, requestContext);
            LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u7ed3\u675f[\u660e\u6587] >> url={}, method={}, request={}, response={}, totalcost={}ms, reqcost={}ms", (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel.getApiURL(), requestContext.getIApiDefinition(), JSONObject.toJSONString((Object)apiRequestModel.getRequest()), JSONObject.toJSONString((Object)apiResponseModel), System.currentTimeMillis() - beginTime, reqEndTime - reqBeginTime});
            return response;
        }
        catch (FsApiException e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u4e1a\u52a1\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, request, apiRequestModel, apiResponseModel});
            throw e;
        }
        catch (Exception e) {
            LogUtil.error((Logger)log, (String)"{} >> \u8bf7\u6c42\u672a\u77e5\u5f02\u5e38 >> apiDefinition={}, bizRequest={}, apiRequestModel={}, apiResponseModel={}", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), iApiDefinition, request, apiRequestModel, apiResponseModel});
            LogUtil.info((Logger)log, (String)"{} >> \u8bf7\u6c42\u672a\u77e5\u5f02\u5e38[\u660e\u6587] >> url={}, method={}, request={}, cost={}ms", (Throwable)e, (Object[])new Object[]{requestContext.getClientInfoModel().getClientDesc(), apiRequestModel == null ? "" : apiRequestModel.getApiURL(), requestContext.getIApiDefinition(), JSONObject.toJSONString((Object)(apiRequestModel == null ? "" : apiRequestModel.getRequest())), System.currentTimeMillis() - beginTime});
            throw new FsApiException(e.getMessage(), (Throwable)e);
        }
    }

    protected DefaultRequestContext buildRequestContext(YsepayIncomeApiDefinitionEnum incomeApiDefinitionEnum, YsepayIncomeBizRequest request, DefaultClientConfigModel customConfig) {
        DefaultRequestContext context = new DefaultRequestContext();
        context.setIApiDefinition((IApiDefinition)incomeApiDefinitionEnum);
        YsepayIncomeClientConfigModel clientConfig = (YsepayIncomeClientConfigModel)this.apiClientConfig;
        YsepayIncomeClientConfigModel config = new YsepayIncomeClientConfigModel();
        if (StringUtils.isBlank((CharSequence)request.getCertId())) {
            request.setCertId(clientConfig.getCertId());
        }
        config.setCertId(request.getCertId());
        config.setApiParentURL(clientConfig.getApiParentURL());
        config.setCharset(clientConfig.getCharset());
        config.setSignType(clientConfig.getSignType());
        config.setPrivateKeyPath(clientConfig.getPrivateKeyPath());
        config.setYsepayPublicKeyPath(clientConfig.getYsepayPublicKeyPath());
        context.setApiClientConfig((DefaultClientConfigModel)config);
        context.setClientInfoModel(this.getClientInfo());
        return context;
    }

    protected ApiRequestModel buildApiRequestModel(YsepayIncomeBizRequest request, DefaultRequestContext context) {
        YsepayIncomeClientConfigModel configModel = (YsepayIncomeClientConfigModel)context.getApiClientConfig();
        ApiRequestModel apiRequestModel = new ApiRequestModel();
        YsepayIncomeApiDefinitionEnum iApiDefinition = (YsepayIncomeApiDefinitionEnum)context.getIApiDefinition();
        apiRequestModel.setApiURL(context.getApiClientConfig().getApiParentURL() + iApiDefinition.getApiURI());
        apiRequestModel.setContentType("application/json");
        HashMap<String, String> reqMap = new HashMap<String, String>();
        reqMap.put("method", iApiDefinition.getMethod());
        reqMap.put("timeStamp", YsepayIncomeApiClient.getCurrentDateTime("yyyy-MM-dd HH:mm:dd"));
        reqMap.put("charset", "utf-8");
        reqMap.put("reqId", String.valueOf(System.currentTimeMillis()));
        reqMap.put("certId", request.getCertId());
        reqMap.put("version", iApiDefinition.getVersion());
        StringBuilder sb = new StringBuilder();
        Random random = new Random();
        for (int i = 0; i < 16; ++i) {
            sb.append(ALLCHAR.charAt(random.nextInt(ALLCHAR.length())));
        }
        String key = ByteUtil.toHexString(sb.toString());
        HashMap<String, String> paramMap = new HashMap<String, String>();
        paramMap.put("key", key);
        byte[] byte1 = null;
        try {
            byte1 = YsepaySignatureUtil.encrypt(this.publicKey, ByteUtil.hexStringToBytes(key));
        }
        catch (Exception e) {
            throw new FsApiException("YsepayIncomeApiClient --\u300b\u4f7f\u7528\u94f6\u76db\u516c\u94a5\u5bf9\u5bc6\u94a5key\u8fdb\u884c\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
        }
        String encryptKeyCheck = Base64.encodeBase64String((byte[])byte1);
        reqMap.put("check", encryptKeyCheck);
        byte[] bte = null;
        try {
            bte = AESUtil.encrypt(JSONObject.toJSONBytes((Object)request, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.WriteNullStringAsEmpty}), ByteUtil.hexStringToBytes(key));
        }
        catch (Exception e) {
            throw new FsApiException("YsepayIncomeApiClient --\u300b\u4f7f\u7528\u751f\u6210\u7684\u5bc6\u94a5key\u5bf9\u4e1a\u52a1\u53c2\u6570\u8fdb\u884c\u52a0\u5bc6\u5f02\u5e38", (Throwable)e);
        }
        String msgBizContent = Base64.encodeBase64String((byte[])bte);
        reqMap.put("bizContent", msgBizContent);
        ArrayList keys = new ArrayList(reqMap.keySet());
        Collections.sort(keys);
        StringBuilder sb1 = new StringBuilder();
        for (String k : keys) {
            if ("sign".equals(k)) continue;
            sb1.append(k).append("=");
            sb1.append((String)reqMap.get(k));
            sb1.append("&");
        }
        if (sb1.length() > 0) {
            sb1.setLength(sb1.length() - 1);
        }
        String sign = "";
        try {
            sign = YsepaySignatureUtil.signWithRsa256(sb1.toString(), this.privateKey);
        }
        catch (Exception e) {
            throw new FsApiException("YsepayIncomeApiClient --\u300b\u751f\u6210\u7b7e\u540d\u5f02\u5e38", (Throwable)e);
        }
        reqMap.put("sign", sign);
        apiRequestModel.setRequestBody(JSONObject.toJSONString(reqMap));
        apiRequestModel.setRequest((IRequestDefinition)request);
        apiRequestModel.setParamMap(paramMap);
        return apiRequestModel;
    }

    private Map<String, Object> buildBizParams(YsepayIncomeBizRequest request) {
        Field[] fields;
        HashMap<String, Object> bizParams = new HashMap<String, Object>();
        for (Field field : fields = request.getClass().getDeclaredFields()) {
            try {
                field.setAccessible(true);
                Object value = field.get(request);
                if (value == null || "serialVersionUID".equals(field.getName())) continue;
                String paramName = this.camelToUnderline(field.getName());
                bizParams.put(paramName, value);
            }
            catch (IllegalAccessException e) {
                log.error("\u6784\u5efa\u4e1a\u52a1\u53c2\u6570\u5f02\u5e38", (Throwable)e);
            }
        }
        return bizParams;
    }

    private String camelToUnderline(String camelStr) {
        if (StringUtils.isEmpty((CharSequence)camelStr)) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < camelStr.length(); ++i) {
            char c = camelStr.charAt(i);
            if (Character.isUpperCase(c)) {
                if (i > 0) {
                    sb.append("_");
                }
                sb.append(Character.toLowerCase(c));
                continue;
            }
            sb.append(c);
        }
        return sb.toString();
    }

    protected ClientInfoModel getClientInfo() {
        ClientInfoModel clientInfoModel = new ClientInfoModel();
        clientInfoModel.setClientName("\u94f6\u76db\u652f\u4ed8");
        clientInfoModel.setClientCode("ysepay-sdk");
        return clientInfoModel;
    }

    protected YsepayIncomeBizResponse buildApiResponse(ApiResponseModel apiResponseModel, ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) {
        try {
            String result = apiResponseModel.getResponseBody();
            byte[] res = Base64.decodeBase64((String)result);
            Map resMap = (Map)JSONObject.parse((String)new String(res, "UTF-8"));
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)resMap.get("sign")))) {
                byte[] srcData = YsepaySignatureUtil.getSignDataStr1(resMap).getBytes("UTF-8");
                boolean validateSignResult = YsepaySignatureUtil.validateSignBySoft(this.publicKey, Base64.decodeBase64((String)((String)resMap.get("sign"))), srcData);
                if (!validateSignResult) {
                    LogUtil.error((Logger)log, (String)"\u9a8c\u7b7e\u5931\u8d25,\u53ef\u80fd\u662f\u94f6\u76db\u672a\u914d\u7f6e\u53d1\u8d77\u65b9\u6216\u8005\u53d1\u8d77\u65b9\u8bc1\u4e66\u7c7b\u578b\u914d\u7f6e\u6709\u8bef,\u8fd4\u56de\u7ed3\u679c\u63d0\u793a\u4e3a:{}", (Object[])new Object[]{resMap.get("msg")});
                    throw new FsApiException("\u9a8c\u7b7e\u5931\u8d25,\u53ef\u80fd\u662f\u94f6\u76db\u672a\u914d\u7f6e\u53d1\u8d77\u65b9\u6216\u8005\u53d1\u8d77\u65b9\u8bc1\u4e66\u7c7b\u578b\u914d\u7f6e\u6709\u8bef,\u8fd4\u56de\u7ed3\u679c\u63d0\u793a\u4e3a:" + (String)resMap.get("msg"));
                }
            } else {
                throw new FsApiException("\u9a8c\u7b7e\u5931\u8d25,\u672a\u8fd4\u56de\u52a0\u7b7e\u4fe1\u606f,\u53ef\u80fd\u662f\u94f6\u76db\u672a\u914d\u7f6e\u53d1\u8d77\u65b9\u6216\u8005\u53d1\u8d77\u65b9\u8bc1\u4e66\u7c7b\u578b\u914d\u7f6e\u6709\u8bef,\u8fd4\u56de\u7ed3\u679c\u63d0\u793a\u4e3a:" + (String)resMap.get("msg"));
            }
            String key = apiRequestModel.getParamMap().get("key").toString();
            YsepayIncomeBizResponse baseResponse = (YsepayIncomeBizResponse)JSONObject.parseObject((String)JSONObject.toJSONString((Object)resMap), YsepayIncomeBizResponse.class);
            if (StringUtils.isNotBlank((CharSequence)((CharSequence)resMap.get("businessData")))) {
                byte[] data_ = Base64.decodeBase64((String)((String)resMap.get("businessData")));
                byte[] data = AESUtil.decrypt(data_, ByteUtil.hexStringToBytes(key));
                String stringBody = new String(data, "UTF-8");
                baseResponse.setBusinessData(stringBody);
                LogUtil.info((Logger)log, (String)"\u89e3\u5bc6\u540e\u7684\u4e1a\u52a1\u53c2\u6570:{}", (Object[])new Object[]{stringBody});
                IResponseDefinition iResponseDefinition = (IResponseDefinition)JSON.parseObject((String)stringBody, (Class)requestContext.getIApiDefinition().getResponseClass());
                baseResponse.setDecryptBusinessContext(iResponseDefinition);
            }
            return baseResponse;
        }
        catch (Exception e) {
            throw new FsApiException("\u89e3\u6790\u54cd\u5e94\u5931\u8d25", (Throwable)e);
        }
    }

    protected ApiResponseModel httpRequest(ApiRequestModel apiRequestModel, DefaultRequestContext requestContext) throws IOException {
        YsepayIncomeApiDefinitionEnum iApiDefinition = (YsepayIncomeApiDefinitionEnum)requestContext.getIApiDefinition();
        if ("multipart/form-data".equalsIgnoreCase(iApiDefinition.getContentType())) {
            return this.fromHttpRequestHandler.httpRequest(apiRequestModel, requestContext);
        }
        return this.httpRequestHandler.httpRequest(apiRequestModel, requestContext);
    }

    private static String getCurrentDateTime(String pattern) {
        SimpleDateFormat sdf = new SimpleDateFormat(pattern);
        return sdf.format(new Date());
    }
}

