package com.fshows.ysepay.request.report;

import com.fshows.ysepay.constant.TerminalConstant;
import com.fshows.ysepay.request.YsepayBizRequest;
import com.fshows.ysepay.request.income.YsepayIncomeBizRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;
import javax.validation.constraints.NotBlank;

/**
 * 新增授权目录请求对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayAuthPathAddRequest extends YsepayIncomeBizRequest {
    
    private static final long serialVersionUID = 3211211871004017531L;
    /**
     * 商户号
     * 由银盛支付生成并下发
     * 必填: 是
     */
    @NotBlank(message = "商户号不能为空")
    private String mercId;

    /**
     * 交易报备渠道编号
     * CUPS_WECHAT-银联微信
     * NUCC_WECHAT-网联微信
     * 必填: 是
     */
    @NotBlank(message = "渠道编号不能为空")
    private String channelId;

    /**
     * 微信公众号添加配置支付授权目录
     * 必填: 是
     */
    @NotBlank(message = "支付授权目录不能为空")
    private String payAuthPath;
    
} 