package com.fshows.ysepay.request.income;

import com.fshows.ysepay.model.income.BaseInfo;
import com.fshows.ysepay.model.income.FeeInfo;
import com.fshows.ysepay.model.income.UpdateStlAccInfo;
import lombok.Data;
import lombok.EqualsAndHashCode;

import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

/**
 * 商户资料变更请求对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayChangeMercInfoRequest extends YsepayIncomeBizRequest {
    
    private static final long serialVersionUID = -1251039897302557422L;
    /**
     * 客户号id
     * 字节长度: String(20)
     */
    @Size(max = 20)
    private String custId;

    /**
     * 商户号
     * 字节长度: String(20)
     */
    @Size(max = 20)
    private String mercId;

    /**
     * 变更申请单类型
     * 1 纸质 2电子 默认1
     * 字节长度: String(2)
     */
    @Size(max = 2)
    private String contractType;

    /**
     * 业务方变更申请流水号
     * 字节长度: String(32)
     */
    @Size(max = 32)
    private String changeThirdFlowId;

    /**
     * 异步通知地址
     * 字节长度: String(100)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 100)
    private String notifyUrl;

    /**
     * 商户基本信息
     */
    private BaseInfo baseInfoAO;

    /**
     * 结算信息变更
     */
    private UpdateStlAccInfo stlAccInfo;

    /**
     * 商户费率信息
     */
    private FeeInfo feeInfoAO;
} 