package com.fshows.ysepay.request;

import java.math.BigDecimal;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 银盛支付宝C扫B支付请求对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayAlipayJsapiPayRequest extends YsepayBizRequest {

    /**
     * 商户系统生成的订单号
     * 须保证在商户端不重复，生成规则前8位必须为交易日期，如20220525
     * 范围跨度支持包含当天在内的前后一天
     * 且只能由大小写英文字母、数字、下划线及横杠组成
     * 字节长度: String(1,32)
     * 必填: 是
     * 示例值: 202205256843192280647118
     */
    private String outTradeNo;

    /**
     * 商户系统的交易发生日期
     * 格式yyyyMMdd
     * 字节长度: String(8,8)
     * 必填: 否
     * 示例值: 20180525
     */
    private String shopdate;

    /**
     * 订单备注
     * 字节长度: String(1,250)
     * 必填: 是
     */
    private String subject;

    /**
     * 订单金额
     * 该笔订单的资金总额，单位为RMB-Yuan
     * 取值范围为[0.01，100000000.00]，精确到小数点后两位
     * Number(10,2)指10位长度，2位精度
     * 字节长度: Number(10,2)
     * 必填: 是
     * 示例值: 100
     */
    private BigDecimal totalAmount;

    /**
     * 币种
     * 字节长度: String(3)
     * 必填: 否
     * 默认CNY（人民币）
     */
    private String currency = "CNY";

    /**
     * 收款商户号
     * 字节长度: String(1,20)
     * 必填: 是
     */
    private String sellerId;

    /**
     * 收款商户号对应商户名称
     * 字节长度: String(1,50)
     * 必填: 否
     */
    private String sellerName;

    /**
     * 超时时间
     * 设置未付款交易的超时时间，一旦超时，该笔交易就会自动被关闭
     * 取值范围：1m～15d。m-分钟，h-小时，d-天
     * 该参数数值不接受小数点，如1.5h，可转换为90m
     * 字节长度: String(2,6)
     * 必填: 是
     * 示例值: 96h
     */
    private String timeoutExpress;

    /**
     * 业务扩展参数
     * 一个json字符串
     * order_mode订单模式，暂时可选的值为:00 代表购物车模式
     * seller_list参与分账的收款方信息数组，每个元素包含seller_id收款方银盛支付用户号
     * 实时分账业务，order_mode和seller_list均不能为空，order_mode的值必须为00
     * 字节长度: String(500)
     * 必填: 否
     */
    private String extendParams;

    /**
     * 公用回传参数
     * 字节长度: String(2000)
     * 必填: 否
     */
    private String extraCommonParam;

    /**
     * 业务代码
     * 请联系银盛客户经理获取
     * 注意：业务代码非固定值，不同到账方式需要传不同的业务代码
     * 字节长度: String(1,10)
     * 必填: 是
     */
    private String businessCode;

    /**
     * 买家支付宝用户ID
     * 和buyer_logon_id不能同时为空
     * 通过网页授权获取用户信息，同步响应结果中的user_id对应文档中的buyer_id
     * 字节长度: String(100)
     * 必填: 否
     */
    private String buyerId;

    /**
     * 二级商户信息
     * Json格式
     * 如果有值则二级商户信息都不能为空，如果没值则都不能有值
     * 必填: 否
     */
    private SubMerchantInfo subMerchant;

    /**
     * 收货人信息
     * Json格式
     * 必填: 否
     */
    private ConsigneeInfo consigneeInfo;

    /**
     * 是否限制信用卡支付
     * 值为1表示禁用信用卡，0或为空表示不限制,2禁用花呗，3禁用花呗分期，4禁用所有信用支付类型
     * 字节长度: String(2)
     * 必填: 否
     */
    private String limitCreditPay;

    /**
     * 花呗分期期数
     * 仅在支付宝支付的时候生效,目前期数支持3,6,12
     * 字节长度: String(2)
     * 必填: 否
     */
    private String hbFqNum;

    /**
     * 分期类型
     * 值为00表示花呗分期,值01表示信用卡分期。不填默认为花呗分期
     * 字节长度: String(2)
     * 必填: 否
     */
    private String fqType;

    /**
     * 是否允许多次支付
     * Y：允许;N：不允许
     * 参数为空或者Y时，默认该笔订单交易状态非成功状态时，支持选择其他支付方式继续付款
     * 当为N时表示该笔订单交易状态为失败状态时，不支持选择其他支付方式继续付款
     * 字节长度: String(2)
     * 必填: 否
     */
    private String allowRepeatPay;

    /**
     * 失败通知地址
     * 交易状态为失败时，银盛支付服务器主动通知商户网站里指定的页面http路径
     * 支持多个url进行异步通知，多个url用分隔符","分开，格式如：url1,url2,url3
     * 注：只有不允许重复支付的交易才会通知
     * 字节长度: String(190)
     * 必填: 否
     */
    private String failNotifyUrl;

    /**
     * 支付宝营销单品详情列表
     * 必填: 否
     */
    private List<AliGoodsDetail> aliGoodsDetails;

    /**
     * 子商户ip
     * 字节长度: String(16)
     * 必填: 否
     * 示例值: 112.112.112.112
     */
    private String submerIp;

    /**
     * 商户门店编号
     * 字节长度: String(32)
     * 必填: 否
     */
    private String storeId;

    /**
     * 支付宝的店铺编号
     * 字节长度: String(32)
     * 必填: 否
     */
    private String alipayStoreId;

    /**
     * 商户操作员编号
     * 字节长度: String(28)
     * 必填: 否
     */
    private String operatorId;

    /**
     * 商户机具终端编号
     * 字节长度: String(32)
     * 必填: 否
     */
    private String terminalId;

    /**
     * 支付宝花呗分期专属字段
     * 字节长度: String
     * 必填: 否
     */
    private String businessParams;

    /**
     * 银联259号文条码改造字段
     * json格式
     * 必填: 否
     */
    private UnionQrCodeBaseRequest unionQrcode259Params;

    /**
     * 实名认证信息
     * 有证件类型、证件姓名、证件号，非必填
     * 如果三个字段一个填写就都必填，要么就都不上送
     * 必填: 否
     */
    private BuyerRealnameInfo buyerRealnameInfo;

    /**
     * 付款方gps信息
     * 必填: 否
     */
    private GpsInformation gps;

    /**
     * 付款方ip
     * 字节长度: String
     * 必填: 否
     */
    private String payerIp;

    /**
     * 支付宝业务拓展参数json格式
     * 字节长度: String
     * 必填: 否
     */
    private String extendParamsChannel;

    /**
     * 商户自主营销信息
     * json格式
     * coupon_id优惠券id、marketing_source_id营销来源id
     * 示例值：{"coupon_id": "231", "marketing_source_id": "23232"}
     * 字节长度: String
     * 必填: 否
     */
    private String merchantMarketingInfo;

    /**
     * 二级商户信息
     */
    @Data
    public static class SubMerchantInfo {
        /**
         * 二级商户名称
         * 支持25个中文
         * 字节长度: String(50)
         * 必填: 否
         */
        private String merName;

        /**
         * 二级商户简称
         * 支持25个中文
         * 字节长度: String(50)
         * 必填: 否
         */
        private String merShortName;

        /**
         * 二级商户地址
         * 支持100个中文
         * 字节长度: String(200)
         * 必填: 否
         */
        private String merAddr;

        /**
         * 固定电话/手机号码二选一
         * 字节长度: String(13)
         * 必填: 否
         */
        private String telephone;

        /**
         * 二级商户编号
         * 字节长度: String(32)
         * 必填: 否
         */
        private String merNo;

        /**
         * 类目
         * 按附件内容输入类目编号
         * 字节长度: String(20)
         * 必填: 否
         */
        private String category;

        /**
         * 身份证号
         * 只支持身份证格式
         * 如果签名方式为RSA，则用DES加密，密钥为商户号前8位，不足8位在商户号前补空格
         * 如果签名方式为SM，则用SM加密
         * 字节长度: String(15,18)
         * 必填: 否
         */
        private String mrchntCertId;
    }

    /**
     * 收货人信息
     */
    @Data
    public static class ConsigneeInfo {
        /**
         * 收货人姓名
         * 字节长度: String(150)
         * 必填: 否
         */
        private String consigneeName;

        /**
         * 收货地址
         * 字节长度: String(200)
         * 必填: 否
         */
        private String consigneeAddr;

        /**
         * 物流配送信息（物流名称+订单号）
         * 字节长度: String(200)
         * 必填: 否
         */
        private String transportationInfo;

        /**
         * 商品名称
         * 字节长度: String(150)
         * 必填: 否
         */
        private String commodityName;

        /**
         * 商品数量
         * 字节长度: String(10)
         * 必填: 否
         */
        private String commodityNumber;
    }

    /**
     * 支付宝营销单品详情
     */
    @Data
    public static class AliGoodsDetail {
        /**
         * 商品编号
         * 字节长度: String(32)
         * 必填: 是
         */
        private String goodsId;

        /**
         * 支付宝定义的统一商品编号
         * 字节长度: String(32)
         * 必填: 否
         */
        private String alipayGoodsId;

        /**
         * 营销单品名称
         * 字节长度: String(256)
         * 必填: 是
         */
        private String goodsName;

        /**
         * 营销单品数量
         * 不超过10位的正整数
         * 字节长度: String(10)
         * 必填: 是
         */
        private String quantity;

        /**
         * 营销单品单价
         * [0,999999999] 左闭右闭区间，小数点后最多允许两位
         * 字节长度: String(12)
         * 必填: 是
         */
        private String price;

        /**
         * 营销单品类目
         * 字节长度: String(24)
         * 必填: 否
         */
        private String goodsCategory;

        /**
         * 营销单品类目树
         * 字节长度: String(128)
         * 必填: 否
         */
        private String categoriesTree;

        /**
         * 营销单品描述
         * 字节长度: String(1000)
         * 必填: 否
         */
        private String body;

        /**
         * 营销单品展示地址
         * 字节长度: String(400)
         * 必填: 否
         */
        private String showUrl;
    }

    /**
     * 银联259号文条码改造字段
     */
    @Data
    public static class UnionQrCodeBaseRequest {
        /**
         * 终端号
         * 收单机构为商户终端分配的唯一编号
         * 字节长度: String(8)
         * 必填: 是
         */
        private String terminalNo;

        /**
         * 终端类型（线下交易场景必填）
         * 01 自动柜员机（含 ATM 和 CDM）和多媒体自助终端
         * 02 传统 POS
         * 03 mPOS
         * 04 智能 POS
         * 05 II 型固定电话
         * 06 云闪付终端
         * 07 保留使用
         * 08 手机 POS
         * 09 刷脸付终端
         * 10 条码支付受理终端
         * 11 辅助受理终端
         * 12 行业终端（公交、地铁用于指定行业的终端）
         * 13 MIS 终端
         * 字节长度: String(2)
         * 必填: 是
         */
        private String terminalType;

        /**
         * 终端序列号
         * 备注：终端类型为 02;03;04;05;06;08;09或10时,必须填写终端序列号
         * 字节长度: String(50)
         * 必填: 否
         */
        private String serialNum;

        /**
         * 银行卡受理终端产品入网认证编号
         * 备注：终端类型为 02;03;04;05;06;08;09或10时,终端设备如果有相关参数,建议填写
         * 字节长度: String(5)
         * 必填: 否
         */
        private String networkLicense;

        /**
         * 终端应用程序的版本号
         * 备注：终端类型为 02;03;04;05;06;08;09或10时,建议填写
         * 终端应用程序的版本号,应用程序变更应保证版本号不重复
         * 字节长度: String(5)
         * 必填: 否
         */
        private String appVersion;

        /**
         * 交易设备位置信息
         * 格式:纬度/经度,东经为正数，西经为负数;北纬为正数，南纬为负数
         * 线下交易场景、terminal_ip和terminal_gps 二者选其一 必填
         * 字节长度: String(32)
         * 必填: 否
         */
        private String terminalGps;

        /**
         * 商户端终端设备 IP 地址
         * 注：如经、维度信息未上送，该字段必送
         * 字节长度: String(64)
         * 必填: 否
         */
        private String terminalIp;

        /**
         * 加密随机因子
         * 字节长度: String(10)
         * 必填: 否
         */
        private String encrypRandNum;

        /**
         * 密文数据
         * 字节长度: String(16)
         * 必填: 否
         */
        private String secretText;
    }

    /**
     * 实名认证信息
     */
    @Data
    public static class BuyerRealnameInfo {
        /**
         * 证件号
         * 只支持身份证格式
         * 如果签名方式为RSA，则用DES加密，密钥为商户号前8位，不足8位在商户号前补空格
         * 如果签名方式为SM，则用SM加密
         * 字节长度: String
         * 必填: 是
         */
        private String idNo;

        /**
         * 证件类型
         * 只支持身份证，枚举值：1
         * 字节长度: String
         * 必填: 是
         */
        private String idType;

        /**
         * 证件姓名
         * 字节长度: String
         * 必填: 是
         */
        private String idName;
    }

    /**
     * 付款方GPS信息
     */
    @Data
    public static class GpsInformation {
        /**
         * 纬度
         * 范围-90~90
         * 字节长度: Double
         * 必填: 否
         */
        private Double latitude;

        /**
         * 经度
         * 范围-180~180
         * 字节长度: Double
         * 必填: 否
         */
        private Double longitude;
    }
} 