/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ysepay.util;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

public class MerchantSerialNumberGenerator {
    private static final String PREFIX = "fs";
    private static final String ALLOWED_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_-";
    private static final int DATE_LENGTH = 12;
    private static final int MIN_LENGTH = 14;
    private static final int MAX_LENGTH = 32;
    private static final Random RANDOM = new Random();

    public static String generateSerialNumber() {
        String datePart = MerchantSerialNumberGenerator.getCurrentDateTimePart();
        int remainingLength = Math.max(14, 32) - PREFIX.length() - 12;
        if (remainingLength < 0) {
            throw new IllegalArgumentException("\u751f\u6210\u7684\u6d41\u6c34\u53f7\u957f\u5ea6\u4e0d\u7b26\u5408\u8981\u6c42");
        }
        StringBuilder randomPart = new StringBuilder();
        for (int i = 0; i < remainingLength; ++i) {
            int randomIndex = RANDOM.nextInt(ALLOWED_CHARS.length());
            randomPart.append(ALLOWED_CHARS.charAt(randomIndex));
        }
        return PREFIX + randomPart + datePart;
    }

    private static String getCurrentDateTimePart() {
        SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
        return sdf.format(new Date());
    }

    public static void main(String[] args) {
        System.out.println(MerchantSerialNumberGenerator.generateSerialNumber());
    }
}

