package com.fshows.ysepay.model.income;

import lombok.Data;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.Size;

/**
 * 结算信息
 */
@Data
public class StlAccInfo {

    /**
     * 是否平台内账户
     * Y是 N否，默认否
     * 字节长度: String(1)
     * 必填: 否
     */
    @Size(max = 1)
    private String isSettInPlatAcc;

    /**
     * 是否非同名结算
     * Y:非同名结算（备用结算账户信息必传） N:同名结算,默认 N:同名结算
     * 字节长度: String(1)
     * 必填: 否
     */
    @Size(max = 1)
    private String isUncrpSett;

    /**
     * 结算户名
     * 默认法人姓名, 非同名结算必填
     * 字节长度: String(20)
     * 必填: 否
     */
    @Size(max = 20)
    private String stlAccNm;

    /**
     * 结算账号
     * 字节长度: String(30)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 30)
    private String stlAccNo;

    /**
     * 开户支行联行号
     * 字节长度: String(20)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 20)
    private String bankSubCode;

    /**
     * 结算账户类型
     * 11 对私 21 对公 23 对公存折 24 单位结算卡
     * 字节长度: String(2)
     * 必填: 是
     */
    @NotBlank
    @Size(max = 2)
    private String stlAccType;

    /**
     * 银行预留手机号
     * 非同名结算必填
     * 字节长度: String(11)
     * 必填: 否
     */
    @Size(max = 11)
    private String bankMobile;

    /**
     * 开户证件号
     * 默认法人证件号,非同名结算必填
     * 字节长度: String(20)
     * 必填: 否
     */
    @Size(max = 20)
    private String openCertNo;

    /**
     * 银行开户行所属省代码
     * 字节长度: String
     * 必填: 否
     */
    private String bankProince;

    /**
     * 银行开户行所属市代码
     * 字节长度: String
     * 必填: 否
     */
    private String bankCity;

    // 备用结算账户信息
    /**
     * 备用结算账户类型
     * 11 对私 21 对公 23 对公存折 24 单位结算卡
     * 字节长度: String(2)
     * 必填: 否
     */
    @Size(max = 2)
    private String standByStlAccType;

    /**
     * 备用结算账号
     * 字节长度: String(30)
     * 必填: 否
     */
    @Size(max = 30)
    private String standByStlAccNo;

    /**
     * 备用结算户名
     * 字节长度: String(20)
     * 必填: 否
     */
    @Size(max = 20)
    private String standByStlAccNm;

    /**
     * 备用结算账户开户行支行编号
     * 字节长度: String(20)
     * 必填: 否
     */
    @Size(max = 20)
    private String standByBankSubCode;

    /**
     * 备用结算账户银行开户行省代码
     * 字节长度: String(10)
     * 必填: 否
     */
    @Size(max = 10)
    private String standByBankProvince;

    /**
     * 备用结算账户银行开户行市代码
     * 字节长度: String(10)
     * 必填: 否
     */
    @Size(max = 10)
    private String standByBankCity;
} 