package com.fshows.ysepay.request.income;

import javax.validation.constraints.NotNull;

import com.fshows.ysepay.model.income.FileMeta;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 商户资料文件上传请求对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayIncomeFileUploadRequest extends YsepayIncomeBizRequest {
    
    private static final long serialVersionUID = -1498813294010758708L;
    /**
     * 图片文件
     * 将媒体图片进行二进制转换的内容
     * 必填: 是
     * // 示例代码
     * File file = new File("path/to/image.jpg");
     * byte[] fileContent = Files.readAllBytes(file.toPath());
     * request.setFile(fileContent);
     */
    @NotNull
    private byte[] file;  // 使用byte[]来接收文件的二进制内容

    /**
     * 媒体文件元信息
     * 必填: 是
     */
    @NotNull
    private FileMeta meta;
} 