/*
 * Decompiled with CFR 0.152.
 */
package com.fshows.ysepay.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import java.util.Enumeration;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class CertUtil {
    private static KeyStore keyStore = null;
    private static Certificate validateCert = null;
    private static final String KEYSTORE_TYPE = "PKCS12";
    private static final String CERTFACTORY_TYPE = "X.509";

    public static KeyStore initSignCert(String pfxPath, String pfxPwd) throws Exception {
        if (null != keyStore) {
            keyStore = null;
        }
        try {
            keyStore = CertUtil.getKeyInfo(pfxPath, pfxPwd, KEYSTORE_TYPE);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw e;
        }
        return keyStore;
    }

    public static KeyStore getKeyInfo(String pfxkeyfile, String keypwd, String type) throws Exception {
        FileInputStream fis = null;
        try {
            KeyStore ks = null;
            ks = KeyStore.getInstance(type);
            fis = new FileInputStream(pfxkeyfile);
            char[] nPassword = null;
            char[] cArray = nPassword = null == keypwd || "".equals(keypwd.trim()) ? null : keypwd.toCharArray();
            if (null != ks) {
                ks.load(fis, nPassword);
            }
            KeyStore keyStore = ks;
            return keyStore;
        }
        catch (Exception e) {
            throw e;
        }
        finally {
            if (null != fis) {
                fis.close();
            }
        }
    }

    public static PrivateKey getSignCertPrivateKey(String pfxPath, String pfxPwd) throws Exception {
        if (keyStore == null) {
            keyStore = CertUtil.initSignCert(pfxPath, pfxPwd);
        }
        Enumeration<String> aliasenum = keyStore.aliases();
        String keyAlias = null;
        if (aliasenum.hasMoreElements()) {
            keyAlias = aliasenum.nextElement();
        }
        PrivateKey privateKey = (PrivateKey)keyStore.getKey(keyAlias, pfxPwd.toCharArray());
        return privateKey;
    }

    public static Certificate initValidateCertFromDir(String crtPath) throws Exception {
        CertificateFactory cf = null;
        FileInputStream in = null;
        try {
            cf = CertificateFactory.getInstance(CERTFACTORY_TYPE);
            in = new FileInputStream(crtPath);
            validateCert = cf.generateCertificate(in);
        }
        catch (CertificateException e) {
            throw e;
        }
        catch (FileNotFoundException e) {
            throw e;
        }
        finally {
            if (null != in) {
                in.close();
            }
        }
        return validateCert;
    }

    public static Certificate getValidateCert(String crtPath) throws Exception {
        System.out.println("Cert starts loading...[certPath is:" + crtPath + "]");
        if (validateCert != null) {
            System.out.println("cert is already exists,don't need to load it");
            return validateCert;
        }
        return CertUtil.initValidateCertFromDir(crtPath);
    }

    public static PublicKey getPubKeyObj(String pubKey) throws Exception {
        X509EncodedKeySpec bobPubKeySpec = new X509EncodedKeySpec(new BASE64Decoder().decodeBuffer(pubKey));
        KeyFactory keyFactory = KeyFactory.getInstance("RSA");
        PublicKey publicKey = keyFactory.generatePublic(bobPubKeySpec);
        return publicKey;
    }

    public static PrivateKey getPriKeyObj(String priKeyStr) throws Exception {
        PrivateKey privateKey = null;
        PKCS8EncodedKeySpec priPKCS8 = new PKCS8EncodedKeySpec(new BASE64Decoder().decodeBuffer(priKeyStr));
        KeyFactory keyf = KeyFactory.getInstance("RSA");
        privateKey = keyf.generatePrivate(priPKCS8);
        return privateKey;
    }

    public static String getPrivateKeyInfo(String privKeyFilePath, String privKeyPswd) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KEYSTORE_TYPE);
        FileInputStream fileInputStream = new FileInputStream(privKeyFilePath);
        char[] nPassword = null;
        nPassword = privKeyPswd == null || privKeyPswd.trim().equals("") ? null : privKeyPswd.toCharArray();
        keyStore.load(fileInputStream, nPassword);
        fileInputStream.close();
        Enumeration<String> enumeration = keyStore.aliases();
        String keyAlias = "";
        if (enumeration.hasMoreElements()) {
            keyAlias = enumeration.nextElement();
        }
        PrivateKey prikey = (PrivateKey)keyStore.getKey(keyAlias, nPassword);
        return new BASE64Encoder().encode(prikey.getEncoded());
    }

    public static String getPublicKeyInfo(String publicKeyPath) throws Exception {
        CertificateFactory cf = CertificateFactory.getInstance(CERTFACTORY_TYPE);
        X509Certificate cert = (X509Certificate)cf.generateCertificate(new FileInputStream(publicKeyPath));
        PublicKey publicKey = cert.getPublicKey();
        return new BASE64Encoder().encode(publicKey.getEncoded());
    }
}

