package com.fshows.ysepay.response;

import java.math.BigDecimal;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 银盛支付宝C扫B支付响应对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayAlipayJsapiPayResponse extends YsepayBizResponse {

    /**
     * 商户系统生成的订单号
     * 字节长度: String(32)
     * 必填: 是
     * 示例值: 2018012500001
     */
    private String outTradeNo;

    /**
     * 银盛支付交易流水号
     * 字节长度: String(30)
     * 必填: 否
     */
    private String tradeNo;

    /**
     * 交易状态
     * 成功的值: TRADE_SUCCESS
     * 字节长度: String
     * 必填: 是
     */
    private String tradeStatus;

    /**
     * 订单金额
     * 该笔订单的资金总额，单位为RMB-Yuan
     * 取值范围为[0.01，100000000.00]，精确到小数点后两位
     * 字节长度: Number
     * 必填: 是
     * 示例值: 100
     */
    private BigDecimal totalAmount;

    /**
     * 交易币种
     * 字节长度: String(3)
     * 必填: 否
     * 默认CNY
     */
    private String currency;

    /**
     * 公用回传参数
     * 商户自定义数据域，原样返回
     * 字节长度: String
     * 必填: 否
     */
    private String extraCommonParam;

    /**
     * Json格式字符串，作用于原生态的js支付时的参数
     * 字节长度: String
     * 必填: 是
     */
    private String jsapiPayInfo;

    /**
     * 发往渠道流水号
     * 字节长度: String(50)
     * 必填: 否
     */
    private String channelSendSn;

    /**
     * 渠道返回流水号
     * 字节长度: String(50)
     * 必填: 否
     */
    private String channelRecvSn;

    /**
     * 支付网关编号
     * 字节长度: String(16)
     * 必填: 否
     */
    private String paygateNo;

    /**
     * 卡类型
     * credit:信用卡
     * debit:借记卡
     * 字节长度: String
     * 必填: 否
     */
    private String cardType;

    /**
     * 支付宝用户Uid
     * 字节长度: String
     * 必填: 否
     */
    private String buyerUserId;

    /**
     * 支付宝账户
     * 字节长度: String
     * 必填: 否
     */
    private String buyerLogonId;

    /**
     * 支付宝优惠信息
     * 版本号3.5及以上支持
     * 字节长度: String
     * 必填: 否
     */
    private String alipayTrxRespCouponInfo;

    /**
     * 支付宝商家优惠金额
     * 版本号3.5及以上支持
     * 字节长度: String
     * 必填: 否
     */
    private String aliMerchantAmount;

    /**
     * 支付宝平台优惠金额
     * 版本号3.5及以上支持
     * 字节长度: String
     * 必填: 否
     */
    private String aliPlatformDisAmount;

    /**
     * 支付宝营销单品信息
     * ListJSON字符串
     * 版本3.5及以上支持
     * 字节长度: String
     * 必填: 否
     */
    private String aliGoodsDetails;

    /**
     * 营销优惠金额
     * 版本3.9及以上支持
     * 字节长度: Number
     * 必填: 否
     * 示例值: 1.2
     */
    private BigDecimal preferentialAmount;

    /**
     * 营销优惠手续费
     * 版本3.9及以上支持
     * 字节长度: Number
     * 必填: 否
     * 示例值: 0.02
     */
    private BigDecimal preferentialFee;

    /**
     * 营销规则信息json
     * 版本3.9及以上支持
     * 字节长度: String
     * 必填: 否
     */
    private String marketingRuleJson;

    /**
     * 支付宝营销单品信息
     */
    @Data
    public static class GoodsDetail {
        /**
         * 记录编号，唯一标识
         * 字节长度: String(64)
         * 必填: 是
         */
        private String id;

        /**
         * 银盛交易流水
         * 字节长度: String(30)
         * 必填: 是
         */
        private String tradesn;

        /**
         * 银盛交易流水序列号
         * 字节长度: Integer(4)
         * 必填: 是
         */
        private Integer seq;

        /**
         * 记录创建时间
         * 必填: 是
         */
        private String createtime;

        /**
         * 渠道单品标识
         * 字节长度: String(32)
         * 必填: 否
         */
        private String wxpayGoodsId;

        /**
         * 营销单品名称
         * 字节长度: String(256)
         * 必填: 否
         */
        private String goodsName;

        /**
         * 营销单品标识
         * 字节长度: String(32)
         * 必填: 是
         */
        private String goodsId;

        /**
         * 营销单品备注
         * 字节长度: String(256)
         * 必填: 否
         */
        private String goodsRemark;

        /**
         * 营销单品数量
         * 字节长度: NUMBER(10)
         * 必填: 否
         */
        private Integer quantity;

        /**
         * 营销单品价格
         * 字节长度: NUMBER(15,4)
         * 必填: 否
         */
        private BigDecimal price;

        /**
         * 记录类型
         * "WXREQ":微信单品营销请求
         * "WXRESP":微信单品营销渠道响应
         * "ALIREQ":支付宝单品营销请求
         * "ALIRESP":支付宝单品营销渠道响应
         * 字节长度: String(32)
         * 必填: 否
         */
        private String type;

        /**
         * 抵扣金额
         * 字节长度: NUMBER(15,4)
         * 必填: 是
         */
        private BigDecimal discountAmount;

        /**
         * type为WXREQ/ALIREQ请求类型时，为原始传入的单品营销参数JSON字符串
         * type为WXRESP/ALIRESP时为渠道返回的单品营销响应原始信息JSON字符串
         * 字节长度: String(3000)
         * 必填: 否
         */
        private String goodsDetailJson;
    }
} 