package com.fshows.ysepay.request.report;

import javax.validation.constraints.NotBlank;

import com.fshows.ysepay.request.YsepayBizRequest;
import com.fshows.ysepay.request.income.YsepayIncomeBizRequest;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 新增/修改appid请求对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayAppidAddOrUpdateRequest extends YsepayIncomeBizRequest {
    
    private static final long serialVersionUID = -8644126268115943865L;
    /**
     * 交易报备渠道编号
     * 目前只支持微信
     * CUPS_WECHAT-银联微信
     * NUCC_WECHAT-网联微信
     * 必填: 是
     */
    @NotBlank(message = "渠道编号不能为空")
    private String channelId;

    /**
     * 企业商户号
     * 必填: 是
     */
    @NotBlank(message = "商户号不能为空")
    private String mercId;

    /**
     * 公众号appid
     * 公众号appid、小程序appid二者必选一
     */
    private String jsPayRelatedAppId;

    /**
     * 小程序appid
     * 公众号appid、小程序appid二者必选一
     */
    private String appletId;
} 