package com.fshows.ysepay.response;

import com.fshows.sdk.core.client.base.definition.IResponseDefinition;
import lombok.Data;

/**
 * 银盛支付基础响应类
 */
@Data
public class YsepayBaseResponse implements IResponseDefinition {
	/**
	 * 业务报文（解密）
	 * 仅当网关响应结果为成功时返回
	 */
	private IResponseDefinition decryptBusinessContext;

	/**
	 * 响应代码
	 * 字节长度: String
	 * 必填: 是
	 */
	private String code;

	/**
	 * 响应代码描述
	 * 字节长度: String
	 * 必填: 是
	 */
	private String msg;

	/**
	 * 错误码
	 * 字节长度: String(50)
	 * 必填: 否
	 */
	private String subCode;

	/**
	 * 错误码描述
	 * 字节长度: String
	 * 必填: 否
	 */
	private String subMsg;
}