package com.fshows.ysepay.request.income;

import javax.validation.constraints.NotNull;
import javax.validation.constraints.Size;

import com.fshows.ysepay.model.income.StlAccInfo;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 变更结算信息请求对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayChangeMercStlAccInfoRequest extends YsepayIncomeBizRequest {
    
    private static final long serialVersionUID = -8606525900808904044L;
    /**
     * 客户ID
     * custId，mercId二选一，若都传则以商户号为准
     * 字节长度: String(20)
     */
    @Size(max = 20)
    private String custId;

    /**
     * 商户号
     * custId，mercId二选一，若都传则以商户号为准
     */
    private String mercId;

    /**
     * 结算信息变更异步通知url
     * 若为空，取资料上送的异步通知url
     */
    private String notifyUrl;

    /**
     * 结算信息变更
     * 必填: 是
     */
    @NotNull(message = "结算信息不能为空")
    private StlAccInfo stlAccInfo;

    /**
     * 变更申请单类型
     * 1 纸质 2电子 默认1
     * 字节长度: String(2)
     */
    @Size(max = 2)
    private String contractType;

    /**
     * 业务方变更申请流水号
     * 唯一 （变更状态查询接口可通过此字段查询）
     * 字节长度: String(32)
     */
    @Size(max = 32)
    private String changeThirdFlowId;
    
} 