package com.fshows.ysepay.constant;

/**
 * 终端相关常量
 */
public class TerminalConstant {
    
    /**
     * 渠道编号
     */
    public static class ChannelCode {
        /** 银联微信支付 */
        public static final String CUPS_WECHAT = "CUPS_WECHAT";
        /** 银联支付宝 */
        public static final String CUPS_ALIPAY = "CUPS_ALIPAY";
        /** 银联云闪付 */
        public static final String CUPS_POS_SCANPAY = "CUPS_POS_SCANPAY";
        /** 网联终端采集 */
        public static final String NUCC_WECHAT = "NUCC_WECHAT";
    }

    /**
     * 终端操作标识
     */
    public static class OperationType {
        /** 新增 */
        public static final String ADD = "00";
        /** 修改 */
        public static final String MODIFY = "01";
        /** 注销 */
        public static final String CANCEL = "02";
    }

    /**
     * 终端类型
     */
    public static class TerminalType {
        /** 自动柜员机（含ATM和CDM）和多媒体自助终端 */
        public static final String ATM = "01";
        /** 传统POS */
        public static final String TRADITIONAL_POS = "02";
        /** mPOS */
        public static final String MPOS = "03";
        /** 智能POS */
        public static final String SMART_POS = "04";
        /** II型固定电话 */
        public static final String FIXED_PHONE = "05";
        /** 云闪付终端 */
        public static final String CLOUD_PAY = "06";
        /** 保留使用 */
        public static final String RESERVED = "07";
        /** 手机POS */
        public static final String MOBILE_POS = "08";
        /** 刷脸付终端 */
        public static final String FACE_PAY = "09";
        /** 条码支付受理终端 */
        public static final String BARCODE_PAY = "10";
        /** 辅助受理终端 */
        public static final String AUXILIARY = "11";
        /** 行业终端 */
        public static final String INDUSTRY = "12";
        /** MIS终端 */
        public static final String MIS = "13";
    }

    /**
     * 终端报备状态
     */
    public static class ReportState {
        /** 启用 */
        public static final String ENABLE = "00";
        /** 注销 */
        public static final String CANCEL = "99";
    }

    /**
     * 终端定位功能标识
     */
    public static class GpsFlag {
        /** 可定位 */
        public static final String AVAILABLE = "00";
        /** 不可定位 */
        public static final String UNAVAILABLE = "01";
    }
} 