/*
 * 51qbiz.com
 * Copyright (C) 2014-2025 All Rights Reserved.
 */
package com.fshows.ysepay.util;

import lombok.Data;

import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;

/**
 * @author zhouyok * @version MerchantSerialNumberGenerator.java, v 0.1 2025-05-27 上午10:41 zhouyok
 */
public class MerchantSerialNumberGenerator {
	private static final String PREFIX = "fs";
	private static final String ALLOWED_CHARS = "0123456789ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz_-";
	private static final int DATE_LENGTH = 12;
	private static final int MIN_LENGTH = 14;
	private static final int MAX_LENGTH = 32;
	private static final Random RANDOM = new Random();
	
	public static String generateSerialNumber() {
		String datePart = getCurrentDateTimePart();
		int remainingLength = Math.max(MIN_LENGTH, MAX_LENGTH) - PREFIX.length() - DATE_LENGTH;
		
		if (remainingLength < 0) {
			throw new IllegalArgumentException("生成的流水号长度不符合要求");
		}
		
		StringBuilder randomPart = new StringBuilder();
		for (int i = 0; i < remainingLength; i++) {
			int randomIndex = RANDOM.nextInt(ALLOWED_CHARS.length());
			randomPart.append(ALLOWED_CHARS.charAt(randomIndex));
		}
		
		return PREFIX + randomPart + datePart;
	}
	
	private static String getCurrentDateTimePart() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyMMddHHmmss");
		return sdf.format(new Date());
	}
	
	public static void main(String[] args) {
		System.out.println(generateSerialNumber());
	}
}