package com.fshows.ysepay.request.income;

import javax.validation.constraints.NotNull;

import com.fshows.ysepay.model.income.ChangePicMeta;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 变更资料图片上传请求对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayUploadChangePicRequest extends YsepayIncomeBizRequest {
    
    private static final long serialVersionUID = -4623598949795615719L;

    /**
     * 图片文件
     * 将媒体图片进行二进制转换的内容
     * 必填: 是
     * 示例代码:
     * File file = new File("path/to/image.jpg");
     * byte[] fileContent = Files.readAllBytes(file.toPath());
     * request.setFile(fileContent);
     */
    @NotNull(message = "文件内容不能为空")
    private byte[] file;

    /**
     * 媒体文件元信息
     * 必填: 是
     */
    @NotNull(message = "文件元信息不能为空")
    private ChangePicMeta meta;
} 