package com.fshows.ysepay.model.payment;

import lombok.Data;

/**
 * 支付宝资金账单信息
 */
@Data
public class AlipayFundBill {
    
    /**
     * 交易使用的资金渠道
     * 字节长度: String
     * 必填: 是
     * 示例值: ALIPAYACCOUNT
     */
    private String fundChannelStr;

    /**
     * 银行卡支付时的银行代码
     * 字节长度: String
     * 必填: 否
     * 示例值: CEB
     */
    private String bankCode;

    /**
     * 该支付工具类型所使用的金额
     * 字节长度: double
     * 必填: 是
     * 示例值: 10.00
     */
    private Double amount;

    /**
     * 渠道实际付款金额
     * 字节长度: double
     * 必填: 否
     * 示例值: 11.21
     */
    private Double realAmount;

    /**
     * 集分宝支付金额
     * 字节长度: String
     * 必填: 否
     * 示例值: 11.21
     */
    private String fundTypeStr;
} 