package com.fshows.ysepay.constant;

/**
 * 签约相关常量
 */
public class SignConstant {
    
    /**
     * 到账方式
     */
    public static class BusOpenType {
        /** 扫码工作日到账 */
        public static final String CODE_SCAN_T1 = "00";
        /** 扫码实时到账 */
        public static final String CODE_SCAN_D0 = "01";
        /** 刷卡工作日到账 */
        public static final String SWIPE_CARD_T1 = "10";
        /** 刷卡实时到账 */
        public static final String SWIPE_CARD_D0 = "11";
        /** D1到账 */
        public static final String D1 = "20";
        /** 境外卡到账 */
        public static final String OVERSEAS_CARD = "21";
    }

    /**
     * 合同类型
     */
    public static class ContractType {
        /** 纸质合同 */
        public static final String PAPER = "1";
        /** 电子合同 */
        public static final String ELECTRONIC = "2";
    }

    /**
     * 签约通知方式
     */
    public static class NotifyType {
        /** 短信+邮件 */
        public static final String ALL = "0";
        /** 短信 */
        public static final String SMS = "1";
        /** 邮件 */
        public static final String EMAIL = "2";
        /** 不通知 */
        public static final String NONE = "3";
    }

    /**
     * 境外卡费率类型
     */
    public static class OutCardFeeType {
        /** VISA DCC */
        public static final String VISA_DCC = "1";
        /** VISA EDC */
        public static final String VISA_EDC = "2";
        /** 万事达 DCC */
        public static final String MASTERCARD_DCC = "3";
        /** 万事达 EDC */
        public static final String MASTERCARD_EDC = "4";
        /** 大莱 EDC */
        public static final String DINERS_EDC = "6";
        /** JCB DCC */
        public static final String JCB_DCC = "9";
        /** JCB EDC */
        public static final String JCB_EDC = "10";
        /** 连通境外卡 */
        public static final String AMEX = "11";
        /** 银联外卡借记卡费率 */
        public static final String UNIONPAY_DEBIT = "13";
        /** 银联外卡贷记卡费率 */
        public static final String UNIONPAY_CREDIT = "14";
    }

    /**
     * 收费方式
     */
    public static class RateType {
        /** 按百分比 */
        public static final String PERCENTAGE = "0";
        /** 按固定金额 */
        public static final String FIXED = "1";
    }
} 