package com.fshows.ysepay.apienum;

import com.fshows.sdk.core.client.base.definition.IApiDefinition;
import com.fshows.ysepay.request.YsepayAlipayJsapiPayRequest;
import com.fshows.ysepay.request.YsepayBarcodePayRequest;
import com.fshows.ysepay.request.YsepayCupgetmulappUseridRequest;
import com.fshows.ysepay.request.YsepayCupmulappQrcodePayRequest;
import com.fshows.ysepay.request.YsepayTradeCloseRequest;
import com.fshows.ysepay.request.YsepayTradeOrderQueryRequest;
import com.fshows.ysepay.request.YsepayTradeRefundQueryRequest;
import com.fshows.ysepay.request.YsepayTradeRefundRequest;
import com.fshows.ysepay.request.YsepayUnionaccountDownloadUrlGetRequest;
import com.fshows.ysepay.request.YsepayWeixinPayRequest;
import com.fshows.ysepay.response.YsepayAlipayJsapiPayResponse;
import com.fshows.ysepay.response.YsepayBarcodePayResponse;
import com.fshows.ysepay.response.YsepayCupgetmulappUseridResponse;
import com.fshows.ysepay.response.YsepayCupmulappQrcodePayResponse;
import com.fshows.ysepay.response.YsepayTradeCloseResponse;
import com.fshows.ysepay.response.YsepayTradeOrderQueryResponse;
import com.fshows.ysepay.response.YsepayTradeRefundQueryResponse;
import com.fshows.ysepay.response.YsepayTradeRefundResponse;
import com.fshows.ysepay.response.YsepayUnionaccountDownloadUrlGetResponse;
import com.fshows.ysepay.response.YsepayWeixinPayResponse;

import lombok.Getter;

/**
 * 银盛支付API定义枚举
 */
@Getter
public enum YsepayTradeApiDefinitionEnum implements IApiDefinition {

    /**
     * 扫码支付接口
     */
    BARCODE_PAY(
        "条码支付",
        "ysepay.online.barcodepay",
        "3.8",
        "TRADE",
        YsepayBarcodePayRequest.class,
        YsepayBarcodePayResponse.class
    ),

    /**
     * 微信C扫B支付接口
     */
    WEIXIN_PAY(
        "微信C扫B支付",
        "ysepay.online.weixin.pay",
        "3.4",
        "TRADE",
        YsepayWeixinPayRequest.class,
        YsepayWeixinPayResponse.class
    ),
    /**
     * 支付宝C扫B支付接口
     */
    ALIPAY_JSAPI_PAY(
            "支付宝C扫B支付",
            "ysepay.online.alijsapi.pay",
            "3.5",
            "TRADE",
            YsepayAlipayJsapiPayRequest.class,
            YsepayAlipayJsapiPayResponse.class
    ),
    /**
     * 订单及明细查询接口
     */
    TRADE_ORDER_QUERY(
            "订单及明细查询",
            "ysepay.online.trade.order.query",
            "3.0",
            "TRADE",
            YsepayTradeOrderQueryRequest.class,
            YsepayTradeOrderQueryResponse.class
    ),
    /**
     * 订单关闭接口
     */
    TRADE_CLOSE(
            "订单关闭",
            "ysepay.online.trade.close",
            "3.0",
            "TRADE",
            YsepayTradeCloseRequest.class,
            YsepayTradeCloseResponse.class
    ),
    /**
     * 退款接口
     */
    TRADE_REFUND(
            "退款",
            "ysepay.online.trade.refund",
            "3.0",
            "TRADE",
            YsepayTradeRefundRequest.class,
            YsepayTradeRefundResponse.class
    ),
    /**
     * 退款交易查询接口
     */
    TRADE_REFUND_QUERY(
            "退款交易查询",
            "ysepay.online.trade.refund.query",
            "3.0",
            "TRADE",
            YsepayTradeRefundQueryRequest.class,
            YsepayTradeRefundQueryResponse.class
    ),
    /**
     * 对账文件下载接口
     */
    UNIONACCOUNT_DOWNLOADURL_GET(
            "对账文件下载",
            "ysepay.online.unionaccount.downloadurl.get",
            "3.0",
            "TRADE",
            YsepayUnionaccountDownloadUrlGetRequest.class,
            YsepayUnionaccountDownloadUrlGetResponse.class
    ),
    /**
     * 银联行业码支付接口
     */
    CUPMULAPP_QRCODE_PAY(
        "银联行业码支付",
        "ysepay.online.cupmulapp.qrcodepay",
        "3.4",
        "TRADE",
        YsepayCupmulappQrcodePayRequest.class,
        YsepayCupmulappQrcodePayResponse.class
    ),
    
    /**
     * 银联行业码获取用户标识接口
     */
    CUPGETMULAPP_USERID(
            "银联行业码获取用户标识",
            "ysepay.online.cupgetmulapp.userid",
            "3.4",
            "TRADE",
            YsepayCupgetmulappUseridRequest.class,
            YsepayCupgetmulappUseridResponse.class
    ),
    ;
    
    /**
     * 接口名称
     */
    private final String name;
    
    /**
     * 接口URI
     */
    private final String apiURI;
    
    /**
     * 接口版本
     */
    private final String version;
    
    /**
     * 接口类型
     */
    private final String interfaceType;
    
    /**
     * 请求业务参数的Class类型
     */
    private final Class requestClass;
    
    /**
     * 响应业务参数的Class类型
     */
    private final Class responseClass;
    
    YsepayTradeApiDefinitionEnum(String name,
            String apiURI,
            String version,
            String interfaceType,
            Class requestClass,
            Class responseClass) {
        this.name = name;
        this.apiURI = apiURI;
        this.version = version;
        this.interfaceType = interfaceType;
        this.requestClass = requestClass;
        this.responseClass = responseClass;
    }
    @Override
    public String getApiURI() {
        return apiURI;
    }

    @Override
    public String getVersion() {
        return version;
    }

    @Override
    public Class getRequestClass() {
        return requestClass;
    }

    @Override
    public Class getResponseClass() {
        return responseClass;
    }
} 