package com.fshows.ysepay.notify;

import java.math.BigDecimal;
import java.util.List;

import lombok.Data;

/**
 * 银盛退款异步通知对象
 */
@Data
public class YsepayTradeRefundNotify {

    /**
     * 报文签名算法
     * 交易请求时的签名类型RSA/SM
     * 字节长度: String
     * 必填: 是
     */
    private String signType;

    /**
     * 签名字符串，Base64编码
     * 字节长度: String
     * 必填: 是
     */
    private String sign;

    /**
     * 通知类型
     * 固定值：refund.status.sync
     * 字节长度: String
     * 必填: 是
     */
    private String notifyType;

    /**
     * 发送请求的时间
     * 格式"yyyy-MM-dd HH:mm:ss"
     * 字节长度: String(19)
     * 必填: 是
     * 示例值: 2014-07-24 03:07:50
     */
    private String notifyTime;

    /**
     * 商户系统生成的退款订单号，对应的请求参数是out_request_no
     * 字节长度: String(32)
     * 必填: 是
     * 示例值: RD2012061713107
     */
    private String outTradeNo;

    /**
     * 该笔退款订单的资金总额，单位为RMB-Yuan
     * 取值范围为[0.01，100000000.00]，精确到小数点后两位
     * 字节长度: Number
     * 必填: 否
     */
    private BigDecimal totalAmount;

    /**
     * 该交易在银盛支付系统中的交易流水号
     * 字节长度: String(20)
     * 必填: 否
     */
    private String tradeNo;

    /**
     * 交易目前所处的状态
     * 成功状态的示例值: TRADE_SUCCESS
     * 字节长度: String
     * 必填: 是
     */
    private String tradeStatus;

    /**
     * 入账的时间
     * 格式"yyyyMMdd"
     * 字节长度: String(10)
     * 必填: 否
     * 示例值: 20140724
     */
    private String accountDate;

    /**
     * 银联营销渠道响应优惠信息
     * 当原订单的version小于3.6版本的时候，为List的JSON字符串
     * 如果大于等于3.6版本的时候为CouponInfo的JSON字符串
     * 字节长度: String
     * 必填: 否
     */
    private String couponInfo;

    /**
     * 微信优惠信息
     * 原订单的版本号（version）在3.5(包含)及以上支持
     * 字节长度: String
     * 必填: 否
     */
    private String wxpayRefundCouponInfo;

    /**
     * 支付宝优惠信息
     * 原订单的版本号（version）在3.5(包含)及以上支持
     * 字节长度: String
     * 必填: 否
     */
    private String alipayRefundCouponInfo;

    /**
     * 原订单结算金额
     * 字节长度: Number
     * 必填: 否
     * 示例值: 100.00
     */
    private BigDecimal settlementAmount;

    /**
     * 银联优惠信息
     */
    @Data
    public static class CouponInfo {
        /**
         * 清算金额，单位为元
         * 字节长度: Double
         * 必填: 是
         */
        private Double amount;

        /**
         * 订单金额，单位为元,商户提交的订单金额
         * 字节长度: Double
         * 必填: 是
         */
        private Double origAmount;

        /**
         * 优惠信息-二维码
         * 成功的二维码类交易交易必填，活动维度的优惠展示
         * 必填: 否
         */
        private List<CupQrCouponDetail> cupQrCouponDetail;

        /**
         * 付款方附加数据
         * 交易成功返回，商品维度的优惠展示
         * 必填: 否
         */
        private IssAddnData issAddnData;

        /**
         * 优惠信息全渠道
         * 成功的全渠道类交易（如：Wap，手机控件 等）必填,活动维度的优惠展示
         * 必填: 否
         */
        private CupAcpCouponInfo cupAcpCouponInfo;
    }

    /**
     * 银联二维码优惠信息
     */
    @Data
    public static class CupQrCouponDetail {
        /**
         * 出资方
         * 1：银联出资
         * 2：付款方（比如银行）出资
         * 3：商户出资
         * 字节长度: double
         * 必填: 是
         */
        private Double spnsrId;

        /**
         * 出资金额，单位为元
         * 字节长度: double
         * 必填: 是
         */
        private Double offstAmt;
    }

    /**
     * 付款方附加数据
     */
    @Data
    public static class IssAddnData {
        /**
         * 商品优惠信息
         * 交易成功，且请求参数中的收款方附加信息域中的单品命中优惠。商品维度展示优惠信息。
         * 必填: 否
         */
        private List<DctDetail> dctDetail;
    }

    /**
     * 商品优惠信息
     */
    @Data
    public static class DctDetail {
        /**
         * 参与优惠的商品编号
         * 字节长度: String
         * 必填: 是
         */
        private String id;

        /**
         * 优惠活动的编号
         * 字节长度: String
         * 必填: 是
         */
        private String dctId;

        /**
         * 商品优惠数量
         * 本商品数量为10，其中2件参与优惠
         * 字节长度: int
         * 必填: 是
         */
        private Integer dctQuantity;

        /**
         * 商品优惠金额
         * 单位:元
         * 示例：商品单价10元，共5件，其中2件参与优惠，每件优惠3元，则本字段值为6.00
         * 字节长度: double
         * 必填: 是
         */
        private Double dctPrice;

        /**
         * 附加信息，内容自定义
         * 字节长度: String
         * 必填: 否
         */
        private String addnInfo;
    }

    /**
     * 银联全渠道优惠信息
     */
    @Data
    public static class CupAcpCouponInfo {
        /**
         * 总的优惠金额
         * 单位:元
         * 注：退货的时候返回，表示总的优惠回退金额
         * 字节长度: double
         * 必填: 是
         */
        private Double discountAmt;

        /**
         * 商户出资金额
         * 单位:元
         * 注：退货的时候返回，表示商户出资的回退金额
         * 字节长度: double
         * 必填: 否
         */
        private Double mchtDiscountAmt;

        /**
         * 活动编号
         * 票券编号、活动编号等，格式自定义
         * 字节长度: String
         * 必填: 否
         */
        private String activityId;

        /**
         * 活动简称
         * 优惠活动简称，可用于展示、打单等
         * 字节长度: String
         * 必填: 否
         */
        private String activityNm;

        /**
         * 活动打印信息
         * 内容自定义
         * 字节长度: String
         * 必填: 否
         */
        private String addnPrintInfo;
    }

    /**
     * 微信退款优惠信息
     */
    @Data
    public static class WxpayRefundCouponInfo {
        /**
         * 标价币种
         * 字节长度: String
         * 必填: 否
         */
        private String feeType;

        /**
         * 申请退款金额
         * 单位:元
         * 字节长度: double
         * 必填: 否
         */
        private Double refundFee;

        /**
         * 现金退款金额
         * 字节长度: double
         * 必填: 否
         */
        private Double cashRefundFee;

        /**
         * 退款金额
         * 去掉非充值代金券退款金额后的退款金额
         * 退款金额=申请退款金额-非充值代金券退款金额
         * 退款金额<=申请退款金额
         * 字节长度: double
         * 必填: 否
         */
        private Double settlementRefundFee;

        /**
         * 代金券退款总金额
         * 字节长度: double
         * 必填: 否
         */
        private Double couponRefundFee;

        /**
         * 优惠退款详情
         * 必填: 否
         */
        private RefundDetail refundDetail;

        /**
         * 额外的信息
         * 字节长度: String
         * 必填: 否
         */
        private String ext;
    }

    /**
     * 微信退款优惠详情
     */
    @Data
    public static class RefundDetail {
        /**
         * 券ID券或者立减优惠ID
         * 字节长度: String(32)
         * 必填: 是
         * 示例值: 109519
         */
        private String promotionId;

        /**
         * 优惠范围
         * GLOBAL- 全场代金券
         * SINGLE- 单品优惠
         * 字节长度: String(32)
         * 必填: 否
         * 示例值: SINGLE
         */
        private String scope;

        /**
         * 优惠类型
         * COUPON- 代金券，需要走结算资金的充值型代金券（境外商户券币种与支付币种一致）
         * DISCOUNT- 优惠券，不走结算资金的免充值型优惠券（境外商户券币种与标价币种一致）
         * 字节长度: String(32)
         * 必填: 否
         * 示例值: DISCOUNT
         */
        private String type;

        /**
         * 用户享受优惠的金额
         * 优惠券面额=微信出资金额+商家出资金额+其他出资方金额
         * 单位：元
         * 字节长度: double
         * 必填: 是
         * 示例值: 5.00
         */
        private Double amount;

        /**
         * 退款金额
         * 字节长度: double
         * 必填: 否
         */
        private Double refundAmount;
    }

    /**
     * 支付宝退款优惠信息
     */
    @Data
    public static class AlipayRefundCouponInfo {
        /**
         * 申请退款金额
         * 单位:元
         * 字节长度: double
         * 必填: 否
         */
        private Double refundFee;

        /**
         * 本次退款金额
         * 字节长度: double
         * 必填: 否
         */
        private Double refundAmount;

        /**
         * 本次商户实际退回金额
         * 字节长度: double
         * 必填: 否
         */
        private Double sendBackFee;

        /**
         * 退款支付时间
         * 字节长度: String
         * 必填: 否
         */
        private String refundDetail;

        /**
         * 优惠退款详情
         * 字节长度: String
         * 必填: 否
         */
        private String gmtRefundPay;

        /**
         * 额外的信息
         * 字节长度: String
         * 必填: 否
         */
        private String ext;

        /**
         * 本次退款金额中买家退款金额
         * 字节长度: double
         * 必填: 否
         */
        private Double presentRefundBuyerAmount;

        /**
         * 本次退款金额中平台优惠退款金额
         * 字节长度: double
         * 必填: 否
         */
        private Double presentRefundDiscountAmount;

        /**
         * 本次退款金额中商家优惠退款金额
         * 字节长度: double
         * 必填: 否
         */
        private Double presentRefundMdiscountAmount;
    }
} 