package com.fshows.ysepay.response;

import java.math.BigDecimal;
import java.util.List;

import com.fshows.ysepay.model.payment.AlipayCouponInfo;
import com.fshows.ysepay.model.payment.WxpayCouponGoodDetail;
import com.fshows.ysepay.model.payment.WxpayCouponInfo;
import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 银盛订单及明细查询响应对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayTradeOrderQueryResponse extends YsepayBizResponse {

    /**
     * 交易目前所处的状态
     * 成功状态的值: TRADE_SUCCESS、TRADE_CLOSED等
     * 字节长度: String
     * 必填: 是
     */
    private String tradeStatus;

    /**
     * 商户系统内部订单号
     * 字节长度: String(1,32)
     * 必填: 否
     */
    private String outTradeNo;

    /**
     * 该交易在银盛支付系统中的交易流水号
     * 字节长度: String(1,30)
     * 必填: 否
     */
    private String tradeNo;

    /**
     * 金额
     * Number(10,2)指10位长度，2位精度
     * 字节长度: Number(10,2)
     * 必填: 是
     * 示例值: 100.01
     */
    private BigDecimal totalAmount;

    /**
     * 实收金额（参考）
     * 当为快付交易时，该字段为空
     * 字节长度: Number(10,2)
     * 必填: 否
     * 示例值: 2.04
     */
    private BigDecimal receiptAmount;

    /**
     * 入账日期
     * 格式"yyyy-MM-dd"
     * 字节长度: String(10)
     * 必填: 否
     * 示例值: 2014-07-24
     */
    private String accountDate;

    /**
     * 结果描述
     * 当订单失败的时候，返回相关错误描述
     * 字节长度: String
     * 必填: 否
     */
    private String resultNote;

    /**
     * 子商户appid下用户唯一标识
     * 字节长度: String(128)
     * 必填: 否
     */
    private String openid;

    /**
     * 订单支付明细
     * 必填: 否
     */
    private List<PayDetail> payDetailList;

    /**
     * 快付明细
     * 必填: 否
     */
    private List<QuickPayDetail> quickPayDetailList;

    /**
     * 参考结算金额
     * 当为快付交易时，该字段为空
     * 字节长度: Number
     * 必填: 否
     */
    private BigDecimal settlementAmount;

    /**
     * 参考总优惠金额
     * 字节长度: double
     * 必填: 否
     */
    private Double totalDiscount;

    /**
     * 交易扩展状态状态
     * 当为快付交易时，该字段为空
     * 字节长度: String
     * 必填: 否
     */
    private String tradeStatusExt;

    /**
     * 分期响应信息
     * 当为快付交易时，该字段为空
     * 必填: 否
     */
    private InstallmentResp installmentResp;

    /**
     * 商户贴息手续费
     * 字节长度: Double
     * 必填: 否
     */
    private Double merDiscountFee;

    /**
     * 收款方已退手续费
     * 字节长度: Double
     * 必填: 否
     */
    private Double hasRefundPayeeFee;

    /**
     * 付款方已退手续费
     * 字节长度: Double
     * 必填: 否
     */
    private Double hasRefundPayerFee;

    /**
     * 发起方已退手续费
     * 字节长度: Double
     * 必填: 否
     */
    private Double hasRefundSrcFee;

    /**
     * 退款金额
     * 字节长度: Double
     * 必填: 否
     */
    private Double refundAmount;

    /**
     * 公用回传参数
     * 商户自定义数据域，返回订单REMARK数据
     * 字节长度: String(2000)
     * 必填: 否
     */
    private String extraCommonParam;

    /**
     * 收款商户号
     * 字节长度: String(1,20)
     * 必填: 否
     */
    private String sellerId;

    /**
     * 支付明细
     */
    @Data
    public static class PayDetail {
        /**
         * 支付状态
         * 字节长度: String
         * 必填: 是
         * 示例值: TRADE_SUCCESS
         */
        private String status;

        /**
         * 发往渠道的交易时间
         * 格式"yyyy-MM-dd HH:mm:ss"
         * 字节长度: String
         * 必填: 否
         * 示例值: 2019-5-24 09:44:31
         */
        private String sendChannelTime;

        /**
         * 序列号
         * 序列号数值越大则表示此笔交易流水为最新记录
         * 字节长度: Number(1)
         * 必填: 是
         */
        private Integer serialNumber;

        /**
         * 该笔订单的合作方手续费(参考)
         * 单位为RMB-Yuan
         * 取值范围为[0.01，100000000.00]，精确到小数点后两位
         * 当为快付交易时，该字段不能为空
         * 字节长度: String
         * 必填: 否
         */
        private String partnerFee;

        /**
         * 该笔订单的收款方手续费(参考)
         * 单位为RMB-Yuan
         * 取值范围为[0.01，100000000.00]，精确到小数点后两位
         * 当为快付交易时，该字段不能为空
         * 字节长度: String
         * 必填: 否
         */
        private String payeeFee;

        /**
         * 该笔订单的付款方手续费(参考)
         * 单位为RMB-Yuan
         * 取值范围为[0.01，100000000.00]，精确到小数点后两位
         * 当为快付交易时，该字段不能为空
         * 字节长度: String
         * 必填: 否
         */
        private String payerFee;

        /**
         * 发往渠道流水
         * 字节长度: String
         * 必填: 否
         */
        private String channelSendSn;

        /**
         * 渠道返回流水
         * 字节长度: String
         * 必填: 否
         */
        private String channelRecvSn;

        /**
         * 二维码行别
         * 微信-1902000
         * 支付宝-1903000
         * QQ扫码-1904000
         * 银联扫码-9001002
         * 招商银行-3085840
         * 字节长度: String
         * 必填: 否
         */
        private String bankType;

        /**
         * 支付完成时间
         * 格式"yyyy-MM-dd HH:mm:ss"
         * 字节长度: String(19)
         * 必填: 否
         */
        private String paySuccessTime;

        /**
         * 支付宝用户Uid
         * 字节长度: String(128)
         * 必填: 否
         */
        private String buyerUserId;

        /**
         * 卡类型
         * credit:信用卡
         * debit:借记卡
         * 字节长度: String
         * 必填: 否
         */
        private String cardType;

        /**
         * 结果描述
         * 当为快付交易时，该字段为空
         * 字节长度: String
         * 必填: 否
         */
        private String resultNote;

        /**
         * 优惠金额
         * 字节长度: Double
         * 必填: 否
         * 示例值: 1.2
         */
        private BigDecimal preferentialAmount;

        /**
         * 优惠手续费
         * 字节长度: Double
         * 必填: 否
         * 示例值: 0.02
         */
        private BigDecimal preferentialFee;

        /**
         * 营销规则json
         * 字节长度: String
         * 必填: 否
         */
        private String marketingRuleJson;

        /**
         * 付款方账号/银行卡号
         * 脱敏规则：保留前6后4，中间数据*
         * 字节长度: String
         * 必填: 否
         */
        private String payerBankAccountNo;

        /**
         * 付款方账户户名
         * 字节长度: String
         * 必填: 否
         */
        private String payerBankAccountName;

        /**
         * 是否参与优惠
         * 字节长度: String
         * 必填: 否
         */
        private String isDiscount;

        /**
         * 参考汇总优惠手续费
         * 字节长度: double
         * 必填: 否
         */
        private Double totalDiscountFee;

        /**
         * 微信优惠活动
         * 字节长度: String
         * 必填: 否
         */
        private WxpayCouponInfo wxpayCouponInfo;

        /**
         * 单品列表
         * 必填: 否
         */
        private List<WxpayCouponGoodDetail> wxpayCouponGoodDetail;

        /**
         * 支付宝营销渠道响应优惠信息
         * JSON字符串
         * 字节长度: String(4000)
         * 必填: 否
         */
        private AlipayCouponInfo alipayCouponInfo;

        /**
         * 支付宝营销渠道响应商品详情信息
         * JSON字符串
         * 字节长度: String
         * 必填: 否
         */
        private String alipayCouponGoodDetail;

        /**
         * 银联营销渠道响应优惠信息
         * JSON字符串
         * version小于3.6版本为List的JSON字符串
         * 3.6版本（含）以上为CouponInfo的JSON字符串
         * 字节长度: String(4000)
         * 必填: 否
         */
        private String couponInfo;
    }

    /**
     * 快付明细
     */
    @Data
    public static class QuickPayDetail {
        /**
         * 快付状态
         * 字节长度: String
         * 必填: 是
         * 示例值: TRADE_SUCCESS
         */
        private String status;

        /**
         * 发往渠道的交易时间
         * 格式"yyyy-MM-dd HH:mm:ss"
         * 字节长度: String
         * 必填: 否
         * 示例值: 2019-5-24 09:44:31
         */
        private String sendChannelTime;

        /**
         * 该笔订单的合作方手续费(参考)
         * 单位为RMB-Yuan
         * 取值范围为[0.01，100000000.00]，精确到小数点后两位
         * 当为快付交易时，该字段不能为空
         * 字节长度: String
         * 必填: 否
         */
        private String partnerFee;

        /**
         * 该笔订单的收款方手续费(参考)
         * 单位为RMB-Yuan
         * 取值范围为[0.01，100000000.00]，精确到小数点后两位
         * 当为快付交易时，该字段不能为空
         * 字节长度: String
         * 必填: 否
         */
        private String payeeFee;

        /**
         * 该笔订单的付款方手续费(参考)
         * 单位为RMB-Yuan
         * 取值范围为[0.01，100000000.00]，精确到小数点后两位
         * 当为快付交易时，该字段不能为空
         * 字节长度: String
         * 必填: 否
         */
        private String payerFee;

        /**
         * 该笔订单营销后的收款方手续费
         * 单位为RMB-Yuan
         * 取值范围为[0.01，100000000.00]，精确到小数点后两位
         * 字节长度: String
         * 必填: 否
         */
        private String payeeFeeDiscount;

        /**
         * 该笔订单营销后的付款方手续费
         * 单位为RMB-Yuan
         * 取值范围为[0.01，100000000.00]，精确到小数点后两位
         * 字节长度: String
         * 必填: 否
         */
        private String payerFeeDiscount;

        /**
         * 该笔订单营销后的发起方手续费
         * 单位为RMB-Yuan
         * 取值范围为[0.01，100000000.00]，精确到小数点后两位
         * 字节长度: String
         * 必填: 否
         */
        private String srcFeeDiscount;

        /**
         * 是否参与营销
         * 1:参与 其他:不参与
         * 字节长度: String
         * 必填: 否
         */
        private String discountFlag;
    }

    /**
     * 分期信息
     */
    @Data
    public static class InstallmentResp {
        /**
         * 分期期数
         * 允许值：3~99
         * 字节长度: String
         * 必填: 是
         */
        private String installmentNum;

        /**
         * 分期应付手续费
         * 字节长度: Double
         * 必填: 是
         */
        private Double installmentFeeTotal;

        /**
         * 持卡人手续费支付方式
         * 0-一次性支付，1-分期支付
         * 字节长度: String
         * 必填: 是
         */
        private String installmentFeePayMode;

        /**
         * 首期手续费
         * 字节长度: Double
         * 必填: 是
         */
        private Double firstFee;

        /**
         * 每期手续费
         * 字节长度: Double
         * 必填: 是
         */
        private Double eachFee;

        /**
         * 首期还款金额
         * 字节长度: Double
         * 必填: 是
         */
        private Double firstBackAmount;

        /**
         * 商户分期实际贴息费率
         * 字节长度: Double
         * 必填: 否
         */
        private Double realDiscountFeeRate;
    }
} 