package com.fshows.ysepay.model.payment;

import java.util.Date;
import java.util.List;

import lombok.Data;

/**
 * 支付宝优惠信息
 */
@Data
public class AlipayCouponInfo {

    /**
     * 订单金额
     * 单位为元
     * 字节长度: double
     * 必填: 是
     */
    private Double totalAmount;

    /**
     * 商户实收金额
     * 商家在交易中实际收到的款项，单位为元
     * 字节长度: double
     * 必填: 是
     */
    private Double receiptAmount;

    /**
     * 用户实付金额
     * 用户在交易中支付的金额，单位为元
     * 字节长度: double
     * 必填: 是
     */
    private Double buyerPayAmount;

    /**
     * 开票金额
     * 用户在交易中支付的可开具发票的金额
     * 字节长度: double
     * 必填: 是
     */
    private Double invoiceAmount;

    /**
     * 集分宝支付金额
     * 使用集分宝付款的金额
     * 字节长度: double
     * 必填: 否
     */
    private Double pointAmount;

    /**
     * 支付金额信息
     * 字节长度: List
     * 必填: 是
     */
    private List<AlipayFundBill> fundBillList;

    /**
     * 本交易支付时使用的所有优惠券信息
     * 字节长度: List
     * 必填: 否
     */
    private List<AlipayVoucherDetail> voucherDetailList;

    /**
     * 交易支付时间
     * 字节长度: Date
     * 必填: 是
     */
    private Date gmtPayment;
} 