package com.fshows.ysepay.response;

import java.math.BigDecimal;
import java.util.List;

import lombok.Data;
import lombok.EqualsAndHashCode;

/**
 * 银盛支付-退款交易查询响应对象
 */
@Data
@EqualsAndHashCode(callSuper = true)
public class YsepayTradeRefundQueryResponse extends YsepayBizResponse {

    /**
     * 响应代码
     * 字节长度: String
     * 必填: 是
     */
    private String code;

    /**
     * 响应代码描述
     * 字节长度: String
     * 必填: 是
     */
    private String msg;

    /**
     * 银盛支付平台的订单交易流水
     * 字节长度: String(1,30)
     * 必填: 是
     */
    private String tradeNo;

    /**
     * 创建交易传入的商户订单号
     * 字节长度: String(1,32)
     * 必填: 是
     */
    private String outTradeNo;

    /**
     * 本笔退款对应的退款请求号
     * 字节长度: String(1,32)
     * 必填: 是
     */
    private String outRequestNo;

    /**
     * 退款交易状态
     * 成功:success,处理中：in_process,失败：fail
     * 字节长度: String
     * 必填: 是
     */
    private String refundState;

    /**
     * 退款资金状态
     * success: 退款成功
     * in_process: 退款处理中
     * fail_to_manual_deal: 退款失败，待人工处理
     * fail_due_manual_close: 退款失败，人工关闭
     * fail: 退款失败
     * 字节长度: String
     * 必填: 是
     */
    private String fundsState;

    /**
     * 发起退款时，传入的退款原因
     * 字节长度: String(1,50)
     * 必填: 否
     */
    private String refundReason;

    /**
     * 该笔退款所对应的交易的订单金额
     * 字节长度: Number
     * 必填: 否
     */
    private BigDecimal totalAmount;

    /**
     * 本次退款请求，对应的退款金额
     * 字节长度: Number
     * 必填: 否
     */
    private BigDecimal refundAmount;

    /**
     * 退款会计日期
     * 格式"yyyy-MM-dd"
     * 字节长度: String(10)
     * 必填: 否
     */
    private String accountDate;

    /**
     * 营销退款信息
     * 字节长度: String
     * 必填: 否
     */
    private String marktingRefundDetail;

    /**
     * 退款资金动态明细列表
     * 字节长度: String
     * 必填: 否
     */
    private List<RefundChannelFundsDynamic> fundsDynamics;

    /**
     * 分期交易商户实际贴息费率
     * 字节长度: Double
     * 必填: 否
     */
    private Double realDiscountFeeRate;

    /**
     * 发起方计费状态
     * 字节长度: String
     * 必填: 否
     */
    private String srcFeeFlag;

    /**
     * 收款方计费状态
     * 字节长度: String
     * 必填: 否
     */
    private String payeeFeeFlag;

    /**
     * 付款方计费状态
     * 字节长度: String
     * 必填: 否
     */
    private String payerFeeFlag;

    /**
     * 发起方退还手续费
     * 字节长度: Double
     * 必填: 否
     */
    private Double srcFee;

    /**
     * 收款方退还手续费
     * 字节长度: Double
     * 必填: 否
     */
    private Double payeeFee;

    /**
     * 付款方退还手续费
     * 字节长度: Double
     * 必填: 否
     */
    private Double payerFee;

    /**
     * 发起方已退手续费
     * 字节长度: Double
     * 必填: 否
     */
    private Double hasRefundSrcFee;

    /**
     * 收款方已退手续费
     * 字节长度: Double
     * 必填: 否
     */
    private Double hasRefundPayeeFee;

    /**
     * 付方已退手续费
     * 字节长度: Double
     * 必填: 否
     */
    private Double hasRefundPayerFee;

    /**
     * 退款资金动态信息
     */
    @Data
    public static class RefundChannelFundsDynamic {
        /**
         * 退款交易流水
         * 字节长度: String
         * 必填: 是
         * 示例值：RD2012061713107
         */
        private String refundsn;

        /**
         * 本次发往渠道金额
         * 字节长度: BigDecimal
         * 必填: 是
         */
        private BigDecimal refundamount;

        /**
         * 退款资金状态
         * 字节长度: String
         * 必填: 是
         * 示例值：10
         */
        private String state;

        /**
         * 发往渠道流水
         * 字节长度: String
         * 必填: 否
         * 示例值：1012010231551064011
         */
        private String channelSendSn;

        /**
         * 渠道返回流水
         * 字节长度: String
         * 必填: 否
         * 示例值：50100003692020030514951409618
         */
        private String channelRecvSn;

        /**
         * 发往渠道时间
         * 格式 yyyy-MM-dd HH:mm:ss
         * 字节长度: String
         * 必填: 否
         */
        private String sendChannelTime;

        /**
         * 渠道返回时间
         * 格式 yyyy-MM-dd HH:mm:ss
         * 字节长度: String
         * 必填: 否
         */
        private String channelRecvTime;

        /**
         * 营销退款信息（银联）
         * 字节长度: String
         * 必填: 否
         */
        private String couponInfo;

        /**
         * 营销退款信息（微信）
         * 字节长度: String
         * 必填: 否
         */
        private String marketingRefundDetail;
    }
} 