/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.response;

import com.alibaba.fastjson.JSON;
import lombok.Data;
import org.apache.commons.lang3.builder.ToStringBuilder;

import java.io.Serializable;

/**
 * @author wujn
 * @version BaseVbillResponse.java, v 0.1 2020-04-23 4:58 PM wujn
 */
@Data
public class BaseVbillResponse<E extends VbillBizResponse> implements Serializable {
    private static final long serialVersionUID = -6496279028491479418L;
    private String code;
    private String msg;
    private String reqId;
    private String orgId;
    private E respData;


    @Override
    public String toString() {
        return new ToStringBuilder(this)
                .append("code", code)
                .append("msg", msg)
                .append("reqId", reqId)
                .append("orgId", orgId)
                .append("respData", JSON.toJSONString(respData))
                .toString();
    }
}
