/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.request.payment;

import com.fshows.vbill.sdk.request.VbillBizRequest;
import com.fshows.vbill.sdk.response.payment.VbillRefundResponse;
import lombok.Data;

/**
 * 退款入参
 *
 * @author Liluqing
 * @version RefundParam.java, v 0.1 2020-04-23 16:11
 */
@Data
public class VbillRefundRequest extends VbillBizRequest<VbillRefundResponse> {

    /**
     * 商编
     */
    private String mno;

    /**
     * 商户订单号,64个字符以内、只能包含字母、数字、下划线；
     * 需保证在商户端不重复
     */
    private String ordNo;

    /**
     * 原交易商户订单号,64 个字符以内、只能包含字母、数字、下划线；
     * 需保证在商户端不重复
     */
    private String origOrderNo;

    /**
     * 原交易科技公司订单号
     */
    private String origUuid;

    /**
     * 正交易落单号
     */
    private String origSxfUuid;

    /**
     * 退货金额，单元
     */
    private String amt;

    /**
     * 支付结果通知地址
     */
    private String notifyUrl;

    /**
     * 退货原因
     */
    private String refundReason;

    /**
     * 备用
     */
    private String extend;

    @Override
    public Class<VbillRefundResponse> getResponseClass() {
        return VbillRefundResponse.class;
    }
}