/**
 * fshows.com
 * Copyright (C) 2013-2020 All Rights Reserved.
 */
package com.fshows.vbill.sdk.response.payment;

import com.fshows.vbill.sdk.response.VbillBizResponse;
import lombok.Data;

/**
 * @author Liluqing
 * @version VbillRefundResponse.java, v 0.1 2020-06-09 17:33
 */
@Data
public class VbillRefundResponse extends VbillBizResponse {

    /**
     * 商户原订单号
     */
    private String origOrderNo;

    /**
     * 科技公司原订单号
     */
    private String origUuid;

    /**
     * 科技公司订单号
     */
    private String uuid;

    /**
     * 申请退款金额，反交易下单的退款金额
     */
    private String amt;

    /**
     * 代金券退款金额积分支付金额，优惠金额或折扣券的金额
     */
    private String pointAmount;

    /**
     * 优惠券退款信息
     */
    private String refundDetail;

    /**
     * 买家用户号微信是subopenid；支付宝是 userId
     */
    private String buyerId;

    /**
     * 退货原因
     */
    private String refundReason;

    /**
     * 备用
     */
    private String extend;

}